/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Settings> {
    private static final SdkField<Boolean> IS_AWS_ORG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAwsOrgEnabled").getter(Settings.getter(Settings::isAwsOrgEnabled)).setter(Settings.setter(Builder::isAwsOrgEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAwsOrgEnabled").build()}).build();
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopic").getter(Settings.getter(Settings::snsTopic)).setter(Settings.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()}).build();
    private static final SdkField<AssessmentReportsDestination> DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAssessmentReportsDestination").getter(Settings.getter(Settings::defaultAssessmentReportsDestination)).setter(Settings.setter(Builder::defaultAssessmentReportsDestination)).constructor(AssessmentReportsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAssessmentReportsDestination").build()}).build();
    private static final SdkField<List<Role>> DEFAULT_PROCESS_OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultProcessOwners").getter(Settings.getter(Settings::defaultProcessOwners)).setter(Settings.setter(Builder::defaultProcessOwners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultProcessOwners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKey").getter(Settings.getter(Settings::kmsKey)).setter(Settings.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_AWS_ORG_ENABLED_FIELD, SNS_TOPIC_FIELD, DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD, DEFAULT_PROCESS_OWNERS_FIELD, KMS_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isAwsOrgEnabled;
    private final String snsTopic;
    private final AssessmentReportsDestination defaultAssessmentReportsDestination;
    private final List<Role> defaultProcessOwners;
    private final String kmsKey;

    private Settings(BuilderImpl builder) {
        this.isAwsOrgEnabled = builder.isAwsOrgEnabled;
        this.snsTopic = builder.snsTopic;
        this.defaultAssessmentReportsDestination = builder.defaultAssessmentReportsDestination;
        this.defaultProcessOwners = builder.defaultProcessOwners;
        this.kmsKey = builder.kmsKey;
    }

    public final Boolean isAwsOrgEnabled() {
        return this.isAwsOrgEnabled;
    }

    public final String snsTopic() {
        return this.snsTopic;
    }

    public final AssessmentReportsDestination defaultAssessmentReportsDestination() {
        return this.defaultAssessmentReportsDestination;
    }

    public final boolean hasDefaultProcessOwners() {
        return this.defaultProcessOwners != null && !(this.defaultProcessOwners instanceof SdkAutoConstructList);
    }

    public final List<Role> defaultProcessOwners() {
        return this.defaultProcessOwners;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isAwsOrgEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAssessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultProcessOwners() ? this.defaultProcessOwners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)obj;
        return Objects.equals(this.isAwsOrgEnabled(), other.isAwsOrgEnabled()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.defaultAssessmentReportsDestination(), other.defaultAssessmentReportsDestination()) && this.hasDefaultProcessOwners() == other.hasDefaultProcessOwners() && Objects.equals(this.defaultProcessOwners(), other.defaultProcessOwners()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public final String toString() {
        return ToString.builder((String)"Settings").add("IsAwsOrgEnabled", (Object)this.isAwsOrgEnabled()).add("SnsTopic", (Object)this.snsTopic()).add("DefaultAssessmentReportsDestination", (Object)this.defaultAssessmentReportsDestination()).add("DefaultProcessOwners", this.hasDefaultProcessOwners() ? this.defaultProcessOwners() : null).add("KmsKey", (Object)this.kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isAwsOrgEnabled": {
                return Optional.ofNullable(clazz.cast(this.isAwsOrgEnabled()));
            }
            case "snsTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "defaultAssessmentReportsDestination": {
                return Optional.ofNullable(clazz.cast(this.defaultAssessmentReportsDestination()));
            }
            case "defaultProcessOwners": {
                return Optional.ofNullable(clazz.cast(this.defaultProcessOwners()));
            }
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isAwsOrgEnabled;
        private String snsTopic;
        private AssessmentReportsDestination defaultAssessmentReportsDestination;
        private List<Role> defaultProcessOwners = DefaultSdkAutoConstructList.getInstance();
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            this.isAwsOrgEnabled(model.isAwsOrgEnabled);
            this.snsTopic(model.snsTopic);
            this.defaultAssessmentReportsDestination(model.defaultAssessmentReportsDestination);
            this.defaultProcessOwners(model.defaultProcessOwners);
            this.kmsKey(model.kmsKey);
        }

        public final Boolean getIsAwsOrgEnabled() {
            return this.isAwsOrgEnabled;
        }

        public final void setIsAwsOrgEnabled(Boolean isAwsOrgEnabled) {
            this.isAwsOrgEnabled = isAwsOrgEnabled;
        }

        @Override
        @Transient
        public final Builder isAwsOrgEnabled(Boolean isAwsOrgEnabled) {
            this.isAwsOrgEnabled = isAwsOrgEnabled;
            return this;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        @Transient
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final AssessmentReportsDestination.Builder getDefaultAssessmentReportsDestination() {
            return this.defaultAssessmentReportsDestination != null ? this.defaultAssessmentReportsDestination.toBuilder() : null;
        }

        public final void setDefaultAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination;
            return this;
        }

        public final List<Role.Builder> getDefaultProcessOwners() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.defaultProcessOwners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultProcessOwners(Collection<Role.BuilderImpl> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copyFromBuilder(defaultProcessOwners);
        }

        @Override
        @Transient
        public final Builder defaultProcessOwners(Collection<Role> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copy(defaultProcessOwners);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultProcessOwners(Role ... defaultProcessOwners) {
            this.defaultProcessOwners(Arrays.asList(defaultProcessOwners));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultProcessOwners(Consumer<Role.Builder> ... defaultProcessOwners) {
            this.defaultProcessOwners(Stream.of(defaultProcessOwners).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        @Transient
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public Settings build() {
            return new Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Settings> {
        public Builder isAwsOrgEnabled(Boolean var1);

        public Builder snsTopic(String var1);

        public Builder defaultAssessmentReportsDestination(AssessmentReportsDestination var1);

        default public Builder defaultAssessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> defaultAssessmentReportsDestination) {
            return this.defaultAssessmentReportsDestination((AssessmentReportsDestination)((AssessmentReportsDestination.Builder)AssessmentReportsDestination.builder().applyMutation(defaultAssessmentReportsDestination)).build());
        }

        public Builder defaultProcessOwners(Collection<Role> var1);

        public Builder defaultProcessOwners(Role ... var1);

        public Builder defaultProcessOwners(Consumer<Role.Builder> ... var1);

        public Builder kmsKey(String var1);
    }
}

