/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RoleType {
    PROCESS_OWNER("PROCESS_OWNER"),
    RESOURCE_OWNER("RESOURCE_OWNER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RoleType> VALUE_MAP;
    private final String value;

    private RoleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoleType> knownValues() {
        EnumSet<RoleType> knownValues = EnumSet.allOf(RoleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RoleType.class, RoleType::toString);
    }
}

