/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet;
import software.amazon.awssdk.services.auditmanager.model.AssessmentControlSetsCopier;
import software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentFramework
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentFramework> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssessmentFramework.getter(AssessmentFramework::id)).setter(AssessmentFramework.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AssessmentFramework.getter(AssessmentFramework::arn)).setter(AssessmentFramework.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<FrameworkMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(AssessmentFramework.getter(AssessmentFramework::metadata)).setter(AssessmentFramework.setter(Builder::metadata)).constructor(FrameworkMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<List<AssessmentControlSet>> CONTROL_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlSets").getter(AssessmentFramework.getter(AssessmentFramework::controlSets)).setter(AssessmentFramework.setter(Builder::controlSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentControlSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, METADATA_FIELD, CONTROL_SETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final FrameworkMetadata metadata;
    private final List<AssessmentControlSet> controlSets;

    private AssessmentFramework(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.metadata = builder.metadata;
        this.controlSets = builder.controlSets;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final FrameworkMetadata metadata() {
        return this.metadata;
    }

    public final boolean hasControlSets() {
        return this.controlSets != null && !(this.controlSets instanceof SdkAutoConstructList);
    }

    public final List<AssessmentControlSet> controlSets() {
        return this.controlSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlSets() ? this.controlSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFramework)) {
            return false;
        }
        AssessmentFramework other = (AssessmentFramework)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.metadata(), other.metadata()) && this.hasControlSets() == other.hasControlSets() && Objects.equals(this.controlSets(), other.controlSets());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentFramework").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Metadata", (Object)this.metadata()).add("ControlSets", this.hasControlSets() ? this.controlSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "controlSets": {
                return Optional.ofNullable(clazz.cast(this.controlSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFramework, T> g) {
        return obj -> g.apply((AssessmentFramework)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private FrameworkMetadata metadata;
        private List<AssessmentControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFramework model) {
            this.id(model.id);
            this.arn(model.arn);
            this.metadata(model.metadata);
            this.controlSets(model.controlSets);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final FrameworkMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(FrameworkMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(FrameworkMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final List<AssessmentControlSet.Builder> getControlSets() {
            List<AssessmentControlSet.Builder> result = AssessmentControlSetsCopier.copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlSets(Collection<AssessmentControlSet.BuilderImpl> controlSets) {
            this.controlSets = AssessmentControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        @Transient
        public final Builder controlSets(Collection<AssessmentControlSet> controlSets) {
            this.controlSets = AssessmentControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlSets(AssessmentControlSet ... controlSets) {
            this.controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlSets(Consumer<AssessmentControlSet.Builder> ... controlSets) {
            this.controlSets(Stream.of(controlSets).map(c -> (AssessmentControlSet)((AssessmentControlSet.Builder)AssessmentControlSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssessmentFramework build() {
            return new AssessmentFramework(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentFramework> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder metadata(FrameworkMetadata var1);

        default public Builder metadata(Consumer<FrameworkMetadata.Builder> metadata) {
            return this.metadata((FrameworkMetadata)((FrameworkMetadata.Builder)FrameworkMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder controlSets(Collection<AssessmentControlSet> var1);

        public Builder controlSets(AssessmentControlSet ... var1);

        public Builder controlSets(Consumer<AssessmentControlSet.Builder> ... var1);
    }
}

