/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentFrameworkShareResponse extends AuditManagerResponse implements
        ToCopyableBuilder<UpdateAssessmentFrameworkShareResponse.Builder, UpdateAssessmentFrameworkShareResponse> {
    private static final SdkField<AssessmentFrameworkShareRequest> ASSESSMENT_FRAMEWORK_SHARE_REQUEST_FIELD = SdkField
            .<AssessmentFrameworkShareRequest> builder(MarshallingType.SDK_POJO)
            .memberName("assessmentFrameworkShareRequest")
            .getter(getter(UpdateAssessmentFrameworkShareResponse::assessmentFrameworkShareRequest))
            .setter(setter(Builder::assessmentFrameworkShareRequest))
            .constructor(AssessmentFrameworkShareRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentFrameworkShareRequest")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ASSESSMENT_FRAMEWORK_SHARE_REQUEST_FIELD));

    private final AssessmentFrameworkShareRequest assessmentFrameworkShareRequest;

    private UpdateAssessmentFrameworkShareResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentFrameworkShareRequest = builder.assessmentFrameworkShareRequest;
    }

    /**
     * <p>
     * The updated share request that's returned by the <code>UpdateAssessmentFrameworkShare</code> operation.
     * </p>
     * 
     * @return The updated share request that's returned by the <code>UpdateAssessmentFrameworkShare</code> operation.
     */
    public final AssessmentFrameworkShareRequest assessmentFrameworkShareRequest() {
        return assessmentFrameworkShareRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentFrameworkShareRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentFrameworkShareResponse)) {
            return false;
        }
        UpdateAssessmentFrameworkShareResponse other = (UpdateAssessmentFrameworkShareResponse) obj;
        return Objects.equals(assessmentFrameworkShareRequest(), other.assessmentFrameworkShareRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentFrameworkShareResponse")
                .add("AssessmentFrameworkShareRequest", assessmentFrameworkShareRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentFrameworkShareRequest":
            return Optional.ofNullable(clazz.cast(assessmentFrameworkShareRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentFrameworkShareResponse, T> g) {
        return obj -> g.apply((UpdateAssessmentFrameworkShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssessmentFrameworkShareResponse> {
        /**
         * <p>
         * The updated share request that's returned by the <code>UpdateAssessmentFrameworkShare</code> operation.
         * </p>
         * 
         * @param assessmentFrameworkShareRequest
         *        The updated share request that's returned by the <code>UpdateAssessmentFrameworkShare</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentFrameworkShareRequest(AssessmentFrameworkShareRequest assessmentFrameworkShareRequest);

        /**
         * <p>
         * The updated share request that's returned by the <code>UpdateAssessmentFrameworkShare</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link AssessmentFrameworkShareRequest.Builder}
         * avoiding the need to create one manually via {@link AssessmentFrameworkShareRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentFrameworkShareRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #assessmentFrameworkShareRequest(AssessmentFrameworkShareRequest)}.
         * 
         * @param assessmentFrameworkShareRequest
         *        a consumer that will call methods on {@link AssessmentFrameworkShareRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentFrameworkShareRequest(AssessmentFrameworkShareRequest)
         */
        default Builder assessmentFrameworkShareRequest(
                Consumer<AssessmentFrameworkShareRequest.Builder> assessmentFrameworkShareRequest) {
            return assessmentFrameworkShareRequest(AssessmentFrameworkShareRequest.builder()
                    .applyMutation(assessmentFrameworkShareRequest).build());
        }
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private AssessmentFrameworkShareRequest assessmentFrameworkShareRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentFrameworkShareResponse model) {
            super(model);
            assessmentFrameworkShareRequest(model.assessmentFrameworkShareRequest);
        }

        public final AssessmentFrameworkShareRequest.Builder getAssessmentFrameworkShareRequest() {
            return assessmentFrameworkShareRequest != null ? assessmentFrameworkShareRequest.toBuilder() : null;
        }

        public final void setAssessmentFrameworkShareRequest(
                AssessmentFrameworkShareRequest.BuilderImpl assessmentFrameworkShareRequest) {
            this.assessmentFrameworkShareRequest = assessmentFrameworkShareRequest != null ? assessmentFrameworkShareRequest
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder assessmentFrameworkShareRequest(AssessmentFrameworkShareRequest assessmentFrameworkShareRequest) {
            this.assessmentFrameworkShareRequest = assessmentFrameworkShareRequest;
            return this;
        }

        @Override
        public UpdateAssessmentFrameworkShareResponse build() {
            return new UpdateAssessmentFrameworkShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
