/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateDelegationByAssessmentResponse extends AuditManagerResponse implements
        ToCopyableBuilder<BatchCreateDelegationByAssessmentResponse.Builder, BatchCreateDelegationByAssessmentResponse> {
    private static final SdkField<List<Delegation>> DELEGATIONS_FIELD = SdkField
            .<List<Delegation>> builder(MarshallingType.LIST)
            .memberName("delegations")
            .getter(getter(BatchCreateDelegationByAssessmentResponse::delegations))
            .setter(setter(Builder::delegations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Delegation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Delegation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchCreateDelegationByAssessmentError>> ERRORS_FIELD = SdkField
            .<List<BatchCreateDelegationByAssessmentError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchCreateDelegationByAssessmentResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateDelegationByAssessmentError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateDelegationByAssessmentError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATIONS_FIELD,
            ERRORS_FIELD));

    private final List<Delegation> delegations;

    private final List<BatchCreateDelegationByAssessmentError> errors;

    private BatchCreateDelegationByAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.delegations = builder.delegations;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Delegations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDelegations() {
        return delegations != null && !(delegations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The delegations associated with the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDelegations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The delegations associated with the assessment.
     */
    public final List<Delegation> delegations() {
        return delegations;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
     */
    public final List<BatchCreateDelegationByAssessmentError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDelegations() ? delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDelegationByAssessmentResponse)) {
            return false;
        }
        BatchCreateDelegationByAssessmentResponse other = (BatchCreateDelegationByAssessmentResponse) obj;
        return hasDelegations() == other.hasDelegations() && Objects.equals(delegations(), other.delegations())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateDelegationByAssessmentResponse")
                .add("Delegations", hasDelegations() ? delegations() : null).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegations":
            return Optional.ofNullable(clazz.cast(delegations()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDelegationByAssessmentResponse, T> g) {
        return obj -> g.apply((BatchCreateDelegationByAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateDelegationByAssessmentResponse> {
        /**
         * <p>
         * The delegations associated with the assessment.
         * </p>
         * 
         * @param delegations
         *        The delegations associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegations(Collection<Delegation> delegations);

        /**
         * <p>
         * The delegations associated with the assessment.
         * </p>
         * 
         * @param delegations
         *        The delegations associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegations(Delegation... delegations);

        /**
         * <p>
         * The delegations associated with the assessment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Delegation>.Builder} avoiding the need to
         * create one manually via {@link List<Delegation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Delegation>.Builder#build()} is called immediately and its
         * result is passed to {@link #delegations(List<Delegation>)}.
         * 
         * @param delegations
         *        a consumer that will call methods on {@link List<Delegation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegations(List<Delegation>)
         */
        Builder delegations(Consumer<Delegation.Builder>... delegations);

        /**
         * <p>
         * A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * </p>
         * 
         * @param errors
         *        A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchCreateDelegationByAssessmentError> errors);

        /**
         * <p>
         * A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * </p>
         * 
         * @param errors
         *        A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchCreateDelegationByAssessmentError... errors);

        /**
         * <p>
         * A list of errors returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchCreateDelegationByAssessmentError>.Builder} avoiding the need to create one manually via {@link List
         * <BatchCreateDelegationByAssessmentError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchCreateDelegationByAssessmentError>.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchCreateDelegationByAssessmentError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchCreateDelegationByAssessmentError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchCreateDelegationByAssessmentError>)
         */
        Builder errors(Consumer<BatchCreateDelegationByAssessmentError.Builder>... errors);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<Delegation> delegations = DefaultSdkAutoConstructList.getInstance();

        private List<BatchCreateDelegationByAssessmentError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDelegationByAssessmentResponse model) {
            super(model);
            delegations(model.delegations);
            errors(model.errors);
        }

        public final List<Delegation.Builder> getDelegations() {
            List<Delegation.Builder> result = DelegationsCopier.copyToBuilder(this.delegations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegations(Collection<Delegation.BuilderImpl> delegations) {
            this.delegations = DelegationsCopier.copyFromBuilder(delegations);
        }

        @Override
        @Transient
        public final Builder delegations(Collection<Delegation> delegations) {
            this.delegations = DelegationsCopier.copy(delegations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder delegations(Delegation... delegations) {
            delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder delegations(Consumer<Delegation.Builder>... delegations) {
            delegations(Stream.of(delegations).map(c -> Delegation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchCreateDelegationByAssessmentError.Builder> getErrors() {
            List<BatchCreateDelegationByAssessmentError.Builder> result = BatchCreateDelegationByAssessmentErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchCreateDelegationByAssessmentError.BuilderImpl> errors) {
            this.errors = BatchCreateDelegationByAssessmentErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<BatchCreateDelegationByAssessmentError> errors) {
            this.errors = BatchCreateDelegationByAssessmentErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(BatchCreateDelegationByAssessmentError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateDelegationByAssessmentError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchCreateDelegationByAssessmentError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateDelegationByAssessmentResponse build() {
            return new BatchCreateDelegationByAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
