/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentFrameworkRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateAssessmentFrameworkRequest.Builder, UpdateAssessmentFrameworkRequest> {
    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameworkId").getter(getter(UpdateAssessmentFrameworkRequest::frameworkId))
            .setter(setter(Builder::frameworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("frameworkId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAssessmentFrameworkRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAssessmentFrameworkRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(UpdateAssessmentFrameworkRequest::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final SdkField<List<UpdateAssessmentFrameworkControlSet>> CONTROL_SETS_FIELD = SdkField
            .<List<UpdateAssessmentFrameworkControlSet>> builder(MarshallingType.LIST)
            .memberName("controlSets")
            .getter(getter(UpdateAssessmentFrameworkRequest::controlSets))
            .setter(setter(Builder::controlSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateAssessmentFrameworkControlSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateAssessmentFrameworkControlSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, COMPLIANCE_TYPE_FIELD, CONTROL_SETS_FIELD));

    private final String frameworkId;

    private final String name;

    private final String description;

    private final String complianceType;

    private final List<UpdateAssessmentFrameworkControlSet> controlSets;

    private UpdateAssessmentFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkId = builder.frameworkId;
        this.name = builder.name;
        this.description = builder.description;
        this.complianceType = builder.complianceType;
        this.controlSets = builder.controlSets;
    }

    /**
     * <p>
     * The identifier for the specified framework.
     * </p>
     * 
     * @return The identifier for the specified framework.
     */
    public final String frameworkId() {
        return frameworkId;
    }

    /**
     * <p>
     * The name of the framework to be updated.
     * </p>
     * 
     * @return The name of the framework to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the framework that is to be updated.
     * </p>
     * 
     * @return The description of the framework that is to be updated.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     * </p>
     * 
     * @return The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * Returns true if the ControlSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasControlSets() {
        return controlSets != null && !(controlSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The control sets associated with the framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasControlSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The control sets associated with the framework.
     */
    public final List<UpdateAssessmentFrameworkControlSet> controlSets() {
        return controlSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlSets() ? controlSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentFrameworkRequest)) {
            return false;
        }
        UpdateAssessmentFrameworkRequest other = (UpdateAssessmentFrameworkRequest) obj;
        return Objects.equals(frameworkId(), other.frameworkId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(complianceType(), other.complianceType())
                && hasControlSets() == other.hasControlSets() && Objects.equals(controlSets(), other.controlSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentFrameworkRequest").add("FrameworkId", frameworkId()).add("Name", name())
                .add("Description", description()).add("ComplianceType", complianceType())
                .add("ControlSets", hasControlSets() ? controlSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frameworkId":
            return Optional.ofNullable(clazz.cast(frameworkId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "controlSets":
            return Optional.ofNullable(clazz.cast(controlSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentFrameworkRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentFrameworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssessmentFrameworkRequest> {
        /**
         * <p>
         * The identifier for the specified framework.
         * </p>
         * 
         * @param frameworkId
         *        The identifier for the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkId(String frameworkId);

        /**
         * <p>
         * The name of the framework to be updated.
         * </p>
         * 
         * @param name
         *        The name of the framework to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the framework that is to be updated.
         * </p>
         * 
         * @param description
         *        The description of the framework that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(Collection<UpdateAssessmentFrameworkControlSet> controlSets);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(UpdateAssessmentFrameworkControlSet... controlSets);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <UpdateAssessmentFrameworkControlSet>.Builder} avoiding the need to create one manually via {@link List
         * <UpdateAssessmentFrameworkControlSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateAssessmentFrameworkControlSet>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #controlSets(List<UpdateAssessmentFrameworkControlSet>)}.
         * 
         * @param controlSets
         *        a consumer that will call methods on {@link List<UpdateAssessmentFrameworkControlSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlSets(List<UpdateAssessmentFrameworkControlSet>)
         */
        Builder controlSets(Consumer<UpdateAssessmentFrameworkControlSet.Builder>... controlSets);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String frameworkId;

        private String name;

        private String description;

        private String complianceType;

        private List<UpdateAssessmentFrameworkControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentFrameworkRequest model) {
            super(model);
            frameworkId(model.frameworkId);
            name(model.name);
            description(model.description);
            complianceType(model.complianceType);
            controlSets(model.controlSets);
        }

        public final String getFrameworkId() {
            return frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        @Transient
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final List<UpdateAssessmentFrameworkControlSet.Builder> getControlSets() {
            List<UpdateAssessmentFrameworkControlSet.Builder> result = UpdateAssessmentFrameworkControlSetsCopier
                    .copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlSets(Collection<UpdateAssessmentFrameworkControlSet.BuilderImpl> controlSets) {
            this.controlSets = UpdateAssessmentFrameworkControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        @Transient
        public final Builder controlSets(Collection<UpdateAssessmentFrameworkControlSet> controlSets) {
            this.controlSets = UpdateAssessmentFrameworkControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlSets(UpdateAssessmentFrameworkControlSet... controlSets) {
            controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlSets(Consumer<UpdateAssessmentFrameworkControlSet.Builder>... controlSets) {
            controlSets(Stream.of(controlSets).map(c -> UpdateAssessmentFrameworkControlSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentFrameworkRequest build() {
            return new UpdateAssessmentFrameworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
