/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SettingAttribute {
    ALL("ALL"),
    IS_AWS_ORG_ENABLED("IS_AWS_ORG_ENABLED"),
    SNS_TOPIC("SNS_TOPIC"),
    DEFAULT_ASSESSMENT_REPORTS_DESTINATION("DEFAULT_ASSESSMENT_REPORTS_DESTINATION"),
    DEFAULT_PROCESS_OWNERS("DEFAULT_PROCESS_OWNERS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SettingAttribute> VALUE_MAP;
    private final String value;

    private SettingAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SettingAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SettingAttribute> knownValues() {
        EnumSet<SettingAttribute> knownValues = EnumSet.allOf(SettingAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SettingAttribute.class, SettingAttribute::toString);
    }
}

