/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentReportsResponse extends AuditManagerResponse implements
        ToCopyableBuilder<ListAssessmentReportsResponse.Builder, ListAssessmentReportsResponse> {
    private static final SdkField<List<AssessmentReportMetadata>> ASSESSMENT_REPORTS_FIELD = SdkField
            .<List<AssessmentReportMetadata>> builder(MarshallingType.LIST)
            .memberName("assessmentReports")
            .getter(getter(ListAssessmentReportsResponse::assessmentReports))
            .setter(setter(Builder::assessmentReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentReportMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentReportMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentReportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_REPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssessmentReportMetadata> assessmentReports;

    private final String nextToken;

    private ListAssessmentReportsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentReports = builder.assessmentReports;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AssessmentReports property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAssessmentReports() {
        return assessmentReports != null && !(assessmentReports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssessmentReports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
     */
    public final List<AssessmentReportMetadata> assessmentReports() {
        return assessmentReports;
    }

    /**
     * <p>
     * The pagination token used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentReports() ? assessmentReports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentReportsResponse)) {
            return false;
        }
        ListAssessmentReportsResponse other = (ListAssessmentReportsResponse) obj;
        return hasAssessmentReports() == other.hasAssessmentReports()
                && Objects.equals(assessmentReports(), other.assessmentReports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentReportsResponse")
                .add("AssessmentReports", hasAssessmentReports() ? assessmentReports() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentReports":
            return Optional.ofNullable(clazz.cast(assessmentReports()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentReportsResponse, T> g) {
        return obj -> g.apply((ListAssessmentReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssessmentReportsResponse> {
        /**
         * <p>
         * The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
         * </p>
         * 
         * @param assessmentReports
         *        The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReports(Collection<AssessmentReportMetadata> assessmentReports);

        /**
         * <p>
         * The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
         * </p>
         * 
         * @param assessmentReports
         *        The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReports(AssessmentReportMetadata... assessmentReports);

        /**
         * <p>
         * The list of assessment reports returned by the <code>ListAssessmentReports</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssessmentReportMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<AssessmentReportMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentReportMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentReports(List<AssessmentReportMetadata>)}.
         * 
         * @param assessmentReports
         *        a consumer that will call methods on {@link List<AssessmentReportMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentReports(List<AssessmentReportMetadata>)
         */
        Builder assessmentReports(Consumer<AssessmentReportMetadata.Builder>... assessmentReports);

        /**
         * <p>
         * The pagination token used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<AssessmentReportMetadata> assessmentReports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentReportsResponse model) {
            super(model);
            assessmentReports(model.assessmentReports);
            nextToken(model.nextToken);
        }

        public final List<AssessmentReportMetadata.Builder> getAssessmentReports() {
            List<AssessmentReportMetadata.Builder> result = AssessmentReportsMetadataCopier.copyToBuilder(this.assessmentReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentReports(Collection<AssessmentReportMetadata.BuilderImpl> assessmentReports) {
            this.assessmentReports = AssessmentReportsMetadataCopier.copyFromBuilder(assessmentReports);
        }

        @Override
        @Transient
        public final Builder assessmentReports(Collection<AssessmentReportMetadata> assessmentReports) {
            this.assessmentReports = AssessmentReportsMetadataCopier.copy(assessmentReports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentReports(AssessmentReportMetadata... assessmentReports) {
            assessmentReports(Arrays.asList(assessmentReports));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentReports(Consumer<AssessmentReportMetadata.Builder>... assessmentReports) {
            assessmentReports(Stream.of(assessmentReports).map(c -> AssessmentReportMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentReportsResponse build() {
            return new ListAssessmentReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
