/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the latest analytics data for all your active assessments.
 * </p>
 * <p>
 * This summary is a snapshot of the data that your active assessments collected on the <code>lastUpdated</code> date.
 * It’s important to understand that the following totals are daily counts based on this date — they aren’t a total sum
 * to date.
 * </p>
 * <p>
 * The <code>Insights</code> data is eventually consistent. This means that, when you read data from
 * <code>Insights</code>, the response might not instantly reflect the results of a recently completed write or update
 * operation. If you repeat your read request after a few hours, the response should return the latest data.
 * </p>
 * <note>
 * <p>
 * If you delete an assessment or change its status to inactive, <code>InsightsByAssessment</code> includes data for
 * that assessment as follows.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Inactive assessments</b> - If Audit Manager collected evidence for your assessment before you changed it inactive,
 * that evidence is included in the <code>InsightsByAssessment</code> counts for that day.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deleted assessments</b> - If Audit Manager collected evidence for your assessment before you deleted it, that
 * evidence isn't included in the <code>InsightsByAssessment</code> counts for that day.
 * </p>
 * </li>
 * </ul>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Insights implements SdkPojo, Serializable, ToCopyableBuilder<Insights.Builder, Insights> {
    private static final SdkField<Integer> ACTIVE_ASSESSMENTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("activeAssessmentsCount").getter(getter(Insights::activeAssessmentsCount))
            .setter(setter(Builder::activeAssessmentsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAssessmentsCount").build())
            .build();

    private static final SdkField<Integer> NONCOMPLIANT_EVIDENCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("noncompliantEvidenceCount")
            .getter(getter(Insights::noncompliantEvidenceCount)).setter(setter(Builder::noncompliantEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noncompliantEvidenceCount").build())
            .build();

    private static final SdkField<Integer> COMPLIANT_EVIDENCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("compliantEvidenceCount").getter(getter(Insights::compliantEvidenceCount))
            .setter(setter(Builder::compliantEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliantEvidenceCount").build())
            .build();

    private static final SdkField<Integer> INCONCLUSIVE_EVIDENCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("inconclusiveEvidenceCount")
            .getter(getter(Insights::inconclusiveEvidenceCount)).setter(setter(Builder::inconclusiveEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inconclusiveEvidenceCount").build())
            .build();

    private static final SdkField<Integer> ASSESSMENT_CONTROLS_COUNT_BY_NONCOMPLIANT_EVIDENCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("assessmentControlsCountByNoncompliantEvidence")
            .getter(getter(Insights::assessmentControlsCountByNoncompliantEvidence))
            .setter(setter(Builder::assessmentControlsCountByNoncompliantEvidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("assessmentControlsCountByNoncompliantEvidence").build()).build();

    private static final SdkField<Integer> TOTAL_ASSESSMENT_CONTROLS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalAssessmentControlsCount")
            .getter(getter(Insights::totalAssessmentControlsCount))
            .setter(setter(Builder::totalAssessmentControlsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalAssessmentControlsCount")
                    .build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(Insights::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_ASSESSMENTS_COUNT_FIELD, NONCOMPLIANT_EVIDENCE_COUNT_FIELD, COMPLIANT_EVIDENCE_COUNT_FIELD,
            INCONCLUSIVE_EVIDENCE_COUNT_FIELD, ASSESSMENT_CONTROLS_COUNT_BY_NONCOMPLIANT_EVIDENCE_FIELD,
            TOTAL_ASSESSMENT_CONTROLS_COUNT_FIELD, LAST_UPDATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer activeAssessmentsCount;

    private final Integer noncompliantEvidenceCount;

    private final Integer compliantEvidenceCount;

    private final Integer inconclusiveEvidenceCount;

    private final Integer assessmentControlsCountByNoncompliantEvidence;

    private final Integer totalAssessmentControlsCount;

    private final Instant lastUpdated;

    private Insights(BuilderImpl builder) {
        this.activeAssessmentsCount = builder.activeAssessmentsCount;
        this.noncompliantEvidenceCount = builder.noncompliantEvidenceCount;
        this.compliantEvidenceCount = builder.compliantEvidenceCount;
        this.inconclusiveEvidenceCount = builder.inconclusiveEvidenceCount;
        this.assessmentControlsCountByNoncompliantEvidence = builder.assessmentControlsCountByNoncompliantEvidence;
        this.totalAssessmentControlsCount = builder.totalAssessmentControlsCount;
        this.lastUpdated = builder.lastUpdated;
    }

    /**
     * <p>
     * The number of active assessments in Audit Manager.
     * </p>
     * 
     * @return The number of active assessments in Audit Manager.
     */
    public final Integer activeAssessmentsCount() {
        return activeAssessmentsCount;
    }

    /**
     * <p>
     * The number of compliance check evidence that Audit Manager classified as non-compliant on the
     * <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a <i>Fail</i>
     * ruling, or collected from Config with a <i>Non-compliant</i> ruling.
     * </p>
     * 
     * @return The number of compliance check evidence that Audit Manager classified as non-compliant on the
     *         <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a
     *         <i>Fail</i> ruling, or collected from Config with a <i>Non-compliant</i> ruling.
     */
    public final Integer noncompliantEvidenceCount() {
        return noncompliantEvidenceCount;
    }

    /**
     * <p>
     * The number of compliance check evidence that Audit Manager classified as compliant on the
     * <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a <i>Pass</i>
     * ruling, or collected from Config with a <i>Compliant</i> ruling.
     * </p>
     * 
     * @return The number of compliance check evidence that Audit Manager classified as compliant on the
     *         <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a
     *         <i>Pass</i> ruling, or collected from Config with a <i>Compliant</i> ruling.
     */
    public final Integer compliantEvidenceCount() {
        return compliantEvidenceCount;
    }

    /**
     * <p>
     * The number of evidence without a compliance check ruling. Evidence is inconclusive when the associated control
     * uses Security Hub or Config as a data source but you didn't enable those services. This is also the case when a
     * control uses a data source that doesn’t support compliance checks (for example: manual evidence, API calls, or
     * CloudTrail).
     * </p>
     * <note>
     * <p>
     * If evidence has a compliance check status of <i>not applicable</i>, it's classed as <i>inconclusive</i> in
     * <code>Insights</code> data.
     * </p>
     * </note>
     * 
     * @return The number of evidence without a compliance check ruling. Evidence is inconclusive when the associated
     *         control uses Security Hub or Config as a data source but you didn't enable those services. This is also
     *         the case when a control uses a data source that doesn’t support compliance checks (for example: manual
     *         evidence, API calls, or CloudTrail). </p> <note>
     *         <p>
     *         If evidence has a compliance check status of <i>not applicable</i>, it's classed as <i>inconclusive</i>
     *         in <code>Insights</code> data.
     *         </p>
     */
    public final Integer inconclusiveEvidenceCount() {
        return inconclusiveEvidenceCount;
    }

    /**
     * <p>
     * The number of assessment controls that collected non-compliant evidence on the <code>lastUpdated</code> date.
     * </p>
     * 
     * @return The number of assessment controls that collected non-compliant evidence on the <code>lastUpdated</code>
     *         date.
     */
    public final Integer assessmentControlsCountByNoncompliantEvidence() {
        return assessmentControlsCountByNoncompliantEvidence;
    }

    /**
     * <p>
     * The total number of controls across all active assessments.
     * </p>
     * 
     * @return The total number of controls across all active assessments.
     */
    public final Integer totalAssessmentControlsCount() {
        return totalAssessmentControlsCount;
    }

    /**
     * <p>
     * The time when the cross-assessment insights were last updated.
     * </p>
     * 
     * @return The time when the cross-assessment insights were last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeAssessmentsCount());
        hashCode = 31 * hashCode + Objects.hashCode(noncompliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(inconclusiveEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentControlsCountByNoncompliantEvidence());
        hashCode = 31 * hashCode + Objects.hashCode(totalAssessmentControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insights)) {
            return false;
        }
        Insights other = (Insights) obj;
        return Objects.equals(activeAssessmentsCount(), other.activeAssessmentsCount())
                && Objects.equals(noncompliantEvidenceCount(), other.noncompliantEvidenceCount())
                && Objects.equals(compliantEvidenceCount(), other.compliantEvidenceCount())
                && Objects.equals(inconclusiveEvidenceCount(), other.inconclusiveEvidenceCount())
                && Objects.equals(assessmentControlsCountByNoncompliantEvidence(),
                        other.assessmentControlsCountByNoncompliantEvidence())
                && Objects.equals(totalAssessmentControlsCount(), other.totalAssessmentControlsCount())
                && Objects.equals(lastUpdated(), other.lastUpdated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Insights").add("ActiveAssessmentsCount", activeAssessmentsCount())
                .add("NoncompliantEvidenceCount", noncompliantEvidenceCount())
                .add("CompliantEvidenceCount", compliantEvidenceCount())
                .add("InconclusiveEvidenceCount", inconclusiveEvidenceCount())
                .add("AssessmentControlsCountByNoncompliantEvidence", assessmentControlsCountByNoncompliantEvidence())
                .add("TotalAssessmentControlsCount", totalAssessmentControlsCount()).add("LastUpdated", lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeAssessmentsCount":
            return Optional.ofNullable(clazz.cast(activeAssessmentsCount()));
        case "noncompliantEvidenceCount":
            return Optional.ofNullable(clazz.cast(noncompliantEvidenceCount()));
        case "compliantEvidenceCount":
            return Optional.ofNullable(clazz.cast(compliantEvidenceCount()));
        case "inconclusiveEvidenceCount":
            return Optional.ofNullable(clazz.cast(inconclusiveEvidenceCount()));
        case "assessmentControlsCountByNoncompliantEvidence":
            return Optional.ofNullable(clazz.cast(assessmentControlsCountByNoncompliantEvidence()));
        case "totalAssessmentControlsCount":
            return Optional.ofNullable(clazz.cast(totalAssessmentControlsCount()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Insights, T> g) {
        return obj -> g.apply((Insights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Insights> {
        /**
         * <p>
         * The number of active assessments in Audit Manager.
         * </p>
         * 
         * @param activeAssessmentsCount
         *        The number of active assessments in Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAssessmentsCount(Integer activeAssessmentsCount);

        /**
         * <p>
         * The number of compliance check evidence that Audit Manager classified as non-compliant on the
         * <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a <i>Fail</i>
         * ruling, or collected from Config with a <i>Non-compliant</i> ruling.
         * </p>
         * 
         * @param noncompliantEvidenceCount
         *        The number of compliance check evidence that Audit Manager classified as non-compliant on the
         *        <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a
         *        <i>Fail</i> ruling, or collected from Config with a <i>Non-compliant</i> ruling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncompliantEvidenceCount(Integer noncompliantEvidenceCount);

        /**
         * <p>
         * The number of compliance check evidence that Audit Manager classified as compliant on the
         * <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a <i>Pass</i>
         * ruling, or collected from Config with a <i>Compliant</i> ruling.
         * </p>
         * 
         * @param compliantEvidenceCount
         *        The number of compliance check evidence that Audit Manager classified as compliant on the
         *        <code>lastUpdated</code> date. This includes evidence that was collected from Security Hub with a
         *        <i>Pass</i> ruling, or collected from Config with a <i>Compliant</i> ruling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantEvidenceCount(Integer compliantEvidenceCount);

        /**
         * <p>
         * The number of evidence without a compliance check ruling. Evidence is inconclusive when the associated
         * control uses Security Hub or Config as a data source but you didn't enable those services. This is also the
         * case when a control uses a data source that doesn’t support compliance checks (for example: manual evidence,
         * API calls, or CloudTrail).
         * </p>
         * <note>
         * <p>
         * If evidence has a compliance check status of <i>not applicable</i>, it's classed as <i>inconclusive</i> in
         * <code>Insights</code> data.
         * </p>
         * </note>
         * 
         * @param inconclusiveEvidenceCount
         *        The number of evidence without a compliance check ruling. Evidence is inconclusive when the associated
         *        control uses Security Hub or Config as a data source but you didn't enable those services. This is
         *        also the case when a control uses a data source that doesn’t support compliance checks (for example:
         *        manual evidence, API calls, or CloudTrail). </p> <note>
         *        <p>
         *        If evidence has a compliance check status of <i>not applicable</i>, it's classed as
         *        <i>inconclusive</i> in <code>Insights</code> data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inconclusiveEvidenceCount(Integer inconclusiveEvidenceCount);

        /**
         * <p>
         * The number of assessment controls that collected non-compliant evidence on the <code>lastUpdated</code> date.
         * </p>
         * 
         * @param assessmentControlsCountByNoncompliantEvidence
         *        The number of assessment controls that collected non-compliant evidence on the
         *        <code>lastUpdated</code> date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentControlsCountByNoncompliantEvidence(Integer assessmentControlsCountByNoncompliantEvidence);

        /**
         * <p>
         * The total number of controls across all active assessments.
         * </p>
         * 
         * @param totalAssessmentControlsCount
         *        The total number of controls across all active assessments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAssessmentControlsCount(Integer totalAssessmentControlsCount);

        /**
         * <p>
         * The time when the cross-assessment insights were last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time when the cross-assessment insights were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);
    }

    static final class BuilderImpl implements Builder {
        private Integer activeAssessmentsCount;

        private Integer noncompliantEvidenceCount;

        private Integer compliantEvidenceCount;

        private Integer inconclusiveEvidenceCount;

        private Integer assessmentControlsCountByNoncompliantEvidence;

        private Integer totalAssessmentControlsCount;

        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(Insights model) {
            activeAssessmentsCount(model.activeAssessmentsCount);
            noncompliantEvidenceCount(model.noncompliantEvidenceCount);
            compliantEvidenceCount(model.compliantEvidenceCount);
            inconclusiveEvidenceCount(model.inconclusiveEvidenceCount);
            assessmentControlsCountByNoncompliantEvidence(model.assessmentControlsCountByNoncompliantEvidence);
            totalAssessmentControlsCount(model.totalAssessmentControlsCount);
            lastUpdated(model.lastUpdated);
        }

        public final Integer getActiveAssessmentsCount() {
            return activeAssessmentsCount;
        }

        public final void setActiveAssessmentsCount(Integer activeAssessmentsCount) {
            this.activeAssessmentsCount = activeAssessmentsCount;
        }

        @Override
        @Transient
        public final Builder activeAssessmentsCount(Integer activeAssessmentsCount) {
            this.activeAssessmentsCount = activeAssessmentsCount;
            return this;
        }

        public final Integer getNoncompliantEvidenceCount() {
            return noncompliantEvidenceCount;
        }

        public final void setNoncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
        }

        @Override
        @Transient
        public final Builder noncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
            return this;
        }

        public final Integer getCompliantEvidenceCount() {
            return compliantEvidenceCount;
        }

        public final void setCompliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
        }

        @Override
        @Transient
        public final Builder compliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
            return this;
        }

        public final Integer getInconclusiveEvidenceCount() {
            return inconclusiveEvidenceCount;
        }

        public final void setInconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
        }

        @Override
        @Transient
        public final Builder inconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
            return this;
        }

        public final Integer getAssessmentControlsCountByNoncompliantEvidence() {
            return assessmentControlsCountByNoncompliantEvidence;
        }

        public final void setAssessmentControlsCountByNoncompliantEvidence(Integer assessmentControlsCountByNoncompliantEvidence) {
            this.assessmentControlsCountByNoncompliantEvidence = assessmentControlsCountByNoncompliantEvidence;
        }

        @Override
        @Transient
        public final Builder assessmentControlsCountByNoncompliantEvidence(Integer assessmentControlsCountByNoncompliantEvidence) {
            this.assessmentControlsCountByNoncompliantEvidence = assessmentControlsCountByNoncompliantEvidence;
            return this;
        }

        public final Integer getTotalAssessmentControlsCount() {
            return totalAssessmentControlsCount;
        }

        public final void setTotalAssessmentControlsCount(Integer totalAssessmentControlsCount) {
            this.totalAssessmentControlsCount = totalAssessmentControlsCount;
        }

        @Override
        @Transient
        public final Builder totalAssessmentControlsCount(Integer totalAssessmentControlsCount) {
            this.totalAssessmentControlsCount = totalAssessmentControlsCount;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        @Transient
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Override
        public Insights build() {
            return new Insights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
