/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.ManualEvidence;
import software.amazon.awssdk.services.auditmanager.model.ManualEvidenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchImportEvidenceToAssessmentControlRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, BatchImportEvidenceToAssessmentControlRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(BatchImportEvidenceToAssessmentControlRequest.getter(BatchImportEvidenceToAssessmentControlRequest::assessmentId)).setter(BatchImportEvidenceToAssessmentControlRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(BatchImportEvidenceToAssessmentControlRequest.getter(BatchImportEvidenceToAssessmentControlRequest::controlSetId)).setter(BatchImportEvidenceToAssessmentControlRequest.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()}).build();
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlId").getter(BatchImportEvidenceToAssessmentControlRequest.getter(BatchImportEvidenceToAssessmentControlRequest::controlId)).setter(BatchImportEvidenceToAssessmentControlRequest.setter(Builder::controlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlId").build()}).build();
    private static final SdkField<List<ManualEvidence>> MANUAL_EVIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("manualEvidence").getter(BatchImportEvidenceToAssessmentControlRequest.getter(BatchImportEvidenceToAssessmentControlRequest::manualEvidence)).setter(BatchImportEvidenceToAssessmentControlRequest.setter(Builder::manualEvidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualEvidence").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManualEvidence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, CONTROL_SET_ID_FIELD, CONTROL_ID_FIELD, MANUAL_EVIDENCE_FIELD));
    private final String assessmentId;
    private final String controlSetId;
    private final String controlId;
    private final List<ManualEvidence> manualEvidence;

    private BatchImportEvidenceToAssessmentControlRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.controlId = builder.controlId;
        this.manualEvidence = builder.manualEvidence;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final String controlId() {
        return this.controlId;
    }

    public final boolean hasManualEvidence() {
        return this.manualEvidence != null && !(this.manualEvidence instanceof SdkAutoConstructList);
    }

    public final List<ManualEvidence> manualEvidence() {
        return this.manualEvidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManualEvidence() ? this.manualEvidence() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImportEvidenceToAssessmentControlRequest)) {
            return false;
        }
        BatchImportEvidenceToAssessmentControlRequest other = (BatchImportEvidenceToAssessmentControlRequest)((Object)obj);
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.controlId(), other.controlId()) && this.hasManualEvidence() == other.hasManualEvidence() && Objects.equals(this.manualEvidence(), other.manualEvidence());
    }

    public final String toString() {
        return ToString.builder((String)"BatchImportEvidenceToAssessmentControlRequest").add("AssessmentId", (Object)this.assessmentId()).add("ControlSetId", (Object)this.controlSetId()).add("ControlId", (Object)this.controlId()).add("ManualEvidence", this.hasManualEvidence() ? this.manualEvidence() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "controlId": {
                return Optional.ofNullable(clazz.cast(this.controlId()));
            }
            case "manualEvidence": {
                return Optional.ofNullable(clazz.cast(this.manualEvidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchImportEvidenceToAssessmentControlRequest, T> g) {
        return obj -> g.apply((BatchImportEvidenceToAssessmentControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String assessmentId;
        private String controlSetId;
        private String controlId;
        private List<ManualEvidence> manualEvidence = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImportEvidenceToAssessmentControlRequest model) {
            super(model);
            this.assessmentId(model.assessmentId);
            this.controlSetId(model.controlSetId);
            this.controlId(model.controlId);
            this.manualEvidence(model.manualEvidence);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        @Transient
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        @Transient
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getControlId() {
            return this.controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        @Transient
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final List<ManualEvidence.Builder> getManualEvidence() {
            List<ManualEvidence.Builder> result = ManualEvidenceListCopier.copyToBuilder(this.manualEvidence);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManualEvidence(Collection<ManualEvidence.BuilderImpl> manualEvidence) {
            this.manualEvidence = ManualEvidenceListCopier.copyFromBuilder(manualEvidence);
        }

        @Override
        @Transient
        public final Builder manualEvidence(Collection<ManualEvidence> manualEvidence) {
            this.manualEvidence = ManualEvidenceListCopier.copy(manualEvidence);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder manualEvidence(ManualEvidence ... manualEvidence) {
            this.manualEvidence(Arrays.asList(manualEvidence));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder manualEvidence(Consumer<ManualEvidence.Builder> ... manualEvidence) {
            this.manualEvidence(Stream.of(manualEvidence).map(c -> (ManualEvidence)((ManualEvidence.Builder)ManualEvidence.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchImportEvidenceToAssessmentControlRequest build() {
            return new BatchImportEvidenceToAssessmentControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchImportEvidenceToAssessmentControlRequest> {
        public Builder assessmentId(String var1);

        public Builder controlSetId(String var1);

        public Builder controlId(String var1);

        public Builder manualEvidence(Collection<ManualEvidence> var1);

        public Builder manualEvidence(ManualEvidence ... var1);

        public Builder manualEvidence(Consumer<ManualEvidence.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

