/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDelegationsResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetDelegationsResponse.Builder, GetDelegationsResponse> {
    private static final SdkField<List<DelegationMetadata>> DELEGATIONS_FIELD = SdkField
            .<List<DelegationMetadata>> builder(MarshallingType.LIST)
            .memberName("delegations")
            .getter(getter(GetDelegationsResponse::delegations))
            .setter(setter(Builder::delegations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DelegationMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(DelegationMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetDelegationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DelegationMetadata> delegations;

    private final String nextToken;

    private GetDelegationsResponse(BuilderImpl builder) {
        super(builder);
        this.delegations = builder.delegations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Delegations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDelegations() {
        return delegations != null && !(delegations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of delegations that the <code>GetDelegations</code> API returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDelegations} method.
     * </p>
     * 
     * @return The list of delegations that the <code>GetDelegations</code> API returned.
     */
    public final List<DelegationMetadata> delegations() {
        return delegations;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDelegations() ? delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegationsResponse)) {
            return false;
        }
        GetDelegationsResponse other = (GetDelegationsResponse) obj;
        return hasDelegations() == other.hasDelegations() && Objects.equals(delegations(), other.delegations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDelegationsResponse").add("Delegations", hasDelegations() ? delegations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegations":
            return Optional.ofNullable(clazz.cast(delegations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDelegationsResponse, T> g) {
        return obj -> g.apply((GetDelegationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDelegationsResponse> {
        /**
         * <p>
         * The list of delegations that the <code>GetDelegations</code> API returned.
         * </p>
         * 
         * @param delegations
         *        The list of delegations that the <code>GetDelegations</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegations(Collection<DelegationMetadata> delegations);

        /**
         * <p>
         * The list of delegations that the <code>GetDelegations</code> API returned.
         * </p>
         * 
         * @param delegations
         *        The list of delegations that the <code>GetDelegations</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegations(DelegationMetadata... delegations);

        /**
         * <p>
         * The list of delegations that the <code>GetDelegations</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DelegationMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<DelegationMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DelegationMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #delegations(List<DelegationMetadata>)}.
         * 
         * @param delegations
         *        a consumer that will call methods on {@link List<DelegationMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegations(List<DelegationMetadata>)
         */
        Builder delegations(Consumer<DelegationMetadata.Builder>... delegations);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<DelegationMetadata> delegations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegationsResponse model) {
            super(model);
            delegations(model.delegations);
            nextToken(model.nextToken);
        }

        public final List<DelegationMetadata.Builder> getDelegations() {
            List<DelegationMetadata.Builder> result = DelegationMetadataListCopier.copyToBuilder(this.delegations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegations(Collection<DelegationMetadata.BuilderImpl> delegations) {
            this.delegations = DelegationMetadataListCopier.copyFromBuilder(delegations);
        }

        @Override
        @Transient
        public final Builder delegations(Collection<DelegationMetadata> delegations) {
            this.delegations = DelegationMetadataListCopier.copy(delegations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder delegations(DelegationMetadata... delegations) {
            delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder delegations(Consumer<DelegationMetadata.Builder>... delegations) {
            delegations(Stream.of(delegations).map(c -> DelegationMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDelegationsResponse build() {
            return new GetDelegationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
