/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentControlSetStatusResponse extends AuditManagerResponse implements
        ToCopyableBuilder<UpdateAssessmentControlSetStatusResponse.Builder, UpdateAssessmentControlSetStatusResponse> {
    private static final SdkField<AssessmentControlSet> CONTROL_SET_FIELD = SdkField
            .<AssessmentControlSet> builder(MarshallingType.SDK_POJO).memberName("controlSet")
            .getter(getter(UpdateAssessmentControlSetStatusResponse::controlSet)).setter(setter(Builder::controlSet))
            .constructor(AssessmentControlSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_SET_FIELD));

    private final AssessmentControlSet controlSet;

    private UpdateAssessmentControlSetStatusResponse(BuilderImpl builder) {
        super(builder);
        this.controlSet = builder.controlSet;
    }

    /**
     * <p>
     * The name of the updated control set that the <code>UpdateAssessmentControlSetStatus</code> API returned.
     * </p>
     * 
     * @return The name of the updated control set that the <code>UpdateAssessmentControlSetStatus</code> API returned.
     */
    public final AssessmentControlSet controlSet() {
        return controlSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentControlSetStatusResponse)) {
            return false;
        }
        UpdateAssessmentControlSetStatusResponse other = (UpdateAssessmentControlSetStatusResponse) obj;
        return Objects.equals(controlSet(), other.controlSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentControlSetStatusResponse").add("ControlSet", controlSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlSet":
            return Optional.ofNullable(clazz.cast(controlSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentControlSetStatusResponse, T> g) {
        return obj -> g.apply((UpdateAssessmentControlSetStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssessmentControlSetStatusResponse> {
        /**
         * <p>
         * The name of the updated control set that the <code>UpdateAssessmentControlSetStatus</code> API returned.
         * </p>
         * 
         * @param controlSet
         *        The name of the updated control set that the <code>UpdateAssessmentControlSetStatus</code> API
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSet(AssessmentControlSet controlSet);

        /**
         * <p>
         * The name of the updated control set that the <code>UpdateAssessmentControlSetStatus</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssessmentControlSet.Builder} avoiding
         * the need to create one manually via {@link AssessmentControlSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentControlSet.Builder#build()} is called immediately and
         * its result is passed to {@link #controlSet(AssessmentControlSet)}.
         * 
         * @param controlSet
         *        a consumer that will call methods on {@link AssessmentControlSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlSet(AssessmentControlSet)
         */
        default Builder controlSet(Consumer<AssessmentControlSet.Builder> controlSet) {
            return controlSet(AssessmentControlSet.builder().applyMutation(controlSet).build());
        }
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private AssessmentControlSet controlSet;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentControlSetStatusResponse model) {
            super(model);
            controlSet(model.controlSet);
        }

        public final AssessmentControlSet.Builder getControlSet() {
            return controlSet != null ? controlSet.toBuilder() : null;
        }

        public final void setControlSet(AssessmentControlSet.BuilderImpl controlSet) {
            this.controlSet = controlSet != null ? controlSet.build() : null;
        }

        @Override
        @Transient
        public final Builder controlSet(AssessmentControlSet controlSet) {
            this.controlSet = controlSet;
            return this;
        }

        @Override
        public UpdateAssessmentControlSetStatusResponse build() {
            return new UpdateAssessmentControlSetStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
