/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentControlSetStatusRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateAssessmentControlSetStatusRequest.Builder, UpdateAssessmentControlSetStatusRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(UpdateAssessmentControlSetStatusRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(UpdateAssessmentControlSetStatusRequest::controlSetId))
            .setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateAssessmentControlSetStatusRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(UpdateAssessmentControlSetStatusRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD,
            CONTROL_SET_ID_FIELD, STATUS_FIELD, COMMENT_FIELD));

    private final String assessmentId;

    private final String controlSetId;

    private final String status;

    private final String comment;

    private UpdateAssessmentControlSetStatusRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.status = builder.status;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The unique identifier for the assessment.
     * </p>
     * 
     * @return The unique identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The unique identifier for the control set.
     * </p>
     * 
     * @return The unique identifier for the control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The status of the control set that's being updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the control set that's being updated.
     * @see ControlSetStatus
     */
    public final ControlSetStatus status() {
        return ControlSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the control set that's being updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the control set that's being updated.
     * @see ControlSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The comment that's related to the status update.
     * </p>
     * 
     * @return The comment that's related to the status update.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentControlSetStatusRequest)) {
            return false;
        }
        UpdateAssessmentControlSetStatusRequest other = (UpdateAssessmentControlSetStatusRequest) obj;
        return Objects.equals(assessmentId(), other.assessmentId()) && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentControlSetStatusRequest").add("AssessmentId", assessmentId())
                .add("ControlSetId", controlSetId()).add("Status", statusAsString()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentControlSetStatusRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentControlSetStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssessmentControlSetStatusRequest> {
        /**
         * <p>
         * The unique identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The unique identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The unique identifier for the control set.
         * </p>
         * 
         * @param controlSetId
         *        The unique identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The status of the control set that's being updated.
         * </p>
         * 
         * @param status
         *        The status of the control set that's being updated.
         * @see ControlSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the control set that's being updated.
         * </p>
         * 
         * @param status
         *        The status of the control set that's being updated.
         * @see ControlSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlSetStatus
         */
        Builder status(ControlSetStatus status);

        /**
         * <p>
         * The comment that's related to the status update.
         * </p>
         * 
         * @param comment
         *        The comment that's related to the status update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String assessmentId;

        private String controlSetId;

        private String status;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentControlSetStatusRequest model) {
            super(model);
            assessmentId(model.assessmentId);
            controlSetId(model.controlSetId);
            status(model.status);
            comment(model.comment);
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentControlSetStatusRequest build() {
            return new UpdateAssessmentControlSetStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
