/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateAssessmentReportEvidenceRequest extends AuditManagerRequest implements
        ToCopyableBuilder<BatchAssociateAssessmentReportEvidenceRequest.Builder, BatchAssociateAssessmentReportEvidenceRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(BatchAssociateAssessmentReportEvidenceRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> EVIDENCE_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceFolderId").getter(getter(BatchAssociateAssessmentReportEvidenceRequest::evidenceFolderId))
            .setter(setter(Builder::evidenceFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFolderId").build()).build();

    private static final SdkField<List<String>> EVIDENCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("evidenceIds")
            .getter(getter(BatchAssociateAssessmentReportEvidenceRequest::evidenceIds))
            .setter(setter(Builder::evidenceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD,
            EVIDENCE_FOLDER_ID_FIELD, EVIDENCE_IDS_FIELD));

    private final String assessmentId;

    private final String evidenceFolderId;

    private final List<String> evidenceIds;

    private BatchAssociateAssessmentReportEvidenceRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.evidenceFolderId = builder.evidenceFolderId;
        this.evidenceIds = builder.evidenceIds;
    }

    /**
     * <p>
     * The unique identifier for the specified assessment.
     * </p>
     * 
     * @return The unique identifier for the specified assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The identifier for the folder in which the evidence is stored.
     * </p>
     * 
     * @return The identifier for the folder in which the evidence is stored.
     */
    public final String evidenceFolderId() {
        return evidenceFolderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvidenceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvidenceIds() {
        return evidenceIds != null && !(evidenceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of evidence identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvidenceIds} method.
     * </p>
     * 
     * @return The list of evidence identifiers.
     */
    public final List<String> evidenceIds() {
        return evidenceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvidenceIds() ? evidenceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateAssessmentReportEvidenceRequest)) {
            return false;
        }
        BatchAssociateAssessmentReportEvidenceRequest other = (BatchAssociateAssessmentReportEvidenceRequest) obj;
        return Objects.equals(assessmentId(), other.assessmentId())
                && Objects.equals(evidenceFolderId(), other.evidenceFolderId()) && hasEvidenceIds() == other.hasEvidenceIds()
                && Objects.equals(evidenceIds(), other.evidenceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateAssessmentReportEvidenceRequest").add("AssessmentId", assessmentId())
                .add("EvidenceFolderId", evidenceFolderId()).add("EvidenceIds", hasEvidenceIds() ? evidenceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "evidenceFolderId":
            return Optional.ofNullable(clazz.cast(evidenceFolderId()));
        case "evidenceIds":
            return Optional.ofNullable(clazz.cast(evidenceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateAssessmentReportEvidenceRequest, T> g) {
        return obj -> g.apply((BatchAssociateAssessmentReportEvidenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateAssessmentReportEvidenceRequest> {
        /**
         * <p>
         * The unique identifier for the specified assessment.
         * </p>
         * 
         * @param assessmentId
         *        The unique identifier for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The identifier for the folder in which the evidence is stored.
         * </p>
         * 
         * @param evidenceFolderId
         *        The identifier for the folder in which the evidence is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFolderId(String evidenceFolderId);

        /**
         * <p>
         * The list of evidence identifiers.
         * </p>
         * 
         * @param evidenceIds
         *        The list of evidence identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceIds(Collection<String> evidenceIds);

        /**
         * <p>
         * The list of evidence identifiers.
         * </p>
         * 
         * @param evidenceIds
         *        The list of evidence identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceIds(String... evidenceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String assessmentId;

        private String evidenceFolderId;

        private List<String> evidenceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateAssessmentReportEvidenceRequest model) {
            super(model);
            assessmentId(model.assessmentId);
            evidenceFolderId(model.evidenceFolderId);
            evidenceIds(model.evidenceIds);
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        @Transient
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getEvidenceFolderId() {
            return evidenceFolderId;
        }

        public final void setEvidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
        }

        @Override
        @Transient
        public final Builder evidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
            return this;
        }

        public final Collection<String> getEvidenceIds() {
            if (evidenceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return evidenceIds;
        }

        public final void setEvidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
        }

        @Override
        @Transient
        public final Builder evidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evidenceIds(String... evidenceIds) {
            evidenceIds(Arrays.asList(evidenceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateAssessmentReportEvidenceRequest build() {
            return new BatchAssociateAssessmentReportEvidenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
