/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata associated with the specified Amazon Web Service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceMetadata implements SdkPojo, Serializable, ToCopyableBuilder<ServiceMetadata.Builder, ServiceMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(ServiceMetadata::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ServiceMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(ServiceMetadata::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CATEGORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String displayName;

    private final String description;

    private final String category;

    private ServiceMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.category = builder.category;
    }

    /**
     * <p>
     * The name of the Amazon Web Service.
     * </p>
     * 
     * @return The name of the Amazon Web Service.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The display name of the Amazon Web Service.
     * </p>
     * 
     * @return The display name of the Amazon Web Service.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the specified Amazon Web Service.
     * </p>
     * 
     * @return The description of the specified Amazon Web Service.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The category in which the Amazon Web Service belongs, such as compute, storage, database, and so on.
     * </p>
     * 
     * @return The category in which the Amazon Web Service belongs, such as compute, storage, database, and so on.
     */
    public final String category() {
        return category;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceMetadata)) {
            return false;
        }
        ServiceMetadata other = (ServiceMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description()) && Objects.equals(category(), other.category());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceMetadata").add("Name", name()).add("DisplayName", displayName())
                .add("Description", description()).add("Category", category()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceMetadata, T> g) {
        return obj -> g.apply((ServiceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceMetadata> {
        /**
         * <p>
         * The name of the Amazon Web Service.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Web Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The display name of the Amazon Web Service.
         * </p>
         * 
         * @param displayName
         *        The display name of the Amazon Web Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the specified Amazon Web Service.
         * </p>
         * 
         * @param description
         *        The description of the specified Amazon Web Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The category in which the Amazon Web Service belongs, such as compute, storage, database, and so on.
         * </p>
         * 
         * @param category
         *        The category in which the Amazon Web Service belongs, such as compute, storage, database, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String displayName;

        private String description;

        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceMetadata model) {
            name(model.name);
            displayName(model.displayName);
            description(model.description);
            category(model.category);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public ServiceMetadata build() {
            return new ServiceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
