/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entity that defines the scope of audit evidence collected by Audit Manager. An Audit Manager assessment is an
 * implementation of an Audit Manager framework.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Assessment implements SdkPojo, Serializable, ToCopyableBuilder<Assessment.Builder, Assessment> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Assessment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<AWSAccount> AWS_ACCOUNT_FIELD = SdkField.<AWSAccount> builder(MarshallingType.SDK_POJO)
            .memberName("awsAccount").getter(getter(Assessment::awsAccount)).setter(setter(Builder::awsAccount))
            .constructor(AWSAccount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccount").build()).build();

    private static final SdkField<AssessmentMetadata> METADATA_FIELD = SdkField
            .<AssessmentMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata").getter(getter(Assessment::metadata))
            .setter(setter(Builder::metadata)).constructor(AssessmentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<AssessmentFramework> FRAMEWORK_FIELD = SdkField
            .<AssessmentFramework> builder(MarshallingType.SDK_POJO).memberName("framework")
            .getter(getter(Assessment::framework)).setter(setter(Builder::framework)).constructor(AssessmentFramework::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Assessment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_ACCOUNT_FIELD,
            METADATA_FIELD, FRAMEWORK_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final AWSAccount awsAccount;

    private final AssessmentMetadata metadata;

    private final AssessmentFramework framework;

    private final Map<String, String> tags;

    private Assessment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsAccount = builder.awsAccount;
        this.metadata = builder.metadata;
        this.framework = builder.framework;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the assessment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the assessment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services account that's associated with the assessment.
     * </p>
     * 
     * @return The Amazon Web Services account that's associated with the assessment.
     */
    public final AWSAccount awsAccount() {
        return awsAccount;
    }

    /**
     * <p>
     * The metadata for the assessment.
     * </p>
     * 
     * @return The metadata for the assessment.
     */
    public final AssessmentMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The framework that the assessment was created from.
     * </p>
     * 
     * @return The framework that the assessment was created from.
     */
    public final AssessmentFramework framework() {
        return framework;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are associated with the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are associated with the assessment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment other = (Assessment) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(awsAccount(), other.awsAccount())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(framework(), other.framework())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Assessment").add("Arn", arn()).add("AwsAccount", awsAccount()).add("Metadata", metadata())
                .add("Framework", framework()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "awsAccount":
            return Optional.ofNullable(clazz.cast(awsAccount()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Assessment, T> g) {
        return obj -> g.apply((Assessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Assessment> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the assessment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services account that's associated with the assessment.
         * </p>
         * 
         * @param awsAccount
         *        The Amazon Web Services account that's associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccount(AWSAccount awsAccount);

        /**
         * <p>
         * The Amazon Web Services account that's associated with the assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link AWSAccount.Builder} avoiding the need to
         * create one manually via {@link AWSAccount#builder()}.
         *
         * When the {@link Consumer} completes, {@link AWSAccount.Builder#build()} is called immediately and its result
         * is passed to {@link #awsAccount(AWSAccount)}.
         * 
         * @param awsAccount
         *        a consumer that will call methods on {@link AWSAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccount(AWSAccount)
         */
        default Builder awsAccount(Consumer<AWSAccount.Builder> awsAccount) {
            return awsAccount(AWSAccount.builder().applyMutation(awsAccount).build());
        }

        /**
         * <p>
         * The metadata for the assessment.
         * </p>
         * 
         * @param metadata
         *        The metadata for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(AssessmentMetadata metadata);

        /**
         * <p>
         * The metadata for the assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssessmentMetadata.Builder} avoiding the
         * need to create one manually via {@link AssessmentMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(AssessmentMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link AssessmentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(AssessmentMetadata)
         */
        default Builder metadata(Consumer<AssessmentMetadata.Builder> metadata) {
            return metadata(AssessmentMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The framework that the assessment was created from.
         * </p>
         * 
         * @param framework
         *        The framework that the assessment was created from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(AssessmentFramework framework);

        /**
         * <p>
         * The framework that the assessment was created from.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssessmentFramework.Builder} avoiding the
         * need to create one manually via {@link AssessmentFramework#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentFramework.Builder#build()} is called immediately and
         * its result is passed to {@link #framework(AssessmentFramework)}.
         * 
         * @param framework
         *        a consumer that will call methods on {@link AssessmentFramework.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #framework(AssessmentFramework)
         */
        default Builder framework(Consumer<AssessmentFramework.Builder> framework) {
            return framework(AssessmentFramework.builder().applyMutation(framework).build());
        }

        /**
         * <p>
         * The tags that are associated with the assessment.
         * </p>
         * 
         * @param tags
         *        The tags that are associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private AWSAccount awsAccount;

        private AssessmentMetadata metadata;

        private AssessmentFramework framework;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Assessment model) {
            arn(model.arn);
            awsAccount(model.awsAccount);
            metadata(model.metadata);
            framework(model.framework);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AWSAccount.Builder getAwsAccount() {
            return awsAccount != null ? awsAccount.toBuilder() : null;
        }

        public final void setAwsAccount(AWSAccount.BuilderImpl awsAccount) {
            this.awsAccount = awsAccount != null ? awsAccount.build() : null;
        }

        @Override
        public final Builder awsAccount(AWSAccount awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        public final AssessmentMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(AssessmentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(AssessmentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final AssessmentFramework.Builder getFramework() {
            return framework != null ? framework.toBuilder() : null;
        }

        public final void setFramework(AssessmentFramework.BuilderImpl framework) {
            this.framework = framework != null ? framework.build() : null;
        }

        @Override
        public final Builder framework(AssessmentFramework framework) {
            this.framework = framework;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Assessment build() {
            return new Assessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
