/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The control entity that represents a standard control or a custom control in an Audit Manager assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentControl implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentControl.Builder, AssessmentControl> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentControl::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssessmentControl::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssessmentControl::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AssessmentControl::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("response").getter(getter(AssessmentControl::responseAsString)).setter(setter(Builder::response))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()).build();

    private static final SdkField<List<ControlComment>> COMMENTS_FIELD = SdkField
            .<List<ControlComment>> builder(MarshallingType.LIST)
            .memberName("comments")
            .getter(getter(AssessmentControl::comments))
            .setter(setter(Builder::comments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlComment> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlComment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVIDENCE_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("evidenceSources")
            .getter(getter(AssessmentControl::evidenceSources))
            .setter(setter(Builder::evidenceSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> EVIDENCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceCount").getter(getter(AssessmentControl::evidenceCount)).setter(setter(Builder::evidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceCount").build()).build();

    private static final SdkField<Integer> ASSESSMENT_REPORT_EVIDENCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("assessmentReportEvidenceCount")
            .getter(getter(AssessmentControl::assessmentReportEvidenceCount))
            .setter(setter(Builder::assessmentReportEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportEvidenceCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, RESPONSE_FIELD, COMMENTS_FIELD, EVIDENCE_SOURCES_FIELD, EVIDENCE_COUNT_FIELD,
            ASSESSMENT_REPORT_EVIDENCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String status;

    private final String response;

    private final List<ControlComment> comments;

    private final List<String> evidenceSources;

    private final Integer evidenceCount;

    private final Integer assessmentReportEvidenceCount;

    private AssessmentControl(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.response = builder.response;
        this.comments = builder.comments;
        this.evidenceSources = builder.evidenceSources;
        this.evidenceCount = builder.evidenceCount;
        this.assessmentReportEvidenceCount = builder.assessmentReportEvidenceCount;
    }

    /**
     * <p>
     * The identifier for the control.
     * </p>
     * 
     * @return The identifier for the control.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the control.
     * </p>
     * 
     * @return The name of the control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the control.
     * </p>
     * 
     * @return The description of the control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the control.
     * @see ControlStatus
     */
    public final ControlStatus status() {
        return ControlStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the control.
     * @see ControlStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The response of the control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #response} will
     * return {@link ControlResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseAsString}.
     * </p>
     * 
     * @return The response of the control.
     * @see ControlResponse
     */
    public final ControlResponse response() {
        return ControlResponse.fromValue(response);
    }

    /**
     * <p>
     * The response of the control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #response} will
     * return {@link ControlResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseAsString}.
     * </p>
     * 
     * @return The response of the control.
     * @see ControlResponse
     */
    public final String responseAsString() {
        return response;
    }

    /**
     * For responses, this returns true if the service returned a value for the Comments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComments() {
        return comments != null && !(comments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of comments that's attached to the control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComments} method.
     * </p>
     * 
     * @return The list of comments that's attached to the control.
     */
    public final List<ControlComment> comments() {
        return comments;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvidenceSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvidenceSources() {
        return evidenceSources != null && !(evidenceSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data sources for the evidence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvidenceSources} method.
     * </p>
     * 
     * @return The list of data sources for the evidence.
     */
    public final List<String> evidenceSources() {
        return evidenceSources;
    }

    /**
     * <p>
     * The amount of evidence that's generated for the control.
     * </p>
     * 
     * @return The amount of evidence that's generated for the control.
     */
    public final Integer evidenceCount() {
        return evidenceCount;
    }

    /**
     * <p>
     * The amount of evidence in the assessment report.
     * </p>
     * 
     * @return The amount of evidence in the assessment report.
     */
    public final Integer assessmentReportEvidenceCount() {
        return assessmentReportEvidenceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(responseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasComments() ? comments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvidenceSources() ? evidenceSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentReportEvidenceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentControl)) {
            return false;
        }
        AssessmentControl other = (AssessmentControl) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(responseAsString(), other.responseAsString()) && hasComments() == other.hasComments()
                && Objects.equals(comments(), other.comments()) && hasEvidenceSources() == other.hasEvidenceSources()
                && Objects.equals(evidenceSources(), other.evidenceSources())
                && Objects.equals(evidenceCount(), other.evidenceCount())
                && Objects.equals(assessmentReportEvidenceCount(), other.assessmentReportEvidenceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentControl").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Status", statusAsString()).add("Response", responseAsString())
                .add("Comments", hasComments() ? comments() : null)
                .add("EvidenceSources", hasEvidenceSources() ? evidenceSources() : null).add("EvidenceCount", evidenceCount())
                .add("AssessmentReportEvidenceCount", assessmentReportEvidenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "response":
            return Optional.ofNullable(clazz.cast(responseAsString()));
        case "comments":
            return Optional.ofNullable(clazz.cast(comments()));
        case "evidenceSources":
            return Optional.ofNullable(clazz.cast(evidenceSources()));
        case "evidenceCount":
            return Optional.ofNullable(clazz.cast(evidenceCount()));
        case "assessmentReportEvidenceCount":
            return Optional.ofNullable(clazz.cast(assessmentReportEvidenceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentControl, T> g) {
        return obj -> g.apply((AssessmentControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentControl> {
        /**
         * <p>
         * The identifier for the control.
         * </p>
         * 
         * @param id
         *        The identifier for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the control.
         * </p>
         * 
         * @param name
         *        The name of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the control.
         * </p>
         * 
         * @param description
         *        The description of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the control.
         * </p>
         * 
         * @param status
         *        The status of the control.
         * @see ControlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the control.
         * </p>
         * 
         * @param status
         *        The status of the control.
         * @see ControlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlStatus
         */
        Builder status(ControlStatus status);

        /**
         * <p>
         * The response of the control.
         * </p>
         * 
         * @param response
         *        The response of the control.
         * @see ControlResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlResponse
         */
        Builder response(String response);

        /**
         * <p>
         * The response of the control.
         * </p>
         * 
         * @param response
         *        The response of the control.
         * @see ControlResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlResponse
         */
        Builder response(ControlResponse response);

        /**
         * <p>
         * The list of comments that's attached to the control.
         * </p>
         * 
         * @param comments
         *        The list of comments that's attached to the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(Collection<ControlComment> comments);

        /**
         * <p>
         * The list of comments that's attached to the control.
         * </p>
         * 
         * @param comments
         *        The list of comments that's attached to the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(ControlComment... comments);

        /**
         * <p>
         * The list of comments that's attached to the control.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ControlComment>.Builder} avoiding
         * the need to create one manually via {@link List<ControlComment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ControlComment>.Builder#build()} is called immediately and
         * its result is passed to {@link #comments(List<ControlComment>)}.
         * 
         * @param comments
         *        a consumer that will call methods on {@link List<ControlComment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comments(List<ControlComment>)
         */
        Builder comments(Consumer<ControlComment.Builder>... comments);

        /**
         * <p>
         * The list of data sources for the evidence.
         * </p>
         * 
         * @param evidenceSources
         *        The list of data sources for the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceSources(Collection<String> evidenceSources);

        /**
         * <p>
         * The list of data sources for the evidence.
         * </p>
         * 
         * @param evidenceSources
         *        The list of data sources for the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceSources(String... evidenceSources);

        /**
         * <p>
         * The amount of evidence that's generated for the control.
         * </p>
         * 
         * @param evidenceCount
         *        The amount of evidence that's generated for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceCount(Integer evidenceCount);

        /**
         * <p>
         * The amount of evidence in the assessment report.
         * </p>
         * 
         * @param assessmentReportEvidenceCount
         *        The amount of evidence in the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportEvidenceCount(Integer assessmentReportEvidenceCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String status;

        private String response;

        private List<ControlComment> comments = DefaultSdkAutoConstructList.getInstance();

        private List<String> evidenceSources = DefaultSdkAutoConstructList.getInstance();

        private Integer evidenceCount;

        private Integer assessmentReportEvidenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentControl model) {
            id(model.id);
            name(model.name);
            description(model.description);
            status(model.status);
            response(model.response);
            comments(model.comments);
            evidenceSources(model.evidenceSources);
            evidenceCount(model.evidenceCount);
            assessmentReportEvidenceCount(model.assessmentReportEvidenceCount);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResponse() {
            return response;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        @Override
        public final Builder response(ControlResponse response) {
            this.response(response == null ? null : response.toString());
            return this;
        }

        public final List<ControlComment.Builder> getComments() {
            List<ControlComment.Builder> result = ControlCommentsCopier.copyToBuilder(this.comments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComments(Collection<ControlComment.BuilderImpl> comments) {
            this.comments = ControlCommentsCopier.copyFromBuilder(comments);
        }

        @Override
        public final Builder comments(Collection<ControlComment> comments) {
            this.comments = ControlCommentsCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(ControlComment... comments) {
            comments(Arrays.asList(comments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Consumer<ControlComment.Builder>... comments) {
            comments(Stream.of(comments).map(c -> ControlComment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEvidenceSources() {
            if (evidenceSources instanceof SdkAutoConstructList) {
                return null;
            }
            return evidenceSources;
        }

        public final void setEvidenceSources(Collection<String> evidenceSources) {
            this.evidenceSources = EvidenceSourcesCopier.copy(evidenceSources);
        }

        @Override
        public final Builder evidenceSources(Collection<String> evidenceSources) {
            this.evidenceSources = EvidenceSourcesCopier.copy(evidenceSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceSources(String... evidenceSources) {
            evidenceSources(Arrays.asList(evidenceSources));
            return this;
        }

        public final Integer getEvidenceCount() {
            return evidenceCount;
        }

        public final void setEvidenceCount(Integer evidenceCount) {
            this.evidenceCount = evidenceCount;
        }

        @Override
        public final Builder evidenceCount(Integer evidenceCount) {
            this.evidenceCount = evidenceCount;
            return this;
        }

        public final Integer getAssessmentReportEvidenceCount() {
            return assessmentReportEvidenceCount;
        }

        public final void setAssessmentReportEvidenceCount(Integer assessmentReportEvidenceCount) {
            this.assessmentReportEvidenceCount = assessmentReportEvidenceCount;
        }

        @Override
        public final Builder assessmentReportEvidenceCount(Integer assessmentReportEvidenceCount) {
            this.assessmentReportEvidenceCount = assessmentReportEvidenceCount;
            return this;
        }

        @Override
        public AssessmentControl build() {
            return new AssessmentControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
