/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the latest analytics data for a specific control in a specific active assessment.
 * </p>
 * <p>
 * Control insights are grouped by control domain, and ranked by the highest total count of non-compliant evidence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlInsightsMetadataByAssessmentItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlInsightsMetadataByAssessmentItem.Builder, ControlInsightsMetadataByAssessmentItem> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ControlInsightsMetadataByAssessmentItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ControlInsightsMetadataByAssessmentItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<EvidenceInsights> EVIDENCE_INSIGHTS_FIELD = SdkField
            .<EvidenceInsights> builder(MarshallingType.SDK_POJO).memberName("evidenceInsights")
            .getter(getter(ControlInsightsMetadataByAssessmentItem::evidenceInsights)).setter(setter(Builder::evidenceInsights))
            .constructor(EvidenceInsights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceInsights").build()).build();

    private static final SdkField<String> CONTROL_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetName").getter(getter(ControlInsightsMetadataByAssessmentItem::controlSetName))
            .setter(setter(Builder::controlSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetName").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(ControlInsightsMetadataByAssessmentItem::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            EVIDENCE_INSIGHTS_FIELD, CONTROL_SET_NAME_FIELD, LAST_UPDATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final EvidenceInsights evidenceInsights;

    private final String controlSetName;

    private final Instant lastUpdated;

    private ControlInsightsMetadataByAssessmentItem(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.evidenceInsights = builder.evidenceInsights;
        this.controlSetName = builder.controlSetName;
        this.lastUpdated = builder.lastUpdated;
    }

    /**
     * <p>
     * The name of the assessment control.
     * </p>
     * 
     * @return The name of the assessment control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier for the assessment control.
     * </p>
     * 
     * @return The unique identifier for the assessment control.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A breakdown of the compliance check status for the evidence that’s associated with the assessment control.
     * </p>
     * 
     * @return A breakdown of the compliance check status for the evidence that’s associated with the assessment
     *         control.
     */
    public final EvidenceInsights evidenceInsights() {
        return evidenceInsights;
    }

    /**
     * <p>
     * The name of the control set that the assessment control belongs to.
     * </p>
     * 
     * @return The name of the control set that the assessment control belongs to.
     */
    public final String controlSetName() {
        return controlSetName;
    }

    /**
     * <p>
     * The time when the assessment control insights were last updated.
     * </p>
     * 
     * @return The time when the assessment control insights were last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlInsightsMetadataByAssessmentItem)) {
            return false;
        }
        ControlInsightsMetadataByAssessmentItem other = (ControlInsightsMetadataByAssessmentItem) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(evidenceInsights(), other.evidenceInsights())
                && Objects.equals(controlSetName(), other.controlSetName()) && Objects.equals(lastUpdated(), other.lastUpdated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlInsightsMetadataByAssessmentItem").add("Name", name()).add("Id", id())
                .add("EvidenceInsights", evidenceInsights()).add("ControlSetName", controlSetName())
                .add("LastUpdated", lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "evidenceInsights":
            return Optional.ofNullable(clazz.cast(evidenceInsights()));
        case "controlSetName":
            return Optional.ofNullable(clazz.cast(controlSetName()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlInsightsMetadataByAssessmentItem, T> g) {
        return obj -> g.apply((ControlInsightsMetadataByAssessmentItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlInsightsMetadataByAssessmentItem> {
        /**
         * <p>
         * The name of the assessment control.
         * </p>
         * 
         * @param name
         *        The name of the assessment control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier for the assessment control.
         * </p>
         * 
         * @param id
         *        The unique identifier for the assessment control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A breakdown of the compliance check status for the evidence that’s associated with the assessment control.
         * </p>
         * 
         * @param evidenceInsights
         *        A breakdown of the compliance check status for the evidence that’s associated with the assessment
         *        control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceInsights(EvidenceInsights evidenceInsights);

        /**
         * <p>
         * A breakdown of the compliance check status for the evidence that’s associated with the assessment control.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvidenceInsights.Builder} avoiding the
         * need to create one manually via {@link EvidenceInsights#builder()}.
         *
         * When the {@link Consumer} completes, {@link EvidenceInsights.Builder#build()} is called immediately and its
         * result is passed to {@link #evidenceInsights(EvidenceInsights)}.
         * 
         * @param evidenceInsights
         *        a consumer that will call methods on {@link EvidenceInsights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evidenceInsights(EvidenceInsights)
         */
        default Builder evidenceInsights(Consumer<EvidenceInsights.Builder> evidenceInsights) {
            return evidenceInsights(EvidenceInsights.builder().applyMutation(evidenceInsights).build());
        }

        /**
         * <p>
         * The name of the control set that the assessment control belongs to.
         * </p>
         * 
         * @param controlSetName
         *        The name of the control set that the assessment control belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetName(String controlSetName);

        /**
         * <p>
         * The time when the assessment control insights were last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time when the assessment control insights were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private EvidenceInsights evidenceInsights;

        private String controlSetName;

        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlInsightsMetadataByAssessmentItem model) {
            name(model.name);
            id(model.id);
            evidenceInsights(model.evidenceInsights);
            controlSetName(model.controlSetName);
            lastUpdated(model.lastUpdated);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final EvidenceInsights.Builder getEvidenceInsights() {
            return evidenceInsights != null ? evidenceInsights.toBuilder() : null;
        }

        public final void setEvidenceInsights(EvidenceInsights.BuilderImpl evidenceInsights) {
            this.evidenceInsights = evidenceInsights != null ? evidenceInsights.build() : null;
        }

        @Override
        public final Builder evidenceInsights(EvidenceInsights evidenceInsights) {
            this.evidenceInsights = evidenceInsights;
            return this;
        }

        public final String getControlSetName() {
            return controlSetName;
        }

        public final void setControlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
        }

        @Override
        public final Builder controlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Override
        public ControlInsightsMetadataByAssessmentItem build() {
            return new ControlInsightsMetadataByAssessmentItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
