/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentsResponse extends AuditManagerResponse implements
        ToCopyableBuilder<ListAssessmentsResponse.Builder, ListAssessmentsResponse> {
    private static final SdkField<List<AssessmentMetadataItem>> ASSESSMENT_METADATA_FIELD = SdkField
            .<List<AssessmentMetadataItem>> builder(MarshallingType.LIST)
            .memberName("assessmentMetadata")
            .getter(getter(ListAssessmentsResponse::assessmentMetadata))
            .setter(setter(Builder::assessmentMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentMetadataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentMetadataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_METADATA_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssessmentMetadataItem> assessmentMetadata;

    private final String nextToken;

    private ListAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentMetadata = builder.assessmentMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentMetadata property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentMetadata() {
        return assessmentMetadata != null && !(assessmentMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that's associated with the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentMetadata} method.
     * </p>
     * 
     * @return The metadata that's associated with the assessment.
     */
    public final List<AssessmentMetadataItem> assessmentMetadata() {
        return assessmentMetadata;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentMetadata() ? assessmentMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentsResponse)) {
            return false;
        }
        ListAssessmentsResponse other = (ListAssessmentsResponse) obj;
        return hasAssessmentMetadata() == other.hasAssessmentMetadata()
                && Objects.equals(assessmentMetadata(), other.assessmentMetadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentsResponse")
                .add("AssessmentMetadata", hasAssessmentMetadata() ? assessmentMetadata() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentMetadata":
            return Optional.ofNullable(clazz.cast(assessmentMetadata()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentsResponse, T> g) {
        return obj -> g.apply((ListAssessmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssessmentsResponse> {
        /**
         * <p>
         * The metadata that's associated with the assessment.
         * </p>
         * 
         * @param assessmentMetadata
         *        The metadata that's associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentMetadata(Collection<AssessmentMetadataItem> assessmentMetadata);

        /**
         * <p>
         * The metadata that's associated with the assessment.
         * </p>
         * 
         * @param assessmentMetadata
         *        The metadata that's associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentMetadata(AssessmentMetadataItem... assessmentMetadata);

        /**
         * <p>
         * The metadata that's associated with the assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AssessmentMetadataItem>.Builder}
         * avoiding the need to create one manually via {@link List<AssessmentMetadataItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentMetadataItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentMetadata(List<AssessmentMetadataItem>)}.
         * 
         * @param assessmentMetadata
         *        a consumer that will call methods on {@link List<AssessmentMetadataItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentMetadata(List<AssessmentMetadataItem>)
         */
        Builder assessmentMetadata(Consumer<AssessmentMetadataItem.Builder>... assessmentMetadata);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<AssessmentMetadataItem> assessmentMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentsResponse model) {
            super(model);
            assessmentMetadata(model.assessmentMetadata);
            nextToken(model.nextToken);
        }

        public final List<AssessmentMetadataItem.Builder> getAssessmentMetadata() {
            List<AssessmentMetadataItem.Builder> result = ListAssessmentMetadataCopier.copyToBuilder(this.assessmentMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentMetadata(Collection<AssessmentMetadataItem.BuilderImpl> assessmentMetadata) {
            this.assessmentMetadata = ListAssessmentMetadataCopier.copyFromBuilder(assessmentMetadata);
        }

        @Override
        public final Builder assessmentMetadata(Collection<AssessmentMetadataItem> assessmentMetadata) {
            this.assessmentMetadata = ListAssessmentMetadataCopier.copy(assessmentMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentMetadata(AssessmentMetadataItem... assessmentMetadata) {
            assessmentMetadata(Arrays.asList(assessmentMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentMetadata(Consumer<AssessmentMetadataItem.Builder>... assessmentMetadata) {
            assessmentMetadata(Stream.of(assessmentMetadata).map(c -> AssessmentMetadataItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentsResponse build() {
            return new ListAssessmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
