/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.ControlMetadata;
import software.amazon.awssdk.services.auditmanager.model.ControlMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListControlsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListControlsResponse> {
    private static final SdkField<List<ControlMetadata>> CONTROL_METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlMetadataList").getter(ListControlsResponse.getter(ListControlsResponse::controlMetadataList)).setter(ListControlsResponse.setter(Builder::controlMetadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListControlsResponse.getter(ListControlsResponse::nextToken)).setter(ListControlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_METADATA_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ControlMetadata> controlMetadataList;
    private final String nextToken;

    private ListControlsResponse(BuilderImpl builder) {
        super(builder);
        this.controlMetadataList = builder.controlMetadataList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasControlMetadataList() {
        return this.controlMetadataList != null && !(this.controlMetadataList instanceof SdkAutoConstructList);
    }

    public final List<ControlMetadata> controlMetadataList() {
        return this.controlMetadataList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlMetadataList() ? this.controlMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlsResponse)) {
            return false;
        }
        ListControlsResponse other = (ListControlsResponse)((Object)obj);
        return this.hasControlMetadataList() == other.hasControlMetadataList() && Objects.equals(this.controlMetadataList(), other.controlMetadataList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListControlsResponse").add("ControlMetadataList", this.hasControlMetadataList() ? this.controlMetadataList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlMetadataList": {
                return Optional.ofNullable(clazz.cast(this.controlMetadataList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListControlsResponse, T> g) {
        return obj -> g.apply((ListControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<ControlMetadata> controlMetadataList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlsResponse model) {
            super(model);
            this.controlMetadataList(model.controlMetadataList);
            this.nextToken(model.nextToken);
        }

        public final List<ControlMetadata.Builder> getControlMetadataList() {
            List<ControlMetadata.Builder> result = ControlMetadataListCopier.copyToBuilder(this.controlMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder controlMetadataList(Collection<ControlMetadata> controlMetadataList) {
            this.controlMetadataList = ControlMetadataListCopier.copy(controlMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMetadataList(ControlMetadata ... controlMetadataList) {
            this.controlMetadataList(Arrays.asList(controlMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMetadataList(Consumer<ControlMetadata.Builder> ... controlMetadataList) {
            this.controlMetadataList(Stream.of(controlMetadataList).map(c -> (ControlMetadata)((ControlMetadata.Builder)ControlMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControlMetadataList(Collection<ControlMetadata.BuilderImpl> controlMetadataList) {
            this.controlMetadataList = ControlMetadataListCopier.copyFromBuilder(controlMetadataList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListControlsResponse build() {
            return new ListControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListControlsResponse> {
        public Builder controlMetadataList(Collection<ControlMetadata> var1);

        public Builder controlMetadataList(ControlMetadata ... var1);

        public Builder controlMetadataList(Consumer<ControlMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

