/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.DelegationStatus;
import software.amazon.awssdk.services.auditmanager.model.RoleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Delegation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Delegation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Delegation.getter(Delegation::id)).setter(Delegation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(Delegation.getter(Delegation::assessmentName)).setter(Delegation.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()}).build();
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(Delegation.getter(Delegation::assessmentId)).setter(Delegation.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Delegation.getter(Delegation::statusAsString)).setter(Delegation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Delegation.getter(Delegation::roleArn)).setter(Delegation.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ROLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleType").getter(Delegation.getter(Delegation::roleTypeAsString)).setter(Delegation.setter(Builder::roleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Delegation.getter(Delegation::creationTime)).setter(Delegation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(Delegation.getter(Delegation::lastUpdated)).setter(Delegation.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(Delegation.getter(Delegation::controlSetId)).setter(Delegation.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(Delegation.getter(Delegation::comment)).setter(Delegation.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(Delegation.getter(Delegation::createdBy)).setter(Delegation.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_ID_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, ROLE_TYPE_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, CONTROL_SET_ID_FIELD, COMMENT_FIELD, CREATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String assessmentName;
    private final String assessmentId;
    private final String status;
    private final String roleArn;
    private final String roleType;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final String controlSetId;
    private final String comment;
    private final String createdBy;

    private Delegation(BuilderImpl builder) {
        this.id = builder.id;
        this.assessmentName = builder.assessmentName;
        this.assessmentId = builder.assessmentId;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.roleType = builder.roleType;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.controlSetId = builder.controlSetId;
        this.comment = builder.comment;
        this.createdBy = builder.createdBy;
    }

    public final String id() {
        return this.id;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final DelegationStatus status() {
        return DelegationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final RoleType roleType() {
        return RoleType.fromValue(this.roleType);
    }

    public final String roleTypeAsString() {
        return this.roleType;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final String comment() {
        return this.comment;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delegation)) {
            return false;
        }
        Delegation other = (Delegation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.assessmentName(), other.assessmentName()) && Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.roleTypeAsString(), other.roleTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"Delegation").add("Id", (Object)this.id()).add("AssessmentName", (Object)this.assessmentName()).add("AssessmentId", (Object)this.assessmentId()).add("Status", (Object)this.statusAsString()).add("RoleArn", (Object)this.roleArn()).add("RoleType", (Object)this.roleTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("ControlSetId", (Object)this.controlSetId()).add("Comment", (Object)this.comment()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "roleType": {
                return Optional.ofNullable(clazz.cast(this.roleTypeAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Delegation, T> g) {
        return obj -> g.apply((Delegation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String assessmentName;
        private String assessmentId;
        private String status;
        private String roleArn;
        private String roleType;
        private Instant creationTime;
        private Instant lastUpdated;
        private String controlSetId;
        private String comment;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Delegation model) {
            this.id(model.id);
            this.assessmentName(model.assessmentName);
            this.assessmentId(model.assessmentId);
            this.status(model.status);
            this.roleArn(model.roleArn);
            this.roleType(model.roleType);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.controlSetId(model.controlSetId);
            this.comment(model.comment);
            this.createdBy(model.createdBy);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        @Transient
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        @Transient
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DelegationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRoleType() {
            return this.roleType;
        }

        public final void setRoleType(String roleType) {
            this.roleType = roleType;
        }

        @Override
        @Transient
        public final Builder roleType(String roleType) {
            this.roleType = roleType;
            return this;
        }

        @Override
        @Transient
        public final Builder roleType(RoleType roleType) {
            this.roleType(roleType == null ? null : roleType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        @Transient
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        @Transient
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        @Transient
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Delegation build() {
            return new Delegation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Delegation> {
        public Builder id(String var1);

        public Builder assessmentName(String var1);

        public Builder assessmentId(String var1);

        public Builder status(String var1);

        public Builder status(DelegationStatus var1);

        public Builder roleArn(String var1);

        public Builder roleType(String var1);

        public Builder roleType(RoleType var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder controlSetId(String var1);

        public Builder comment(String var1);

        public Builder createdBy(String var1);
    }
}

