/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error entity for the <code>BatchDeleteDelegationByAssessment</code> API. This is used to provide more meaningful
 * errors than a simple string message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteDelegationByAssessmentError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteDelegationByAssessmentError.Builder, BatchDeleteDelegationByAssessmentError> {
    private static final SdkField<String> DELEGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("delegationId").getter(getter(BatchDeleteDelegationByAssessmentError::delegationId))
            .setter(setter(Builder::delegationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegationId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchDeleteDelegationByAssessmentError::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchDeleteDelegationByAssessmentError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_ID_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String delegationId;

    private final String errorCode;

    private final String errorMessage;

    private BatchDeleteDelegationByAssessmentError(BuilderImpl builder) {
        this.delegationId = builder.delegationId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The identifier for the specified delegation.
     * </p>
     * 
     * @return The identifier for the specified delegation.
     */
    public final String delegationId() {
        return delegationId;
    }

    /**
     * <p>
     * The error code returned by the <code>BatchDeleteDelegationByAssessment</code> API.
     * </p>
     * 
     * @return The error code returned by the <code>BatchDeleteDelegationByAssessment</code> API.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message returned by the <code>BatchDeleteDelegationByAssessment</code> API.
     * </p>
     * 
     * @return The error message returned by the <code>BatchDeleteDelegationByAssessment</code> API.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delegationId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDelegationByAssessmentError)) {
            return false;
        }
        BatchDeleteDelegationByAssessmentError other = (BatchDeleteDelegationByAssessmentError) obj;
        return Objects.equals(delegationId(), other.delegationId()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteDelegationByAssessmentError").add("DelegationId", delegationId())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegationId":
            return Optional.ofNullable(clazz.cast(delegationId()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDelegationByAssessmentError, T> g) {
        return obj -> g.apply((BatchDeleteDelegationByAssessmentError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteDelegationByAssessmentError> {
        /**
         * <p>
         * The identifier for the specified delegation.
         * </p>
         * 
         * @param delegationId
         *        The identifier for the specified delegation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationId(String delegationId);

        /**
         * <p>
         * The error code returned by the <code>BatchDeleteDelegationByAssessment</code> API.
         * </p>
         * 
         * @param errorCode
         *        The error code returned by the <code>BatchDeleteDelegationByAssessment</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message returned by the <code>BatchDeleteDelegationByAssessment</code> API.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned by the <code>BatchDeleteDelegationByAssessment</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String delegationId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDelegationByAssessmentError model) {
            delegationId(model.delegationId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getDelegationId() {
            return delegationId;
        }

        public final void setDelegationId(String delegationId) {
            this.delegationId = delegationId;
        }

        @Override
        @Transient
        public final Builder delegationId(String delegationId) {
            this.delegationId = delegationId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchDeleteDelegationByAssessmentError build() {
            return new BatchDeleteDelegationByAssessmentError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
