/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentRequest extends AuditManagerRequest implements
        ToCopyableBuilder<CreateAssessmentRequest.Builder, CreateAssessmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssessmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssessmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AssessmentReportsDestination> ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField
            .<AssessmentReportsDestination> builder(MarshallingType.SDK_POJO)
            .memberName("assessmentReportsDestination")
            .getter(getter(CreateAssessmentRequest::assessmentReportsDestination))
            .setter(setter(Builder::assessmentReportsDestination))
            .constructor(AssessmentReportsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportsDestination")
                    .build()).build();

    private static final SdkField<Scope> SCOPE_FIELD = SdkField.<Scope> builder(MarshallingType.SDK_POJO).memberName("scope")
            .getter(getter(CreateAssessmentRequest::scope)).setter(setter(Builder::scope)).constructor(Scope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<List<Role>> ROLES_FIELD = SdkField
            .<List<Role>> builder(MarshallingType.LIST)
            .memberName("roles")
            .getter(getter(CreateAssessmentRequest::roles))
            .setter(setter(Builder::roles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Role> builder(MarshallingType.SDK_POJO)
                                            .constructor(Role::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameworkId").getter(getter(CreateAssessmentRequest::frameworkId)).setter(setter(Builder::frameworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAssessmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ASSESSMENT_REPORTS_DESTINATION_FIELD, SCOPE_FIELD, ROLES_FIELD, FRAMEWORK_ID_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final AssessmentReportsDestination assessmentReportsDestination;

    private final Scope scope;

    private final List<Role> roles;

    private final String frameworkId;

    private final Map<String, String> tags;

    private CreateAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.assessmentReportsDestination = builder.assessmentReportsDestination;
        this.scope = builder.scope;
        this.roles = builder.roles;
        this.frameworkId = builder.frameworkId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the assessment to be created.
     * </p>
     * 
     * @return The name of the assessment to be created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The optional description of the assessment to be created.
     * </p>
     * 
     * @return The optional description of the assessment to be created.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The assessment report storage destination for the specified assessment that is being created.
     * </p>
     * 
     * @return The assessment report storage destination for the specified assessment that is being created.
     */
    public final AssessmentReportsDestination assessmentReportsDestination() {
        return assessmentReportsDestination;
    }

    /**
     * Returns the value of the Scope property for this object.
     * 
     * @return The value of the Scope property for this object.
     */
    public final Scope scope() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the Roles property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoles() {
        return roles != null && !(roles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of roles for the specified assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return The list of roles for the specified assessment.
     */
    public final List<Role> roles() {
        return roles;
    }

    /**
     * <p>
     * The identifier for the specified framework.
     * </p>
     * 
     * @return The identifier for the specified framework.
     */
    public final String frameworkId() {
        return frameworkId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the assessment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoles() ? roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentRequest)) {
            return false;
        }
        CreateAssessmentRequest other = (CreateAssessmentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(assessmentReportsDestination(), other.assessmentReportsDestination())
                && Objects.equals(scope(), other.scope()) && hasRoles() == other.hasRoles()
                && Objects.equals(roles(), other.roles()) && Objects.equals(frameworkId(), other.frameworkId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssessmentRequest").add("Name", name()).add("Description", description())
                .add("AssessmentReportsDestination", assessmentReportsDestination()).add("Scope", scope())
                .add("Roles", hasRoles() ? roles() : null).add("FrameworkId", frameworkId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "assessmentReportsDestination":
            return Optional.ofNullable(clazz.cast(assessmentReportsDestination()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "roles":
            return Optional.ofNullable(clazz.cast(roles()));
        case "frameworkId":
            return Optional.ofNullable(clazz.cast(frameworkId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentRequest, T> g) {
        return obj -> g.apply((CreateAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssessmentRequest> {
        /**
         * <p>
         * The name of the assessment to be created.
         * </p>
         * 
         * @param name
         *        The name of the assessment to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The optional description of the assessment to be created.
         * </p>
         * 
         * @param description
         *        The optional description of the assessment to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The assessment report storage destination for the specified assessment that is being created.
         * </p>
         * 
         * @param assessmentReportsDestination
         *        The assessment report storage destination for the specified assessment that is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination);

        /**
         * <p>
         * The assessment report storage destination for the specified assessment that is being created.
         * </p>
         * This is a convenience that creates an instance of the {@link AssessmentReportsDestination.Builder} avoiding
         * the need to create one manually via {@link AssessmentReportsDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentReportsDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentReportsDestination(AssessmentReportsDestination)}.
         * 
         * @param assessmentReportsDestination
         *        a consumer that will call methods on {@link AssessmentReportsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentReportsDestination(AssessmentReportsDestination)
         */
        default Builder assessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> assessmentReportsDestination) {
            return assessmentReportsDestination(AssessmentReportsDestination.builder()
                    .applyMutation(assessmentReportsDestination).build());
        }

        /**
         * Sets the value of the Scope property for this object.
         *
         * @param scope
         *        The new value for the Scope property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * Sets the value of the Scope property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scope.Builder} avoiding the need to create one
         * manually via {@link Scope#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The list of roles for the specified assessment.
         * </p>
         * 
         * @param roles
         *        The list of roles for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Collection<Role> roles);

        /**
         * <p>
         * The list of roles for the specified assessment.
         * </p>
         * 
         * @param roles
         *        The list of roles for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Role... roles);

        /**
         * <p>
         * The list of roles for the specified assessment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Role>.Builder} avoiding the need to create
         * one manually via {@link List<Role>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Role>.Builder#build()} is called immediately and its result
         * is passed to {@link #roles(List<Role>)}.
         * 
         * @param roles
         *        a consumer that will call methods on {@link List<Role>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roles(List<Role>)
         */
        Builder roles(Consumer<Role.Builder>... roles);

        /**
         * <p>
         * The identifier for the specified framework.
         * </p>
         * 
         * @param frameworkId
         *        The identifier for the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkId(String frameworkId);

        /**
         * <p>
         * The tags associated with the assessment.
         * </p>
         * 
         * @param tags
         *        The tags associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private AssessmentReportsDestination assessmentReportsDestination;

        private Scope scope;

        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();

        private String frameworkId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            assessmentReportsDestination(model.assessmentReportsDestination);
            scope(model.scope);
            roles(model.roles);
            frameworkId(model.frameworkId);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AssessmentReportsDestination.Builder getAssessmentReportsDestination() {
            return assessmentReportsDestination != null ? assessmentReportsDestination.toBuilder() : null;
        }

        public final void setAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination != null ? assessmentReportsDestination.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        @Transient
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final List<Role.Builder> getRoles() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = RolesCopier.copyFromBuilder(roles);
        }

        @Override
        @Transient
        public final Builder roles(Collection<Role> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roles(Role... roles) {
            roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder>... roles) {
            roles(Stream.of(roles).map(c -> Role.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFrameworkId() {
            return frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        @Transient
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentRequest build() {
            return new CreateAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
