/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentFrameworkRequest extends AuditManagerRequest implements
        ToCopyableBuilder<CreateAssessmentFrameworkRequest.Builder, CreateAssessmentFrameworkRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssessmentFrameworkRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssessmentFrameworkRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(CreateAssessmentFrameworkRequest::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final SdkField<List<CreateAssessmentFrameworkControlSet>> CONTROL_SETS_FIELD = SdkField
            .<List<CreateAssessmentFrameworkControlSet>> builder(MarshallingType.LIST)
            .memberName("controlSets")
            .getter(getter(CreateAssessmentFrameworkRequest::controlSets))
            .setter(setter(Builder::controlSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAssessmentFrameworkControlSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAssessmentFrameworkControlSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAssessmentFrameworkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            COMPLIANCE_TYPE_FIELD, CONTROL_SETS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String complianceType;

    private final List<CreateAssessmentFrameworkControlSet> controlSets;

    private final Map<String, String> tags;

    private CreateAssessmentFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.complianceType = builder.complianceType;
        this.controlSets = builder.controlSets;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the new custom framework.
     * </p>
     * 
     * @return The name of the new custom framework.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the new custom framework.
     * </p>
     * 
     * @return An optional description for the new custom framework.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     * </p>
     * 
     * @return The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlSets() {
        return controlSets != null && !(controlSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The control sets to be associated with the framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlSets} method.
     * </p>
     * 
     * @return The control sets to be associated with the framework.
     */
    public final List<CreateAssessmentFrameworkControlSet> controlSets() {
        return controlSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the framework.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlSets() ? controlSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentFrameworkRequest)) {
            return false;
        }
        CreateAssessmentFrameworkRequest other = (CreateAssessmentFrameworkRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(complianceType(), other.complianceType()) && hasControlSets() == other.hasControlSets()
                && Objects.equals(controlSets(), other.controlSets()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssessmentFrameworkRequest").add("Name", name()).add("Description", description())
                .add("ComplianceType", complianceType()).add("ControlSets", hasControlSets() ? controlSets() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "controlSets":
            return Optional.ofNullable(clazz.cast(controlSets()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentFrameworkRequest, T> g) {
        return obj -> g.apply((CreateAssessmentFrameworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAssessmentFrameworkRequest> {
        /**
         * <p>
         * The name of the new custom framework.
         * </p>
         * 
         * @param name
         *        The name of the new custom framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the new custom framework.
         * </p>
         * 
         * @param description
         *        An optional description for the new custom framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The control sets to be associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets to be associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(Collection<CreateAssessmentFrameworkControlSet> controlSets);

        /**
         * <p>
         * The control sets to be associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets to be associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(CreateAssessmentFrameworkControlSet... controlSets);

        /**
         * <p>
         * The control sets to be associated with the framework.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CreateAssessmentFrameworkControlSet>.Builder} avoiding the need to create one manually via {@link List
         * <CreateAssessmentFrameworkControlSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAssessmentFrameworkControlSet>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #controlSets(List<CreateAssessmentFrameworkControlSet>)}.
         * 
         * @param controlSets
         *        a consumer that will call methods on {@link List<CreateAssessmentFrameworkControlSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlSets(List<CreateAssessmentFrameworkControlSet>)
         */
        Builder controlSets(Consumer<CreateAssessmentFrameworkControlSet.Builder>... controlSets);

        /**
         * <p>
         * The tags associated with the framework.
         * </p>
         * 
         * @param tags
         *        The tags associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String complianceType;

        private List<CreateAssessmentFrameworkControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentFrameworkRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            complianceType(model.complianceType);
            controlSets(model.controlSets);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final List<CreateAssessmentFrameworkControlSet.Builder> getControlSets() {
            List<CreateAssessmentFrameworkControlSet.Builder> result = CreateAssessmentFrameworkControlSetsCopier
                    .copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlSets(Collection<CreateAssessmentFrameworkControlSet.BuilderImpl> controlSets) {
            this.controlSets = CreateAssessmentFrameworkControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        @Transient
        public final Builder controlSets(Collection<CreateAssessmentFrameworkControlSet> controlSets) {
            this.controlSets = CreateAssessmentFrameworkControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlSets(CreateAssessmentFrameworkControlSet... controlSets) {
            controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlSets(Consumer<CreateAssessmentFrameworkControlSet.Builder>... controlSets) {
            controlSets(Stream.of(controlSets).map(c -> CreateAssessmentFrameworkControlSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentFrameworkRequest build() {
            return new CreateAssessmentFrameworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
