/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>controlSet</code> entity that represents a collection of controls in Audit Manager. This does not contain the
 * control set ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentFrameworkControlSet implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateAssessmentFrameworkControlSet.Builder, UpdateAssessmentFrameworkControlSet> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateAssessmentFrameworkControlSet::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAssessmentFrameworkControlSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<CreateAssessmentFrameworkControl>> CONTROLS_FIELD = SdkField
            .<List<CreateAssessmentFrameworkControl>> builder(MarshallingType.LIST)
            .memberName("controls")
            .getter(getter(UpdateAssessmentFrameworkControlSet::controls))
            .setter(setter(Builder::controls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAssessmentFrameworkControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAssessmentFrameworkControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CONTROLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final List<CreateAssessmentFrameworkControl> controls;

    private UpdateAssessmentFrameworkControlSet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.controls = builder.controls;
    }

    /**
     * <p>
     * The unique identifier for the control set.
     * </p>
     * 
     * @return The unique identifier for the control set.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the control set.
     * </p>
     * 
     * @return The name of the control set.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Controls property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasControls() {
        return controls != null && !(controls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of controls contained within the control set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasControls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of controls contained within the control set.
     */
    public final List<CreateAssessmentFrameworkControl> controls() {
        return controls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasControls() ? controls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentFrameworkControlSet)) {
            return false;
        }
        UpdateAssessmentFrameworkControlSet other = (UpdateAssessmentFrameworkControlSet) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && hasControls() == other.hasControls()
                && Objects.equals(controls(), other.controls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentFrameworkControlSet").add("Id", id()).add("Name", name())
                .add("Controls", hasControls() ? controls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "controls":
            return Optional.ofNullable(clazz.cast(controls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentFrameworkControlSet, T> g) {
        return obj -> g.apply((UpdateAssessmentFrameworkControlSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateAssessmentFrameworkControlSet> {
        /**
         * <p>
         * The unique identifier for the control set.
         * </p>
         * 
         * @param id
         *        The unique identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the control set.
         * </p>
         * 
         * @param name
         *        The name of the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of controls contained within the control set.
         * </p>
         * 
         * @param controls
         *        The list of controls contained within the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(Collection<CreateAssessmentFrameworkControl> controls);

        /**
         * <p>
         * The list of controls contained within the control set.
         * </p>
         * 
         * @param controls
         *        The list of controls contained within the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(CreateAssessmentFrameworkControl... controls);

        /**
         * <p>
         * The list of controls contained within the control set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateAssessmentFrameworkControl>.Builder}
         * avoiding the need to create one manually via {@link List<CreateAssessmentFrameworkControl>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAssessmentFrameworkControl>.Builder#build()} is called
         * immediately and its result is passed to {@link #controls(List<CreateAssessmentFrameworkControl>)}.
         * 
         * @param controls
         *        a consumer that will call methods on {@link List<CreateAssessmentFrameworkControl>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controls(List<CreateAssessmentFrameworkControl>)
         */
        Builder controls(Consumer<CreateAssessmentFrameworkControl.Builder>... controls);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private List<CreateAssessmentFrameworkControl> controls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentFrameworkControlSet model) {
            id(model.id);
            name(model.name);
            controls(model.controls);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<CreateAssessmentFrameworkControl.Builder> getControls() {
            List<CreateAssessmentFrameworkControl.Builder> result = CreateAssessmentFrameworkControlsCopier
                    .copyToBuilder(this.controls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder controls(Collection<CreateAssessmentFrameworkControl> controls) {
            this.controls = CreateAssessmentFrameworkControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(CreateAssessmentFrameworkControl... controls) {
            controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<CreateAssessmentFrameworkControl.Builder>... controls) {
            controls(Stream.of(controls).map(c -> CreateAssessmentFrameworkControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setControls(Collection<CreateAssessmentFrameworkControl.BuilderImpl> controls) {
            this.controls = CreateAssessmentFrameworkControlsCopier.copyFromBuilder(controls);
        }

        @Override
        public UpdateAssessmentFrameworkControlSet build() {
            return new UpdateAssessmentFrameworkControlSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
