/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Evidence that is uploaded to Audit Manager manually.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManualEvidence implements SdkPojo, Serializable, ToCopyableBuilder<ManualEvidence.Builder, ManualEvidence> {
    private static final SdkField<String> S3_RESOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ResourcePath").getter(getter(ManualEvidence::s3ResourcePath)).setter(setter(Builder::s3ResourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ResourcePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3ResourcePath;

    private ManualEvidence(BuilderImpl builder) {
        this.s3ResourcePath = builder.s3ResourcePath;
    }

    /**
     * <p>
     * The Amazon S3 URL that points to a manual evidence object.
     * </p>
     * 
     * @return The Amazon S3 URL that points to a manual evidence object.
     */
    public final String s3ResourcePath() {
        return s3ResourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ResourcePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManualEvidence)) {
            return false;
        }
        ManualEvidence other = (ManualEvidence) obj;
        return Objects.equals(s3ResourcePath(), other.s3ResourcePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManualEvidence").add("S3ResourcePath", s3ResourcePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3ResourcePath":
            return Optional.ofNullable(clazz.cast(s3ResourcePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManualEvidence, T> g) {
        return obj -> g.apply((ManualEvidence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManualEvidence> {
        /**
         * <p>
         * The Amazon S3 URL that points to a manual evidence object.
         * </p>
         * 
         * @param s3ResourcePath
         *        The Amazon S3 URL that points to a manual evidence object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResourcePath(String s3ResourcePath);
    }

    static final class BuilderImpl implements Builder {
        private String s3ResourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(ManualEvidence model) {
            s3ResourcePath(model.s3ResourcePath);
        }

        public final String getS3ResourcePath() {
            return s3ResourcePath;
        }

        public final void setS3ResourcePath(String s3ResourcePath) {
            this.s3ResourcePath = s3ResourcePath;
        }

        @Override
        @Transient
        public final Builder s3ResourcePath(String s3ResourcePath) {
            this.s3ResourcePath = s3ResourcePath;
            return this;
        }

        @Override
        public ManualEvidence build() {
            return new ManualEvidence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
