/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The notification used to inform a user of an update in Audit Manager. For example, this includes the notification
 * that is sent when a control set is delegated for review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Notification implements SdkPojo, Serializable, ToCopyableBuilder<Notification.Builder, Notification> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Notification::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(Notification::assessmentId)).setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(Notification::assessmentName)).setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(Notification::controlSetId)).setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()).build();

    private static final SdkField<String> CONTROL_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetName").getter(getter(Notification::controlSetName)).setter(setter(Builder::controlSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Notification::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTime").getter(getter(Notification::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(Notification::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ASSESSMENT_ID_FIELD,
            ASSESSMENT_NAME_FIELD, CONTROL_SET_ID_FIELD, CONTROL_SET_NAME_FIELD, DESCRIPTION_FIELD, EVENT_TIME_FIELD,
            SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String assessmentId;

    private final String assessmentName;

    private final String controlSetId;

    private final String controlSetName;

    private final String description;

    private final Instant eventTime;

    private final String source;

    private Notification(BuilderImpl builder) {
        this.id = builder.id;
        this.assessmentId = builder.assessmentId;
        this.assessmentName = builder.assessmentName;
        this.controlSetId = builder.controlSetId;
        this.controlSetName = builder.controlSetName;
        this.description = builder.description;
        this.eventTime = builder.eventTime;
        this.source = builder.source;
    }

    /**
     * <p>
     * The unique identifier for the notification.
     * </p>
     * 
     * @return The unique identifier for the notification.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier for the specified assessment.
     * </p>
     * 
     * @return The identifier for the specified assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The name of the related assessment.
     * </p>
     * 
     * @return The name of the related assessment.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The identifier for the specified control set.
     * </p>
     * 
     * @return The identifier for the specified control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * Specifies the name of the control set that the notification is about.
     * </p>
     * 
     * @return Specifies the name of the control set that the notification is about.
     */
    public final String controlSetName() {
        return controlSetName;
    }

    /**
     * <p>
     * The description of the notification.
     * </p>
     * 
     * @return The description of the notification.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time when the notification was sent.
     * </p>
     * 
     * @return The time when the notification was sent.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * The sender of the notification.
     * </p>
     * 
     * @return The sender of the notification.
     */
    public final String source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(assessmentId(), other.assessmentId())
                && Objects.equals(assessmentName(), other.assessmentName())
                && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(controlSetName(), other.controlSetName()) && Objects.equals(description(), other.description())
                && Objects.equals(eventTime(), other.eventTime()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Notification").add("Id", id()).add("AssessmentId", assessmentId())
                .add("AssessmentName", assessmentName()).add("ControlSetId", controlSetId())
                .add("ControlSetName", controlSetName()).add("Description", description()).add("EventTime", eventTime())
                .add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "controlSetName":
            return Optional.ofNullable(clazz.cast(controlSetName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Notification, T> g) {
        return obj -> g.apply((Notification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Notification> {
        /**
         * <p>
         * The unique identifier for the notification.
         * </p>
         * 
         * @param id
         *        The unique identifier for the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier for the specified assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The name of the related assessment.
         * </p>
         * 
         * @param assessmentName
         *        The name of the related assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The identifier for the specified control set.
         * </p>
         * 
         * @param controlSetId
         *        The identifier for the specified control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * Specifies the name of the control set that the notification is about.
         * </p>
         * 
         * @param controlSetName
         *        Specifies the name of the control set that the notification is about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetName(String controlSetName);

        /**
         * <p>
         * The description of the notification.
         * </p>
         * 
         * @param description
         *        The description of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time when the notification was sent.
         * </p>
         * 
         * @param eventTime
         *        The time when the notification was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * The sender of the notification.
         * </p>
         * 
         * @param source
         *        The sender of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String assessmentId;

        private String assessmentName;

        private String controlSetId;

        private String controlSetName;

        private String description;

        private Instant eventTime;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            id(model.id);
            assessmentId(model.assessmentId);
            assessmentName(model.assessmentName);
            controlSetId(model.controlSetId);
            controlSetName(model.controlSetName);
            description(model.description);
            eventTime(model.eventTime);
            source(model.source);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        @Transient
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        @Transient
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        @Transient
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getControlSetName() {
            return controlSetName;
        }

        public final void setControlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
        }

        @Override
        @Transient
        public final Builder controlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        @Transient
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public Notification build() {
            return new Notification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
