/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The wrapper that contains the Audit Manager role information of the current user, such as the role type and IAM
 * Amazon Resource Name (ARN).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Role implements SdkPojo, Serializable, ToCopyableBuilder<Role.Builder, Role> {
    private static final SdkField<String> ROLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleType").getter(getter(Role::roleTypeAsString)).setter(setter(Builder::roleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleType").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(Role::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_TYPE_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleType;

    private final String roleArn;

    private Role(BuilderImpl builder) {
        this.roleType = builder.roleType;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The type of customer persona.
     * </p>
     * <note>
     * <p>
     * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be <code>RESOURCE_OWNER</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleType} will
     * return {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleTypeAsString}.
     * </p>
     * 
     * @return The type of customer persona. </p> <note>
     *         <p>
     *         In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
     *         <code>RESOURCE_OWNER</code>.
     *         </p>
     * @see RoleType
     */
    public final RoleType roleType() {
        return RoleType.fromValue(roleType);
    }

    /**
     * <p>
     * The type of customer persona.
     * </p>
     * <note>
     * <p>
     * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be <code>RESOURCE_OWNER</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleType} will
     * return {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleTypeAsString}.
     * </p>
     * 
     * @return The type of customer persona. </p> <note>
     *         <p>
     *         In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
     *         <code>RESOURCE_OWNER</code>.
     *         </p>
     * @see RoleType
     */
    public final String roleTypeAsString() {
        return roleType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role) obj;
        return Objects.equals(roleTypeAsString(), other.roleTypeAsString()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Role").add("RoleType", roleTypeAsString()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleType":
            return Optional.ofNullable(clazz.cast(roleTypeAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Role, T> g) {
        return obj -> g.apply((Role) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Role> {
        /**
         * <p>
         * The type of customer persona.
         * </p>
         * <note>
         * <p>
         * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         * <code>RESOURCE_OWNER</code>.
         * </p>
         * </note>
         * 
         * @param roleType
         *        The type of customer persona. </p> <note>
         *        <p>
         *        In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         *        <code>RESOURCE_OWNER</code>.
         *        </p>
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder roleType(String roleType);

        /**
         * <p>
         * The type of customer persona.
         * </p>
         * <note>
         * <p>
         * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         * <code>RESOURCE_OWNER</code>.
         * </p>
         * </note>
         * 
         * @param roleType
         *        The type of customer persona. </p> <note>
         *        <p>
         *        In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         *        <code>RESOURCE_OWNER</code>.
         *        </p>
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder roleType(RoleType roleType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String roleType;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            roleType(model.roleType);
            roleArn(model.roleArn);
        }

        public final String getRoleType() {
            return roleType;
        }

        public final void setRoleType(String roleType) {
            this.roleType = roleType;
        }

        @Override
        @Transient
        public final Builder roleType(String roleType) {
            this.roleType = roleType;
            return this;
        }

        @Override
        @Transient
        public final Builder roleType(RoleType roleType) {
            this.roleType(roleType == null ? null : roleType.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Role build() {
            return new Role(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
