/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlsResponse extends AuditManagerResponse implements
        ToCopyableBuilder<ListControlsResponse.Builder, ListControlsResponse> {
    private static final SdkField<List<ControlMetadata>> CONTROL_METADATA_LIST_FIELD = SdkField
            .<List<ControlMetadata>> builder(MarshallingType.LIST)
            .memberName("controlMetadataList")
            .getter(getter(ListControlsResponse::controlMetadataList))
            .setter(setter(Builder::controlMetadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMetadataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListControlsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_METADATA_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ControlMetadata> controlMetadataList;

    private final String nextToken;

    private ListControlsResponse(BuilderImpl builder) {
        super(builder);
        this.controlMetadataList = builder.controlMetadataList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlMetadataList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlMetadataList() {
        return controlMetadataList != null && !(controlMetadataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of control metadata objects returned by the <code>ListControls</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlMetadataList} method.
     * </p>
     * 
     * @return The list of control metadata objects returned by the <code>ListControls</code> API.
     */
    public final List<ControlMetadata> controlMetadataList() {
        return controlMetadataList;
    }

    /**
     * <p>
     * The pagination token used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasControlMetadataList() ? controlMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlsResponse)) {
            return false;
        }
        ListControlsResponse other = (ListControlsResponse) obj;
        return hasControlMetadataList() == other.hasControlMetadataList()
                && Objects.equals(controlMetadataList(), other.controlMetadataList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlsResponse")
                .add("ControlMetadataList", hasControlMetadataList() ? controlMetadataList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlMetadataList":
            return Optional.ofNullable(clazz.cast(controlMetadataList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListControlsResponse, T> g) {
        return obj -> g.apply((ListControlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListControlsResponse> {
        /**
         * <p>
         * The list of control metadata objects returned by the <code>ListControls</code> API.
         * </p>
         * 
         * @param controlMetadataList
         *        The list of control metadata objects returned by the <code>ListControls</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMetadataList(Collection<ControlMetadata> controlMetadataList);

        /**
         * <p>
         * The list of control metadata objects returned by the <code>ListControls</code> API.
         * </p>
         * 
         * @param controlMetadataList
         *        The list of control metadata objects returned by the <code>ListControls</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMetadataList(ControlMetadata... controlMetadataList);

        /**
         * <p>
         * The list of control metadata objects returned by the <code>ListControls</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ControlMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<ControlMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ControlMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #controlMetadataList(List<ControlMetadata>)}.
         * 
         * @param controlMetadataList
         *        a consumer that will call methods on {@link List<ControlMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlMetadataList(List<ControlMetadata>)
         */
        Builder controlMetadataList(Consumer<ControlMetadata.Builder>... controlMetadataList);

        /**
         * <p>
         * The pagination token used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<ControlMetadata> controlMetadataList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlsResponse model) {
            super(model);
            controlMetadataList(model.controlMetadataList);
            nextToken(model.nextToken);
        }

        public final List<ControlMetadata.Builder> getControlMetadataList() {
            List<ControlMetadata.Builder> result = ControlMetadataListCopier.copyToBuilder(this.controlMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlMetadataList(Collection<ControlMetadata.BuilderImpl> controlMetadataList) {
            this.controlMetadataList = ControlMetadataListCopier.copyFromBuilder(controlMetadataList);
        }

        @Override
        @Transient
        public final Builder controlMetadataList(Collection<ControlMetadata> controlMetadataList) {
            this.controlMetadataList = ControlMetadataListCopier.copy(controlMetadataList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlMetadataList(ControlMetadata... controlMetadataList) {
            controlMetadataList(Arrays.asList(controlMetadataList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlMetadataList(Consumer<ControlMetadata.Builder>... controlMetadataList) {
            controlMetadataList(Stream.of(controlMetadataList).map(c -> ControlMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListControlsResponse build() {
            return new ListControlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
