/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Notification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Notification> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Notification.getter(Notification::id)).setter(Notification.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(Notification.getter(Notification::assessmentId)).setter(Notification.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(Notification.getter(Notification::assessmentName)).setter(Notification.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(Notification.getter(Notification::controlSetId)).setter(Notification.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()}).build();
    private static final SdkField<String> CONTROL_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetName").getter(Notification.getter(Notification::controlSetName)).setter(Notification.setter(Builder::controlSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Notification.getter(Notification::description)).setter(Notification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(Notification.getter(Notification::eventTime)).setter(Notification.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(Notification.getter(Notification::source)).setter(Notification.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ASSESSMENT_ID_FIELD, ASSESSMENT_NAME_FIELD, CONTROL_SET_ID_FIELD, CONTROL_SET_NAME_FIELD, DESCRIPTION_FIELD, EVENT_TIME_FIELD, SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String assessmentId;
    private final String assessmentName;
    private final String controlSetId;
    private final String controlSetName;
    private final String description;
    private final Instant eventTime;
    private final String source;

    private Notification(BuilderImpl builder) {
        this.id = builder.id;
        this.assessmentId = builder.assessmentId;
        this.assessmentName = builder.assessmentName;
        this.controlSetId = builder.controlSetId;
        this.controlSetName = builder.controlSetName;
        this.description = builder.description;
        this.eventTime = builder.eventTime;
        this.source = builder.source;
    }

    public final String id() {
        return this.id;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final String controlSetName() {
        return this.controlSetName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.assessmentName(), other.assessmentName()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.controlSetName(), other.controlSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"Notification").add("Id", (Object)this.id()).add("AssessmentId", (Object)this.assessmentId()).add("AssessmentName", (Object)this.assessmentName()).add("ControlSetId", (Object)this.controlSetId()).add("ControlSetName", (Object)this.controlSetName()).add("Description", (Object)this.description()).add("EventTime", (Object)this.eventTime()).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "controlSetName": {
                return Optional.ofNullable(clazz.cast(this.controlSetName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Notification, T> g) {
        return obj -> g.apply((Notification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String assessmentId;
        private String assessmentName;
        private String controlSetId;
        private String controlSetName;
        private String description;
        private Instant eventTime;
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.id(model.id);
            this.assessmentId(model.assessmentId);
            this.assessmentName(model.assessmentName);
            this.controlSetId(model.controlSetId);
            this.controlSetName(model.controlSetName);
            this.description(model.description);
            this.eventTime(model.eventTime);
            this.source(model.source);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        @Transient
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        @Transient
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        @Transient
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getControlSetName() {
            return this.controlSetName;
        }

        public final void setControlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
        }

        @Override
        @Transient
        public final Builder controlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        @Transient
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Notification> {
        public Builder id(String var1);

        public Builder assessmentId(String var1);

        public Builder assessmentName(String var1);

        public Builder controlSetId(String var1);

        public Builder controlSetName(String var1);

        public Builder description(String var1);

        public Builder eventTime(Instant var1);

        public Builder source(String var1);
    }
}

