/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.auditmanager.model.AccessDeniedException;
import software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerException;
import software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateControlRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateControlResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteControlResponse;
import software.amazon.awssdk.services.auditmanager.model.DeregisterAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAccountStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetControlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetControlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeRequest;
import software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse;
import software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse;
import software.amazon.awssdk.services.auditmanager.model.InternalServerException;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse;
import software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.auditmanager.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.ThrottlingException;
import software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest;
import software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse;
import software.amazon.awssdk.services.auditmanager.model.ValidationException;
import software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable;
import software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable;
import software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable;
import software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable;

/**
 * Service client for accessing AWS Audit Manager. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the Audit Manager API reference. This guide is for developers who need detailed information about the
 * Audit Manager API operations, data types, and errors.
 * </p>
 * <p>
 * Audit Manager is a service that provides automated evidence collection so that you can continually audit your Amazon
 * Web Services usage. You can use it to assess the effectiveness of your controls, manage risk, and simplify
 * compliance.
 * </p>
 * <p>
 * Audit Manager provides prebuilt frameworks that structure and automate assessments for a given compliance standard.
 * Frameworks include a prebuilt collection of controls with descriptions and testing procedures. These controls are
 * grouped according to the requirements of the specified compliance standard or regulation. You can also customize
 * frameworks and controls to support internal audits with specific requirements.
 * </p>
 * <p>
 * Use the following links to get started with the Audit Manager API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Operations.html">Actions</a>: An
 * alphabetical list of all Audit Manager API operations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Types.html">Data types</a>: An
 * alphabetical list of all Audit Manager data types.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonParameters.html">Common parameters</a>:
 * Parameters that all operations can use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonErrors.html">Common errors</a>: Client
 * and server errors that all operations can return.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If you're new to Audit Manager, we recommend that you review the <a
 * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/what-is.html"> Audit Manager User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AuditManagerClient extends SdkClient {
    String SERVICE_NAME = "auditmanager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "auditmanager";

    /**
     * Create a {@link AuditManagerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AuditManagerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AuditManagerClient}.
     */
    static AuditManagerClientBuilder builder() {
        return new DefaultAuditManagerClientBuilder();
    }

    /**
     * <p>
     * Associates an evidence folder to an assessment report in an Audit Manager assessment.
     * </p>
     *
     * @param associateAssessmentReportEvidenceFolderRequest
     * @return Result of the AssociateAssessmentReportEvidenceFolder operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.AssociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAssessmentReportEvidenceFolderResponse associateAssessmentReportEvidenceFolder(
            AssociateAssessmentReportEvidenceFolderRequest associateAssessmentReportEvidenceFolderRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an evidence folder to an assessment report in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateAssessmentReportEvidenceFolderRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateAssessmentReportEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param associateAssessmentReportEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateAssessmentReportEvidenceFolderRequest.Builder} to create a request.
     * @return Result of the AssociateAssessmentReportEvidenceFolder operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.AssociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAssessmentReportEvidenceFolderResponse associateAssessmentReportEvidenceFolder(
            Consumer<AssociateAssessmentReportEvidenceFolderRequest.Builder> associateAssessmentReportEvidenceFolderRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return associateAssessmentReportEvidenceFolder(AssociateAssessmentReportEvidenceFolderRequest.builder()
                .applyMutation(associateAssessmentReportEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     * </p>
     *
     * @param batchAssociateAssessmentReportEvidenceRequest
     * @return Result of the BatchAssociateAssessmentReportEvidence operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchAssociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateAssessmentReportEvidenceResponse batchAssociateAssessmentReportEvidence(
            BatchAssociateAssessmentReportEvidenceRequest batchAssociateAssessmentReportEvidenceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateAssessmentReportEvidenceRequest.Builder} avoiding the need to create one manually via
     * {@link BatchAssociateAssessmentReportEvidenceRequest#builder()}
     * </p>
     *
     * @param batchAssociateAssessmentReportEvidenceRequest
     *        A {@link Consumer} that will call methods on {@link BatchAssociateAssessmentReportEvidenceRequest.Builder}
     *        to create a request.
     * @return Result of the BatchAssociateAssessmentReportEvidence operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchAssociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateAssessmentReportEvidenceResponse batchAssociateAssessmentReportEvidence(
            Consumer<BatchAssociateAssessmentReportEvidenceRequest.Builder> batchAssociateAssessmentReportEvidenceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return batchAssociateAssessmentReportEvidence(BatchAssociateAssessmentReportEvidenceRequest.builder()
                .applyMutation(batchAssociateAssessmentReportEvidenceRequest).build());
    }

    /**
     * <p>
     * Creates a batch of delegations for an assessment in Audit Manager.
     * </p>
     *
     * @param batchCreateDelegationByAssessmentRequest
     * @return Result of the BatchCreateDelegationByAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchCreateDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateDelegationByAssessmentResponse batchCreateDelegationByAssessment(
            BatchCreateDelegationByAssessmentRequest batchCreateDelegationByAssessmentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch of delegations for an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateDelegationByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCreateDelegationByAssessmentRequest#builder()}
     * </p>
     *
     * @param batchCreateDelegationByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateDelegationByAssessmentRequest.Builder} to
     *        create a request.
     * @return Result of the BatchCreateDelegationByAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchCreateDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateDelegationByAssessmentResponse batchCreateDelegationByAssessment(
            Consumer<BatchCreateDelegationByAssessmentRequest.Builder> batchCreateDelegationByAssessmentRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return batchCreateDelegationByAssessment(BatchCreateDelegationByAssessmentRequest.builder()
                .applyMutation(batchCreateDelegationByAssessmentRequest).build());
    }

    /**
     * <p>
     * Deletes a batch of delegations for an assessment in Audit Manager.
     * </p>
     *
     * @param batchDeleteDelegationByAssessmentRequest
     * @return Result of the BatchDeleteDelegationByAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchDeleteDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteDelegationByAssessmentResponse batchDeleteDelegationByAssessment(
            BatchDeleteDelegationByAssessmentRequest batchDeleteDelegationByAssessmentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch of delegations for an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDelegationByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteDelegationByAssessmentRequest#builder()}
     * </p>
     *
     * @param batchDeleteDelegationByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteDelegationByAssessmentRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDeleteDelegationByAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchDeleteDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteDelegationByAssessmentResponse batchDeleteDelegationByAssessment(
            Consumer<BatchDeleteDelegationByAssessmentRequest.Builder> batchDeleteDelegationByAssessmentRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return batchDeleteDelegationByAssessment(BatchDeleteDelegationByAssessmentRequest.builder()
                .applyMutation(batchDeleteDelegationByAssessmentRequest).build());
    }

    /**
     * <p>
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     * </p>
     *
     * @param batchDisassociateAssessmentReportEvidenceRequest
     * @return Result of the BatchDisassociateAssessmentReportEvidence operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchDisassociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateAssessmentReportEvidenceResponse batchDisassociateAssessmentReportEvidence(
            BatchDisassociateAssessmentReportEvidenceRequest batchDisassociateAssessmentReportEvidenceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateAssessmentReportEvidenceRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDisassociateAssessmentReportEvidenceRequest#builder()}
     * </p>
     *
     * @param batchDisassociateAssessmentReportEvidenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchDisassociateAssessmentReportEvidenceRequest.Builder} to create a request.
     * @return Result of the BatchDisassociateAssessmentReportEvidence operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchDisassociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateAssessmentReportEvidenceResponse batchDisassociateAssessmentReportEvidence(
            Consumer<BatchDisassociateAssessmentReportEvidenceRequest.Builder> batchDisassociateAssessmentReportEvidenceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return batchDisassociateAssessmentReportEvidence(BatchDisassociateAssessmentReportEvidenceRequest.builder()
                .applyMutation(batchDisassociateAssessmentReportEvidenceRequest).build());
    }

    /**
     * <p>
     * Uploads one or more pieces of evidence to a control in an Audit Manager assessment. You can upload manual
     * evidence from any Amazon Simple Storage Service (Amazon S3) bucket by specifying the S3 URI of the evidence.
     * </p>
     * <p>
     * You must upload manual evidence to your S3 bucket before you can upload it to your assessment. For instructions,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> in the <i>Amazon Simple
     * Storage Service API Reference.</i>
     * </p>
     * <p>
     * The following restrictions apply to this action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     *
     * @param batchImportEvidenceToAssessmentControlRequest
     * @return Result of the BatchImportEvidenceToAssessmentControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchImportEvidenceToAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchImportEvidenceToAssessmentControlResponse batchImportEvidenceToAssessmentControl(
            BatchImportEvidenceToAssessmentControlRequest batchImportEvidenceToAssessmentControlRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads one or more pieces of evidence to a control in an Audit Manager assessment. You can upload manual
     * evidence from any Amazon Simple Storage Service (Amazon S3) bucket by specifying the S3 URI of the evidence.
     * </p>
     * <p>
     * You must upload manual evidence to your S3 bucket before you can upload it to your assessment. For instructions,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> in the <i>Amazon Simple
     * Storage Service API Reference.</i>
     * </p>
     * <p>
     * The following restrictions apply to this action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchImportEvidenceToAssessmentControlRequest.Builder} avoiding the need to create one manually via
     * {@link BatchImportEvidenceToAssessmentControlRequest#builder()}
     * </p>
     *
     * @param batchImportEvidenceToAssessmentControlRequest
     *        A {@link Consumer} that will call methods on {@link BatchImportEvidenceToAssessmentControlRequest.Builder}
     *        to create a request.
     * @return Result of the BatchImportEvidenceToAssessmentControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.BatchImportEvidenceToAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchImportEvidenceToAssessmentControlResponse batchImportEvidenceToAssessmentControl(
            Consumer<BatchImportEvidenceToAssessmentControlRequest.Builder> batchImportEvidenceToAssessmentControlRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return batchImportEvidenceToAssessmentControl(BatchImportEvidenceToAssessmentControlRequest.builder()
                .applyMutation(batchImportEvidenceToAssessmentControlRequest).build());
    }

    /**
     * <p>
     * Creates an assessment in Audit Manager.
     * </p>
     *
     * @param createAssessmentRequest
     * @return Result of the CreateAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssessmentResponse createAssessment(CreateAssessmentRequest createAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssessmentRequest#builder()}
     * </p>
     *
     * @param createAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentRequest.Builder} to create a request.
     * @return Result of the CreateAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssessmentResponse createAssessment(Consumer<CreateAssessmentRequest.Builder> createAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, AuditManagerException {
        return createAssessment(CreateAssessmentRequest.builder().applyMutation(createAssessmentRequest).build());
    }

    /**
     * <p>
     * Creates a custom framework in Audit Manager.
     * </p>
     *
     * @param createAssessmentFrameworkRequest
     * @return Result of the CreateAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentFrameworkResponse createAssessmentFramework(
            CreateAssessmentFrameworkRequest createAssessmentFrameworkRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentFrameworkRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param createAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentFrameworkRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentFrameworkResponse createAssessmentFramework(
            Consumer<CreateAssessmentFrameworkRequest.Builder> createAssessmentFrameworkRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, AuditManagerException {
        return createAssessmentFramework(CreateAssessmentFrameworkRequest.builder()
                .applyMutation(createAssessmentFrameworkRequest).build());
    }

    /**
     * <p>
     * Creates an assessment report for the specified assessment.
     * </p>
     *
     * @param createAssessmentReportRequest
     * @return Result of the CreateAssessmentReport operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentReportResponse createAssessmentReport(CreateAssessmentReportRequest createAssessmentReportRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assessment report for the specified assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentReportRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssessmentReportRequest#builder()}
     * </p>
     *
     * @param createAssessmentReportRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentReportRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssessmentReport operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentReportResponse createAssessmentReport(
            Consumer<CreateAssessmentReportRequest.Builder> createAssessmentReportRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return createAssessmentReport(CreateAssessmentReportRequest.builder().applyMutation(createAssessmentReportRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom control in Audit Manager.
     * </p>
     *
     * @param createControlRequest
     * @return Result of the CreateControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateControlResponse createControl(CreateControlRequest createControlRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom control in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateControlRequest.Builder} avoiding the need to
     * create one manually via {@link CreateControlRequest#builder()}
     * </p>
     *
     * @param createControlRequest
     *        A {@link Consumer} that will call methods on {@link CreateControlRequest.Builder} to create a request.
     * @return Result of the CreateControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.CreateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateControlResponse createControl(Consumer<CreateControlRequest.Builder> createControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, AuditManagerException {
        return createControl(CreateControlRequest.builder().applyMutation(createControlRequest).build());
    }

    /**
     * <p>
     * Deletes an assessment in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentRequest
     * @return Result of the DeleteAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssessmentResponse deleteAssessment(DeleteAssessmentRequest deleteAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssessmentRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentRequest.Builder} to create a request.
     * @return Result of the DeleteAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssessmentResponse deleteAssessment(Consumer<DeleteAssessmentRequest.Builder> deleteAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return deleteAssessment(DeleteAssessmentRequest.builder().applyMutation(deleteAssessmentRequest).build());
    }

    /**
     * <p>
     * Deletes a custom framework in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentFrameworkRequest
     * @return Result of the DeleteAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentFrameworkResponse deleteAssessmentFramework(
            DeleteAssessmentFrameworkRequest deleteAssessmentFrameworkRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentFrameworkRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentFrameworkRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentFrameworkResponse deleteAssessmentFramework(
            Consumer<DeleteAssessmentFrameworkRequest.Builder> deleteAssessmentFrameworkRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return deleteAssessmentFramework(DeleteAssessmentFrameworkRequest.builder()
                .applyMutation(deleteAssessmentFrameworkRequest).build());
    }

    /**
     * <p>
     * Deletes a share request for a custom framework in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentFrameworkShareRequest
     * @return Result of the DeleteAssessmentFrameworkShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentFrameworkShareResponse deleteAssessmentFrameworkShare(
            DeleteAssessmentFrameworkShareRequest deleteAssessmentFrameworkShareRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a share request for a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentFrameworkShareRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAssessmentFrameworkShareRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentFrameworkShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentFrameworkShareRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAssessmentFrameworkShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentFrameworkShareResponse deleteAssessmentFrameworkShare(
            Consumer<DeleteAssessmentFrameworkShareRequest.Builder> deleteAssessmentFrameworkShareRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return deleteAssessmentFrameworkShare(DeleteAssessmentFrameworkShareRequest.builder()
                .applyMutation(deleteAssessmentFrameworkShareRequest).build());
    }

    /**
     * <p>
     * Deletes an assessment report in Audit Manager.
     * </p>
     * <p>
     * When you run the <code>DeleteAssessmentReport</code> operation, Audit Manager attempts to delete the following
     * data:
     * </p>
     * <ol>
     * <li>
     * <p>
     * The specified assessment report that’s stored in your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * The associated metadata that’s stored in Audit Manager
     * </p>
     * </li>
     * </ol>
     * <p>
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event,
     * the <code>DeleteAssessmentReport</code> operation doesn’t fail. Instead, it proceeds to delete the associated
     * metadata only. You must then delete the assessment report from the S3 bucket yourself.
     * </p>
     * <p>
     * This scenario happens when Audit Manager receives a <code>403 (Forbidden)</code> or <code>404 (Not Found)</code>
     * error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the
     * correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy
     * that you can use, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination"
     * >Assessment report destination permissions</a> in the <i>Audit Manager User Guide</i>. For information about the
     * issues that could cause a <code>403 (Forbidden)</code> or <code>404 (Not Found</code>) error from Amazon S3, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error
     * Codes</a> in the <i>Amazon Simple Storage Service API Reference</i>.
     * </p>
     *
     * @param deleteAssessmentReportRequest
     * @return Result of the DeleteAssessmentReport operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentReportResponse deleteAssessmentReport(DeleteAssessmentReportRequest deleteAssessmentReportRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assessment report in Audit Manager.
     * </p>
     * <p>
     * When you run the <code>DeleteAssessmentReport</code> operation, Audit Manager attempts to delete the following
     * data:
     * </p>
     * <ol>
     * <li>
     * <p>
     * The specified assessment report that’s stored in your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * The associated metadata that’s stored in Audit Manager
     * </p>
     * </li>
     * </ol>
     * <p>
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event,
     * the <code>DeleteAssessmentReport</code> operation doesn’t fail. Instead, it proceeds to delete the associated
     * metadata only. You must then delete the assessment report from the S3 bucket yourself.
     * </p>
     * <p>
     * This scenario happens when Audit Manager receives a <code>403 (Forbidden)</code> or <code>404 (Not Found)</code>
     * error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the
     * correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy
     * that you can use, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination"
     * >Assessment report destination permissions</a> in the <i>Audit Manager User Guide</i>. For information about the
     * issues that could cause a <code>403 (Forbidden)</code> or <code>404 (Not Found</code>) error from Amazon S3, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error
     * Codes</a> in the <i>Amazon Simple Storage Service API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentReportRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAssessmentReportRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentReportRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentReportRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssessmentReport operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentReportResponse deleteAssessmentReport(
            Consumer<DeleteAssessmentReportRequest.Builder> deleteAssessmentReportRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return deleteAssessmentReport(DeleteAssessmentReportRequest.builder().applyMutation(deleteAssessmentReportRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom control in Audit Manager.
     * </p>
     *
     * @param deleteControlRequest
     * @return Result of the DeleteControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteControlResponse deleteControl(DeleteControlRequest deleteControlRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom control in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteControlRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteControlRequest#builder()}
     * </p>
     *
     * @param deleteControlRequest
     *        A {@link Consumer} that will call methods on {@link DeleteControlRequest.Builder} to create a request.
     * @return Result of the DeleteControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeleteControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteControlResponse deleteControl(Consumer<DeleteControlRequest.Builder> deleteControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return deleteControl(DeleteControlRequest.builder().applyMutation(deleteControlRequest).build());
    }

    /**
     * <p>
     * Deregisters an account in Audit Manager.
     * </p>
     * <note>
     * <p>
     * Before you deregister, you can use the <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html">UpdateSettings</a>
     * API operation to set your preferred data retention policy. By default, Audit Manager retains your data. If you
     * want to delete your data, you can use the <code>DeregistrationPolicy</code> attribute to request the deletion of
     * your data.
     * </p>
     * <p>
     * For more information about data retention, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/data-protection.html">Data Protection</a> in the
     * <i>Audit Manager User Guide</i>.
     * </p>
     * </note>
     *
     * @param deregisterAccountRequest
     * @return Result of the DeregisterAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeregisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterAccountResponse deregisterAccount(DeregisterAccountRequest deregisterAccountRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an account in Audit Manager.
     * </p>
     * <note>
     * <p>
     * Before you deregister, you can use the <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html">UpdateSettings</a>
     * API operation to set your preferred data retention policy. By default, Audit Manager retains your data. If you
     * want to delete your data, you can use the <code>DeregistrationPolicy</code> attribute to request the deletion of
     * your data.
     * </p>
     * <p>
     * For more information about data retention, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/data-protection.html">Data Protection</a> in the
     * <i>Audit Manager User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterAccountRequest#builder()}
     * </p>
     *
     * @param deregisterAccountRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterAccountRequest.Builder} to create a request.
     * @return Result of the DeregisterAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeregisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterAccountResponse deregisterAccount(Consumer<DeregisterAccountRequest.Builder> deregisterAccountRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return deregisterAccount(DeregisterAccountRequest.builder().applyMutation(deregisterAccountRequest).build());
    }

    /**
     * <p>
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     * </p>
     * <p>
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the
     * evidence that you previously collected under that account. This is also the case when you deregister a delegated
     * administrator from Organizations. However, Audit Manager stops collecting and attaching evidence to that
     * delegated administrator account moving forward.
     * </p>
     * <important>
     * <p>
     * Keep in mind the following cleanup task if you use evidence finder:
     * </p>
     * <p>
     * Before you use your management account to remove a delegated administrator, make sure that the current delegated
     * administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder
     * automatically deletes the event data store that was created in their account when they enabled evidence finder.
     * If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the
     * original delegated administrator goes to CloudTrail Lake and manually <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-eds-disable-termination.html">deletes the
     * event data store</a>.
     * </p>
     * <p>
     * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager
     * ignores an unused event data store after you remove or change a delegated administrator account. However, the
     * unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
     * </p>
     * </important>
     * <p>
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted.
     * If you want to delete resource data for a delegated administrator account, you must perform that task separately
     * before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of
     * the delete API operations that are provided by Audit Manager.
     * </p>
     * <p>
     * To delete your Audit Manager resource data, see the following instructions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html">DeleteAssessment
     * </a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html">Deleting an
     * assessment</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html">
     * DeleteAssessmentFramework</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html">Deleting a custom
     * framework</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html">
     * DeleteAssessmentFrameworkShare</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html"
     * >Deleting a share request</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html">
     * DeleteAssessmentReport</a> (see also: <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps"
     * >Deleting an assessment report</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html">DeleteControl</a>
     * (see also: <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html">Deleting a
     * custom control</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * At this time, Audit Manager doesn't provide an option to delete evidence for a specific delegated administrator.
     * Instead, when your management account deregisters Audit Manager, we perform a cleanup for the current delegated
     * administrator account at the time of deregistration.
     * </p>
     *
     * @param deregisterOrganizationAdminAccountRequest
     * @return Result of the DeregisterOrganizationAdminAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeregisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterOrganizationAdminAccountResponse deregisterOrganizationAdminAccount(
            DeregisterOrganizationAdminAccountRequest deregisterOrganizationAdminAccountRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     * </p>
     * <p>
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the
     * evidence that you previously collected under that account. This is also the case when you deregister a delegated
     * administrator from Organizations. However, Audit Manager stops collecting and attaching evidence to that
     * delegated administrator account moving forward.
     * </p>
     * <important>
     * <p>
     * Keep in mind the following cleanup task if you use evidence finder:
     * </p>
     * <p>
     * Before you use your management account to remove a delegated administrator, make sure that the current delegated
     * administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder
     * automatically deletes the event data store that was created in their account when they enabled evidence finder.
     * If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the
     * original delegated administrator goes to CloudTrail Lake and manually <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-eds-disable-termination.html">deletes the
     * event data store</a>.
     * </p>
     * <p>
     * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager
     * ignores an unused event data store after you remove or change a delegated administrator account. However, the
     * unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
     * </p>
     * </important>
     * <p>
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted.
     * If you want to delete resource data for a delegated administrator account, you must perform that task separately
     * before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of
     * the delete API operations that are provided by Audit Manager.
     * </p>
     * <p>
     * To delete your Audit Manager resource data, see the following instructions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html">DeleteAssessment
     * </a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html">Deleting an
     * assessment</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html">
     * DeleteAssessmentFramework</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html">Deleting a custom
     * framework</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html">
     * DeleteAssessmentFrameworkShare</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html"
     * >Deleting a share request</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html">
     * DeleteAssessmentReport</a> (see also: <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps"
     * >Deleting an assessment report</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html">DeleteControl</a>
     * (see also: <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html">Deleting a
     * custom control</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * At this time, Audit Manager doesn't provide an option to delete evidence for a specific delegated administrator.
     * Instead, when your management account deregisters Audit Manager, we perform a cleanup for the current delegated
     * administrator account at the time of deregistration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param deregisterOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DeregisterOrganizationAdminAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DeregisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterOrganizationAdminAccountResponse deregisterOrganizationAdminAccount(
            Consumer<DeregisterOrganizationAdminAccountRequest.Builder> deregisterOrganizationAdminAccountRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return deregisterOrganizationAdminAccount(DeregisterOrganizationAdminAccountRequest.builder()
                .applyMutation(deregisterOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     * </p>
     *
     * @param disassociateAssessmentReportEvidenceFolderRequest
     * @return Result of the DisassociateAssessmentReportEvidenceFolder operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DisassociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAssessmentReportEvidenceFolderResponse disassociateAssessmentReportEvidenceFolder(
            DisassociateAssessmentReportEvidenceFolderRequest disassociateAssessmentReportEvidenceFolderRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateAssessmentReportEvidenceFolderRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateAssessmentReportEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param disassociateAssessmentReportEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateAssessmentReportEvidenceFolderRequest.Builder} to create a request.
     * @return Result of the DisassociateAssessmentReportEvidenceFolder operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.DisassociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAssessmentReportEvidenceFolderResponse disassociateAssessmentReportEvidenceFolder(
            Consumer<DisassociateAssessmentReportEvidenceFolderRequest.Builder> disassociateAssessmentReportEvidenceFolderRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return disassociateAssessmentReportEvidenceFolder(DisassociateAssessmentReportEvidenceFolderRequest.builder()
                .applyMutation(disassociateAssessmentReportEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Returns the registration status of an account in Audit Manager.
     * </p>
     *
     * @param getAccountStatusRequest
     * @return Result of the GetAccountStatus operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountStatusResponse getAccountStatus(GetAccountStatusRequest getAccountStatusRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the registration status of an account in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountStatusRequest#builder()}
     * </p>
     *
     * @param getAccountStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountStatusRequest.Builder} to create a request.
     * @return Result of the GetAccountStatus operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountStatusResponse getAccountStatus(Consumer<GetAccountStatusRequest.Builder> getAccountStatusRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return getAccountStatus(GetAccountStatusRequest.builder().applyMutation(getAccountStatusRequest).build());
    }

    /**
     * <p>
     * Returns an assessment from Audit Manager.
     * </p>
     *
     * @param getAssessmentRequest
     * @return Result of the GetAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAssessmentResponse getAssessment(GetAssessmentRequest getAssessmentRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an assessment from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssessmentRequest#builder()}
     * </p>
     *
     * @param getAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link GetAssessmentRequest.Builder} to create a request.
     * @return Result of the GetAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAssessmentResponse getAssessment(Consumer<GetAssessmentRequest.Builder> getAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getAssessment(GetAssessmentRequest.builder().applyMutation(getAssessmentRequest).build());
    }

    /**
     * <p>
     * Returns a framework from Audit Manager.
     * </p>
     *
     * @param getAssessmentFrameworkRequest
     * @return Result of the GetAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssessmentFrameworkResponse getAssessmentFramework(GetAssessmentFrameworkRequest getAssessmentFrameworkRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a framework from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentFrameworkRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param getAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on {@link GetAssessmentFrameworkRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssessmentFrameworkResponse getAssessmentFramework(
            Consumer<GetAssessmentFrameworkRequest.Builder> getAssessmentFrameworkRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getAssessmentFramework(GetAssessmentFrameworkRequest.builder().applyMutation(getAssessmentFrameworkRequest)
                .build());
    }

    /**
     * <p>
     * Returns the URL of an assessment report in Audit Manager.
     * </p>
     *
     * @param getAssessmentReportUrlRequest
     * @return Result of the GetAssessmentReportUrl operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAssessmentReportUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssessmentReportUrlResponse getAssessmentReportUrl(GetAssessmentReportUrlRequest getAssessmentReportUrlRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the URL of an assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentReportUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssessmentReportUrlRequest#builder()}
     * </p>
     *
     * @param getAssessmentReportUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetAssessmentReportUrlRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssessmentReportUrl operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetAssessmentReportUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssessmentReportUrlResponse getAssessmentReportUrl(
            Consumer<GetAssessmentReportUrlRequest.Builder> getAssessmentReportUrlRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getAssessmentReportUrl(GetAssessmentReportUrlRequest.builder().applyMutation(getAssessmentReportUrlRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of changelogs from Audit Manager.
     * </p>
     *
     * @param getChangeLogsRequest
     * @return Result of the GetChangeLogs operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChangeLogsResponse getChangeLogs(GetChangeLogsRequest getChangeLogsRequest) throws AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of changelogs from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChangeLogsRequest.Builder} avoiding the need to
     * create one manually via {@link GetChangeLogsRequest#builder()}
     * </p>
     *
     * @param getChangeLogsRequest
     *        A {@link Consumer} that will call methods on {@link GetChangeLogsRequest.Builder} to create a request.
     * @return Result of the GetChangeLogs operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChangeLogsResponse getChangeLogs(Consumer<GetChangeLogsRequest.Builder> getChangeLogsRequest)
            throws AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getChangeLogs(GetChangeLogsRequest.builder().applyMutation(getChangeLogsRequest).build());
    }

    /**
     * <p>
     * Returns a list of changelogs from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable responses = client.getChangeLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable responses = client
     *             .getChangeLogsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable responses = client.getChangeLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation.</b>
     * </p>
     *
     * @param getChangeLogsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChangeLogsIterable getChangeLogsPaginator(GetChangeLogsRequest getChangeLogsRequest) throws AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of changelogs from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable responses = client.getChangeLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable responses = client
     *             .getChangeLogsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsIterable responses = client.getChangeLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChangeLogsRequest.Builder} avoiding the need to
     * create one manually via {@link GetChangeLogsRequest#builder()}
     * </p>
     *
     * @param getChangeLogsRequest
     *        A {@link Consumer} that will call methods on {@link GetChangeLogsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChangeLogsIterable getChangeLogsPaginator(Consumer<GetChangeLogsRequest.Builder> getChangeLogsRequest)
            throws AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getChangeLogsPaginator(GetChangeLogsRequest.builder().applyMutation(getChangeLogsRequest).build());
    }

    /**
     * <p>
     * Returns a control from Audit Manager.
     * </p>
     *
     * @param getControlRequest
     * @return Result of the GetControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl" target="_top">AWS API
     *      Documentation</a>
     */
    default GetControlResponse getControl(GetControlRequest getControlRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a control from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetControlRequest.Builder} avoiding the need to
     * create one manually via {@link GetControlRequest#builder()}
     * </p>
     *
     * @param getControlRequest
     *        A {@link Consumer} that will call methods on {@link GetControlRequest.Builder} to create a request.
     * @return Result of the GetControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl" target="_top">AWS API
     *      Documentation</a>
     */
    default GetControlResponse getControl(Consumer<GetControlRequest.Builder> getControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getControl(GetControlRequest.builder().applyMutation(getControlRequest).build());
    }

    /**
     * <p>
     * Returns a list of delegations from an audit owner to a delegate.
     * </p>
     *
     * @param getDelegationsRequest
     * @return Result of the GetDelegations operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDelegationsResponse getDelegations(GetDelegationsRequest getDelegationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of delegations from an audit owner to a delegate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegationsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDelegationsRequest#builder()}
     * </p>
     *
     * @param getDelegationsRequest
     *        A {@link Consumer} that will call methods on {@link GetDelegationsRequest.Builder} to create a request.
     * @return Result of the GetDelegations operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDelegationsResponse getDelegations(Consumer<GetDelegationsRequest.Builder> getDelegationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getDelegations(GetDelegationsRequest.builder().applyMutation(getDelegationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of delegations from an audit owner to a delegate.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable responses = client.getDelegationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable responses = client
     *             .getDelegationsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable responses = client.getDelegationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation.</b>
     * </p>
     *
     * @param getDelegationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDelegationsIterable getDelegationsPaginator(GetDelegationsRequest getDelegationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of delegations from an audit owner to a delegate.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable responses = client.getDelegationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable responses = client
     *             .getDelegationsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsIterable responses = client.getDelegationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegationsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDelegationsRequest#builder()}
     * </p>
     *
     * @param getDelegationsRequest
     *        A {@link Consumer} that will call methods on {@link GetDelegationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDelegationsIterable getDelegationsPaginator(Consumer<GetDelegationsRequest.Builder> getDelegationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getDelegationsPaginator(GetDelegationsRequest.builder().applyMutation(getDelegationsRequest).build());
    }

    /**
     * <p>
     * Returns evidence from Audit Manager.
     * </p>
     *
     * @param getEvidenceRequest
     * @return Result of the GetEvidence operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEvidenceResponse getEvidence(GetEvidenceRequest getEvidenceRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns evidence from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetEvidenceRequest#builder()}
     * </p>
     *
     * @param getEvidenceRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceRequest.Builder} to create a request.
     * @return Result of the GetEvidence operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEvidenceResponse getEvidence(Consumer<GetEvidenceRequest.Builder> getEvidenceRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidence(GetEvidenceRequest.builder().applyMutation(getEvidenceRequest).build());
    }

    /**
     * <p>
     * Returns all evidence from a specified evidence folder in Audit Manager.
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     * @return Result of the GetEvidenceByEvidenceFolder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceByEvidenceFolderResponse getEvidenceByEvidenceFolder(
            GetEvidenceByEvidenceFolderRequest getEvidenceByEvidenceFolderRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all evidence from a specified evidence folder in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceByEvidenceFolderRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceByEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceByEvidenceFolderRequest.Builder} to create
     *        a request.
     * @return Result of the GetEvidenceByEvidenceFolder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceByEvidenceFolderResponse getEvidenceByEvidenceFolder(
            Consumer<GetEvidenceByEvidenceFolderRequest.Builder> getEvidenceByEvidenceFolderRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceByEvidenceFolder(GetEvidenceByEvidenceFolderRequest.builder()
                .applyMutation(getEvidenceByEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Returns all evidence from a specified evidence folder in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable responses = client.getEvidenceByEvidenceFolderPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable responses = client
     *             .getEvidenceByEvidenceFolderPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable responses = client.getEvidenceByEvidenceFolderPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceByEvidenceFolderIterable getEvidenceByEvidenceFolderPaginator(
            GetEvidenceByEvidenceFolderRequest getEvidenceByEvidenceFolderRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all evidence from a specified evidence folder in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable responses = client.getEvidenceByEvidenceFolderPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable responses = client
     *             .getEvidenceByEvidenceFolderPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderIterable responses = client.getEvidenceByEvidenceFolderPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceByEvidenceFolderRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceByEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceByEvidenceFolderRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceByEvidenceFolderIterable getEvidenceByEvidenceFolderPaginator(
            Consumer<GetEvidenceByEvidenceFolderRequest.Builder> getEvidenceByEvidenceFolderRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceByEvidenceFolderPaginator(GetEvidenceByEvidenceFolderRequest.builder()
                .applyMutation(getEvidenceByEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Returns an evidence folder from the specified assessment in Audit Manager.
     * </p>
     *
     * @param getEvidenceFolderRequest
     * @return Result of the GetEvidenceFolder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFolderResponse getEvidenceFolder(GetEvidenceFolderRequest getEvidenceFolderRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an evidence folder from the specified assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFolderRequest.Builder} avoiding the need
     * to create one manually via {@link GetEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param getEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceFolderRequest.Builder} to create a request.
     * @return Result of the GetEvidenceFolder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFolderResponse getEvidenceFolder(Consumer<GetEvidenceFolderRequest.Builder> getEvidenceFolderRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceFolder(GetEvidenceFolderRequest.builder().applyMutation(getEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Returns the evidence folders from a specified assessment in Audit Manager.
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     * @return Result of the GetEvidenceFoldersByAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentResponse getEvidenceFoldersByAssessment(
            GetEvidenceFoldersByAssessmentRequest getEvidenceFoldersByAssessmentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evidence folders from a specified assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFoldersByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceFoldersByAssessmentRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceFoldersByAssessmentRequest.Builder} to
     *        create a request.
     * @return Result of the GetEvidenceFoldersByAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentResponse getEvidenceFoldersByAssessment(
            Consumer<GetEvidenceFoldersByAssessmentRequest.Builder> getEvidenceFoldersByAssessmentRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentRequest).build());
    }

    /**
     * <p>
     * Returns the evidence folders from a specified assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable responses = client.getEvidenceFoldersByAssessmentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable responses = client
     *             .getEvidenceFoldersByAssessmentPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable responses = client.getEvidenceFoldersByAssessmentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentIterable getEvidenceFoldersByAssessmentPaginator(
            GetEvidenceFoldersByAssessmentRequest getEvidenceFoldersByAssessmentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evidence folders from a specified assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable responses = client.getEvidenceFoldersByAssessmentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable responses = client
     *             .getEvidenceFoldersByAssessmentPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentIterable responses = client.getEvidenceFoldersByAssessmentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFoldersByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceFoldersByAssessmentRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceFoldersByAssessmentRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentIterable getEvidenceFoldersByAssessmentPaginator(
            Consumer<GetEvidenceFoldersByAssessmentRequest.Builder> getEvidenceFoldersByAssessmentRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceFoldersByAssessmentPaginator(GetEvidenceFoldersByAssessmentRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentRequest).build());
    }

    /**
     * <p>
     * Returns a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     * @return Result of the GetEvidenceFoldersByAssessmentControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentControlResponse getEvidenceFoldersByAssessmentControl(
            GetEvidenceFoldersByAssessmentControlRequest getEvidenceFoldersByAssessmentControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEvidenceFoldersByAssessmentControlRequest.Builder} avoiding the need to create one manually via
     * {@link GetEvidenceFoldersByAssessmentControlRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceFoldersByAssessmentControlRequest.Builder}
     *        to create a request.
     * @return Result of the GetEvidenceFoldersByAssessmentControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentControlResponse getEvidenceFoldersByAssessmentControl(
            Consumer<GetEvidenceFoldersByAssessmentControlRequest.Builder> getEvidenceFoldersByAssessmentControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceFoldersByAssessmentControl(GetEvidenceFoldersByAssessmentControlRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentControlRequest).build());
    }

    /**
     * <p>
     * Returns a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable responses = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable responses = client
     *             .getEvidenceFoldersByAssessmentControlPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable responses = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentControlIterable getEvidenceFoldersByAssessmentControlPaginator(
            GetEvidenceFoldersByAssessmentControlRequest getEvidenceFoldersByAssessmentControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable responses = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable responses = client
     *             .getEvidenceFoldersByAssessmentControlPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlIterable responses = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEvidenceFoldersByAssessmentControlRequest.Builder} avoiding the need to create one manually via
     * {@link GetEvidenceFoldersByAssessmentControlRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     *        A {@link Consumer} that will call methods on {@link GetEvidenceFoldersByAssessmentControlRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentControlIterable getEvidenceFoldersByAssessmentControlPaginator(
            Consumer<GetEvidenceFoldersByAssessmentControlRequest.Builder> getEvidenceFoldersByAssessmentControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return getEvidenceFoldersByAssessmentControlPaginator(GetEvidenceFoldersByAssessmentControlRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentControlRequest).build());
    }

    /**
     * <p>
     * Gets the latest analytics data for all your current active assessments.
     * </p>
     *
     * @param getInsightsRequest
     * @return Result of the GetInsights operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsResponse getInsights(GetInsightsRequest getInsightsRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest analytics data for all your current active assessments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return Result of the GetInsights operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsResponse getInsights(Consumer<GetInsightsRequest.Builder> getInsightsRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return getInsights(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Gets the latest analytics data for a specific active assessment.
     * </p>
     *
     * @param getInsightsByAssessmentRequest
     * @return Result of the GetInsightsByAssessment operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetInsightsByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInsightsByAssessmentResponse getInsightsByAssessment(GetInsightsByAssessmentRequest getInsightsByAssessmentRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest analytics data for a specific active assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsByAssessmentRequest.Builder} avoiding
     * the need to create one manually via {@link GetInsightsByAssessmentRequest#builder()}
     * </p>
     *
     * @param getInsightsByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsByAssessmentRequest.Builder} to create a
     *        request.
     * @return Result of the GetInsightsByAssessment operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetInsightsByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInsightsByAssessmentResponse getInsightsByAssessment(
            Consumer<GetInsightsByAssessmentRequest.Builder> getInsightsByAssessmentRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getInsightsByAssessment(GetInsightsByAssessmentRequest.builder().applyMutation(getInsightsByAssessmentRequest)
                .build());
    }

    /**
     * <p>
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     * </p>
     *
     * @param getOrganizationAdminAccountRequest
     * @return Result of the GetOrganizationAdminAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationAdminAccountResponse getOrganizationAdminAccount(
            GetOrganizationAdminAccountRequest getOrganizationAdminAccountRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param getOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetOrganizationAdminAccountRequest.Builder} to create
     *        a request.
     * @return Result of the GetOrganizationAdminAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationAdminAccountResponse getOrganizationAdminAccount(
            Consumer<GetOrganizationAdminAccountRequest.Builder> getOrganizationAdminAccountRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getOrganizationAdminAccount(GetOrganizationAdminAccountRequest.builder()
                .applyMutation(getOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the Amazon Web Services that you can choose to include in your assessment. When you <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html">create an
     * assessment</a>, specify which of these services you want to include to narrow the assessment's <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html">scope</a>.
     * </p>
     *
     * @param getServicesInScopeRequest
     * @return Result of the GetServicesInScope operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetServicesInScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServicesInScopeResponse getServicesInScope(GetServicesInScopeRequest getServicesInScopeRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the Amazon Web Services that you can choose to include in your assessment. When you <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html">create an
     * assessment</a>, specify which of these services you want to include to narrow the assessment's <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html">scope</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServicesInScopeRequest.Builder} avoiding the
     * need to create one manually via {@link GetServicesInScopeRequest#builder()}
     * </p>
     *
     * @param getServicesInScopeRequest
     *        A {@link Consumer} that will call methods on {@link GetServicesInScopeRequest.Builder} to create a
     *        request.
     * @return Result of the GetServicesInScope operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetServicesInScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServicesInScopeResponse getServicesInScope(Consumer<GetServicesInScopeRequest.Builder> getServicesInScopeRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return getServicesInScope(GetServicesInScopeRequest.builder().applyMutation(getServicesInScopeRequest).build());
    }

    /**
     * <p>
     * Returns the settings for the specified Amazon Web Services account.
     * </p>
     *
     * @param getSettingsRequest
     * @return Result of the GetSettings operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSettingsResponse getSettings(GetSettingsRequest getSettingsRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the settings for the specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSettingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSettingsRequest#builder()}
     * </p>
     *
     * @param getSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetSettingsRequest.Builder} to create a request.
     * @return Result of the GetSettings operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.GetSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSettingsResponse getSettings(Consumer<GetSettingsRequest.Builder> getSettingsRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return getSettings(GetSettingsRequest.builder().applyMutation(getSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     * @return Result of the ListAssessmentControlInsightsByControlDomain operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentControlInsightsByControlDomainResponse listAssessmentControlInsightsByControlDomain(
            ListAssessmentControlInsightsByControlDomainRequest listAssessmentControlInsightsByControlDomainRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentControlInsightsByControlDomainRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssessmentControlInsightsByControlDomainRequest.Builder} to create a request.
     * @return Result of the ListAssessmentControlInsightsByControlDomain operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentControlInsightsByControlDomainResponse listAssessmentControlInsightsByControlDomain(
            Consumer<ListAssessmentControlInsightsByControlDomainRequest.Builder> listAssessmentControlInsightsByControlDomainRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listAssessmentControlInsightsByControlDomain(ListAssessmentControlInsightsByControlDomainRequest.builder()
                .applyMutation(listAssessmentControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable responses = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable responses = client
     *             .listAssessmentControlInsightsByControlDomainPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable responses = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentControlInsightsByControlDomainIterable listAssessmentControlInsightsByControlDomainPaginator(
            ListAssessmentControlInsightsByControlDomainRequest listAssessmentControlInsightsByControlDomainRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable responses = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable responses = client
     *             .listAssessmentControlInsightsByControlDomainPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainIterable responses = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentControlInsightsByControlDomainRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssessmentControlInsightsByControlDomainRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentControlInsightsByControlDomainIterable listAssessmentControlInsightsByControlDomainPaginator(
            Consumer<ListAssessmentControlInsightsByControlDomainRequest.Builder> listAssessmentControlInsightsByControlDomainRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listAssessmentControlInsightsByControlDomainPaginator(ListAssessmentControlInsightsByControlDomainRequest
                .builder().applyMutation(listAssessmentControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     * @return Result of the ListAssessmentFrameworkShareRequests operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworkShareRequestsResponse listAssessmentFrameworkShareRequests(
            ListAssessmentFrameworkShareRequestsRequest listAssessmentFrameworkShareRequestsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentFrameworkShareRequestsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentFrameworkShareRequestsRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentFrameworkShareRequestsRequest.Builder}
     *        to create a request.
     * @return Result of the ListAssessmentFrameworkShareRequests operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworkShareRequestsResponse listAssessmentFrameworkShareRequests(
            Consumer<ListAssessmentFrameworkShareRequestsRequest.Builder> listAssessmentFrameworkShareRequestsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listAssessmentFrameworkShareRequests(ListAssessmentFrameworkShareRequestsRequest.builder()
                .applyMutation(listAssessmentFrameworkShareRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable responses = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable responses = client
     *             .listAssessmentFrameworkShareRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable responses = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworkShareRequestsIterable listAssessmentFrameworkShareRequestsPaginator(
            ListAssessmentFrameworkShareRequestsRequest listAssessmentFrameworkShareRequestsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable responses = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable responses = client
     *             .listAssessmentFrameworkShareRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsIterable responses = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentFrameworkShareRequestsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentFrameworkShareRequestsRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentFrameworkShareRequestsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworkShareRequestsIterable listAssessmentFrameworkShareRequestsPaginator(
            Consumer<ListAssessmentFrameworkShareRequestsRequest.Builder> listAssessmentFrameworkShareRequestsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listAssessmentFrameworkShareRequestsPaginator(ListAssessmentFrameworkShareRequestsRequest.builder()
                .applyMutation(listAssessmentFrameworkShareRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     * @return Result of the ListAssessmentFrameworks operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworksResponse listAssessmentFrameworks(
            ListAssessmentFrameworksRequest listAssessmentFrameworksRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentFrameworksRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentFrameworksRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentFrameworksRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssessmentFrameworks operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworksResponse listAssessmentFrameworks(
            Consumer<ListAssessmentFrameworksRequest.Builder> listAssessmentFrameworksRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listAssessmentFrameworks(ListAssessmentFrameworksRequest.builder().applyMutation(listAssessmentFrameworksRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable responses = client.listAssessmentFrameworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable responses = client
     *             .listAssessmentFrameworksPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable responses = client.listAssessmentFrameworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworksIterable listAssessmentFrameworksPaginator(
            ListAssessmentFrameworksRequest listAssessmentFrameworksRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable responses = client.listAssessmentFrameworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable responses = client
     *             .listAssessmentFrameworksPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksIterable responses = client.listAssessmentFrameworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentFrameworksRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentFrameworksRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentFrameworksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworksIterable listAssessmentFrameworksPaginator(
            Consumer<ListAssessmentFrameworksRequest.Builder> listAssessmentFrameworksRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listAssessmentFrameworksPaginator(ListAssessmentFrameworksRequest.builder()
                .applyMutation(listAssessmentFrameworksRequest).build());
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     *
     * @param listAssessmentReportsRequest
     * @return Result of the ListAssessmentReports operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentReportsResponse listAssessmentReports(ListAssessmentReportsRequest listAssessmentReportsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentReportsRequest#builder()}
     * </p>
     *
     * @param listAssessmentReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentReportsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssessmentReports operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentReportsResponse listAssessmentReports(
            Consumer<ListAssessmentReportsRequest.Builder> listAssessmentReportsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listAssessmentReports(ListAssessmentReportsRequest.builder().applyMutation(listAssessmentReportsRequest).build());
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable responses = client.listAssessmentReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable responses = client
     *             .listAssessmentReportsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable responses = client.listAssessmentReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentReportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentReportsIterable listAssessmentReportsPaginator(ListAssessmentReportsRequest listAssessmentReportsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable responses = client.listAssessmentReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable responses = client
     *             .listAssessmentReportsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsIterable responses = client.listAssessmentReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentReportsRequest#builder()}
     * </p>
     *
     * @param listAssessmentReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentReportsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentReportsIterable listAssessmentReportsPaginator(
            Consumer<ListAssessmentReportsRequest.Builder> listAssessmentReportsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listAssessmentReportsPaginator(ListAssessmentReportsRequest.builder().applyMutation(listAssessmentReportsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     *
     * @param listAssessmentsRequest
     * @return Result of the ListAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentsResponse listAssessments(ListAssessmentsRequest listAssessmentsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssessmentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentsRequest.Builder} to create a request.
     * @return Result of the ListAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentsResponse listAssessments(Consumer<ListAssessmentsRequest.Builder> listAssessmentsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listAssessments(ListAssessmentsRequest.builder().applyMutation(listAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable responses = client.listAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable responses = client
     *             .listAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable responses = client.listAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentsIterable listAssessmentsPaginator(ListAssessmentsRequest listAssessmentsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable responses = client.listAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable responses = client
     *             .listAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsIterable responses = client.listAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssessmentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentsIterable listAssessmentsPaginator(Consumer<ListAssessmentsRequest.Builder> listAssessmentsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listAssessmentsPaginator(ListAssessmentsRequest.builder().applyMutation(listAssessmentsRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note>
     *
     * @param listControlDomainInsightsRequest
     * @return Result of the ListControlDomainInsights operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsResponse listControlDomainInsights(
            ListControlDomainInsightsRequest listControlDomainInsightsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlDomainInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListControlDomainInsightsRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsRequest
     *        A {@link Consumer} that will call methods on {@link ListControlDomainInsightsRequest.Builder} to create a
     *        request.
     * @return Result of the ListControlDomainInsights operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsResponse listControlDomainInsights(
            Consumer<ListControlDomainInsightsRequest.Builder> listControlDomainInsightsRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listControlDomainInsights(ListControlDomainInsightsRequest.builder()
                .applyMutation(listControlDomainInsightsRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable responses = client.listControlDomainInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable responses = client
     *             .listControlDomainInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable responses = client.listControlDomainInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlDomainInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsIterable listControlDomainInsightsPaginator(
            ListControlDomainInsightsRequest listControlDomainInsightsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable responses = client.listControlDomainInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable responses = client
     *             .listControlDomainInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsIterable responses = client.listControlDomainInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlDomainInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListControlDomainInsightsRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsRequest
     *        A {@link Consumer} that will call methods on {@link ListControlDomainInsightsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsIterable listControlDomainInsightsPaginator(
            Consumer<ListControlDomainInsightsRequest.Builder> listControlDomainInsightsRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listControlDomainInsightsPaginator(ListControlDomainInsightsRequest.builder()
                .applyMutation(listControlDomainInsightsRequest).build());
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     * @return Result of the ListControlDomainInsightsByAssessment operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsByAssessmentResponse listControlDomainInsightsByAssessment(
            ListControlDomainInsightsByAssessmentRequest listControlDomainInsightsByAssessmentRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListControlDomainInsightsByAssessmentRequest.Builder} avoiding the need to create one manually via
     * {@link ListControlDomainInsightsByAssessmentRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link ListControlDomainInsightsByAssessmentRequest.Builder}
     *        to create a request.
     * @return Result of the ListControlDomainInsightsByAssessment operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsByAssessmentResponse listControlDomainInsightsByAssessment(
            Consumer<ListControlDomainInsightsByAssessmentRequest.Builder> listControlDomainInsightsByAssessmentRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listControlDomainInsightsByAssessment(ListControlDomainInsightsByAssessmentRequest.builder()
                .applyMutation(listControlDomainInsightsByAssessmentRequest).build());
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable responses = client.listControlDomainInsightsByAssessmentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable responses = client
     *             .listControlDomainInsightsByAssessmentPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable responses = client.listControlDomainInsightsByAssessmentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsByAssessmentIterable listControlDomainInsightsByAssessmentPaginator(
            ListControlDomainInsightsByAssessmentRequest listControlDomainInsightsByAssessmentRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable responses = client.listControlDomainInsightsByAssessmentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable responses = client
     *             .listControlDomainInsightsByAssessmentPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentIterable responses = client.listControlDomainInsightsByAssessmentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListControlDomainInsightsByAssessmentRequest.Builder} avoiding the need to create one manually via
     * {@link ListControlDomainInsightsByAssessmentRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link ListControlDomainInsightsByAssessmentRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsByAssessmentIterable listControlDomainInsightsByAssessmentPaginator(
            Consumer<ListControlDomainInsightsByAssessmentRequest.Builder> listControlDomainInsightsByAssessmentRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listControlDomainInsightsByAssessmentPaginator(ListControlDomainInsightsByAssessmentRequest.builder()
                .applyMutation(listControlDomainInsightsByAssessmentRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note>
     *
     * @param listControlInsightsByControlDomainRequest
     * @return Result of the ListControlInsightsByControlDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlInsightsByControlDomainResponse listControlInsightsByControlDomain(
            ListControlInsightsByControlDomainRequest listControlInsightsByControlDomainRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlInsightsByControlDomainRequest.Builder}
     * avoiding the need to create one manually via {@link ListControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListControlInsightsByControlDomainRequest.Builder} to
     *        create a request.
     * @return Result of the ListControlInsightsByControlDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlInsightsByControlDomainResponse listControlInsightsByControlDomain(
            Consumer<ListControlInsightsByControlDomainRequest.Builder> listControlInsightsByControlDomainRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listControlInsightsByControlDomain(ListControlInsightsByControlDomainRequest.builder()
                .applyMutation(listControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable responses = client.listControlInsightsByControlDomainPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable responses = client
     *             .listControlInsightsByControlDomainPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable responses = client.listControlInsightsByControlDomainPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlInsightsByControlDomainRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlInsightsByControlDomainIterable listControlInsightsByControlDomainPaginator(
            ListControlInsightsByControlDomainRequest listControlInsightsByControlDomainRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable responses = client.listControlInsightsByControlDomainPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable responses = client
     *             .listControlInsightsByControlDomainPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainIterable responses = client.listControlInsightsByControlDomainPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlInsightsByControlDomainRequest.Builder}
     * avoiding the need to create one manually via {@link ListControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListControlInsightsByControlDomainRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlInsightsByControlDomainIterable listControlInsightsByControlDomainPaginator(
            Consumer<ListControlInsightsByControlDomainRequest.Builder> listControlInsightsByControlDomainRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return listControlInsightsByControlDomainPaginator(ListControlInsightsByControlDomainRequest.builder()
                .applyMutation(listControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     *
     * @param listControlsRequest
     * @return Result of the ListControls operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListControlsResponse listControls(ListControlsRequest listControlsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlsRequest.Builder} avoiding the need to
     * create one manually via {@link ListControlsRequest#builder()}
     * </p>
     *
     * @param listControlsRequest
     *        A {@link Consumer} that will call methods on {@link ListControlsRequest.Builder} to create a request.
     * @return Result of the ListControls operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListControlsResponse listControls(Consumer<ListControlsRequest.Builder> listControlsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listControls(ListControlsRequest.builder().applyMutation(listControlsRequest).build());
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable responses = client.listControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable responses = client
     *             .listControlsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable responses = client.listControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation.</b>
     * </p>
     *
     * @param listControlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListControlsIterable listControlsPaginator(ListControlsRequest listControlsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable responses = client.listControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable responses = client
     *             .listControlsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsIterable responses = client.listControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlsRequest.Builder} avoiding the need to
     * create one manually via {@link ListControlsRequest#builder()}
     * </p>
     *
     * @param listControlsRequest
     *        A {@link Consumer} that will call methods on {@link ListControlsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListControlsIterable listControlsPaginator(Consumer<ListControlsRequest.Builder> listControlsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listControlsPaginator(ListControlsRequest.builder().applyMutation(listControlsRequest).build());
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     * @return Result of the ListKeywordsForDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeywordsForDataSourceResponse listKeywordsForDataSource(
            ListKeywordsForDataSourceRequest listKeywordsForDataSourceRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeywordsForDataSourceRequest.Builder} avoiding
     * the need to create one manually via {@link ListKeywordsForDataSourceRequest#builder()}
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link ListKeywordsForDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListKeywordsForDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeywordsForDataSourceResponse listKeywordsForDataSource(
            Consumer<ListKeywordsForDataSourceRequest.Builder> listKeywordsForDataSourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listKeywordsForDataSource(ListKeywordsForDataSourceRequest.builder()
                .applyMutation(listKeywordsForDataSourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable responses = client.listKeywordsForDataSourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable responses = client
     *             .listKeywordsForDataSourcePaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable responses = client.listKeywordsForDataSourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeywordsForDataSourceIterable listKeywordsForDataSourcePaginator(
            ListKeywordsForDataSourceRequest listKeywordsForDataSourceRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable responses = client.listKeywordsForDataSourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable responses = client
     *             .listKeywordsForDataSourcePaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourceIterable responses = client.listKeywordsForDataSourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeywordsForDataSourceRequest.Builder} avoiding
     * the need to create one manually via {@link ListKeywordsForDataSourceRequest#builder()}
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link ListKeywordsForDataSourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeywordsForDataSourceIterable listKeywordsForDataSourcePaginator(
            Consumer<ListKeywordsForDataSourceRequest.Builder> listKeywordsForDataSourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listKeywordsForDataSourcePaginator(ListKeywordsForDataSourceRequest.builder()
                .applyMutation(listKeywordsForDataSourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return Result of the ListNotifications operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsResponse listNotifications(ListNotificationsRequest listNotificationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotificationsRequest.Builder} to create a request.
     * @return Result of the ListNotifications operation returned by the service.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsResponse listNotifications(Consumer<ListNotificationsRequest.Builder> listNotificationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable responses = client
     *             .listNotificationsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsIterable listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable responses = client
     *             .listNotificationsPaginator(request);
     *     for (software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotificationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsIterable listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource in Audit Manager.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AuditManagerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Enables Audit Manager for the specified Amazon Web Services account.
     * </p>
     *
     * @param registerAccountRequest
     * @return Result of the RegisterAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterAccountResponse registerAccount(RegisterAccountRequest registerAccountRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Audit Manager for the specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterAccountRequest#builder()}
     * </p>
     *
     * @param registerAccountRequest
     *        A {@link Consumer} that will call methods on {@link RegisterAccountRequest.Builder} to create a request.
     * @return Result of the RegisterAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterAccountResponse registerAccount(Consumer<RegisterAccountRequest.Builder> registerAccountRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, AuditManagerException {
        return registerAccount(RegisterAccountRequest.builder().applyMutation(registerAccountRequest).build());
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     * </p>
     *
     * @param registerOrganizationAdminAccountRequest
     * @return Result of the RegisterOrganizationAdminAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.RegisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterOrganizationAdminAccountResponse registerOrganizationAdminAccount(
            RegisterOrganizationAdminAccountRequest registerOrganizationAdminAccountRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param registerOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link RegisterOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the RegisterOrganizationAdminAccount operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.RegisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterOrganizationAdminAccountResponse registerOrganizationAdminAccount(
            Consumer<RegisterOrganizationAdminAccountRequest.Builder> registerOrganizationAdminAccountRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return registerOrganizationAdminAccount(RegisterOrganizationAdminAccountRequest.builder()
                .applyMutation(registerOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Creates a share request for a custom framework in Audit Manager.
     * </p>
     * <p>
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have
     * 120 days to accept or decline the request. If no action is taken, the share request expires.
     * </p>
     * <p>
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N.
     * Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West
     * (Oregon) Amazon Web Services Region.
     * </p>
     * <p>
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sender revokes the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient declines the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient encounters an error and doesn't successfully accept the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The share request expires before the recipient responds to the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a sender <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend"
     * >resends a share request</a>, the snapshot is replaced with an updated version that corresponds with the latest
     * version of the custom framework.
     * </p>
     * <p>
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under
     * the Amazon Web Services Region that was specified in the share request.
     * </p>
     * <important>
     * <p>
     * When you invoke the <code>StartAssessmentFrameworkShare</code> API, you are about to share a custom framework
     * with another Amazon Web Services account. You may not share a custom framework that is derived from a standard
     * framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you
     * have obtained permission to do so from the owner of the standard framework. To learn more about which standard
     * frameworks are eligible for sharing, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility"
     * >Framework sharing eligibility</a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * </important>
     *
     * @param startAssessmentFrameworkShareRequest
     * @return Result of the StartAssessmentFrameworkShare operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.StartAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/StartAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAssessmentFrameworkShareResponse startAssessmentFrameworkShare(
            StartAssessmentFrameworkShareRequest startAssessmentFrameworkShareRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a share request for a custom framework in Audit Manager.
     * </p>
     * <p>
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have
     * 120 days to accept or decline the request. If no action is taken, the share request expires.
     * </p>
     * <p>
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N.
     * Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West
     * (Oregon) Amazon Web Services Region.
     * </p>
     * <p>
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sender revokes the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient declines the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient encounters an error and doesn't successfully accept the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The share request expires before the recipient responds to the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a sender <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend"
     * >resends a share request</a>, the snapshot is replaced with an updated version that corresponds with the latest
     * version of the custom framework.
     * </p>
     * <p>
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under
     * the Amazon Web Services Region that was specified in the share request.
     * </p>
     * <important>
     * <p>
     * When you invoke the <code>StartAssessmentFrameworkShare</code> API, you are about to share a custom framework
     * with another Amazon Web Services account. You may not share a custom framework that is derived from a standard
     * framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you
     * have obtained permission to do so from the owner of the standard framework. To learn more about which standard
     * frameworks are eligible for sharing, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility"
     * >Framework sharing eligibility</a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAssessmentFrameworkShareRequest.Builder}
     * avoiding the need to create one manually via {@link StartAssessmentFrameworkShareRequest#builder()}
     * </p>
     *
     * @param startAssessmentFrameworkShareRequest
     *        A {@link Consumer} that will call methods on {@link StartAssessmentFrameworkShareRequest.Builder} to
     *        create a request.
     * @return Result of the StartAssessmentFrameworkShare operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.StartAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/StartAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAssessmentFrameworkShareResponse startAssessmentFrameworkShare(
            Consumer<StartAssessmentFrameworkShareRequest.Builder> startAssessmentFrameworkShareRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return startAssessmentFrameworkShare(StartAssessmentFrameworkShareRequest.builder()
                .applyMutation(startAssessmentFrameworkShareRequest).build());
    }

    /**
     * <p>
     * Tags the specified resource in Audit Manager.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags the specified resource in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AuditManagerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource in Audit Manager.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AuditManagerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Edits an Audit Manager assessment.
     * </p>
     *
     * @param updateAssessmentRequest
     * @return Result of the UpdateAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAssessmentResponse updateAssessment(UpdateAssessmentRequest updateAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Edits an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAssessmentRequest#builder()}
     * </p>
     *
     * @param updateAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentRequest.Builder} to create a request.
     * @return Result of the UpdateAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAssessmentResponse updateAssessment(Consumer<UpdateAssessmentRequest.Builder> updateAssessmentRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return updateAssessment(UpdateAssessmentRequest.builder().applyMutation(updateAssessmentRequest).build());
    }

    /**
     * <p>
     * Updates a control within an assessment in Audit Manager.
     * </p>
     *
     * @param updateAssessmentControlRequest
     * @return Result of the UpdateAssessmentControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentControlResponse updateAssessmentControl(UpdateAssessmentControlRequest updateAssessmentControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a control within an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentControlRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAssessmentControlRequest#builder()}
     * </p>
     *
     * @param updateAssessmentControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentControlRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAssessmentControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentControlResponse updateAssessmentControl(
            Consumer<UpdateAssessmentControlRequest.Builder> updateAssessmentControlRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return updateAssessmentControl(UpdateAssessmentControlRequest.builder().applyMutation(updateAssessmentControlRequest)
                .build());
    }

    /**
     * <p>
     * Updates the status of a control set in an Audit Manager assessment.
     * </p>
     *
     * @param updateAssessmentControlSetStatusRequest
     * @return Result of the UpdateAssessmentControlSetStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentControlSetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentControlSetStatusResponse updateAssessmentControlSetStatus(
            UpdateAssessmentControlSetStatusRequest updateAssessmentControlSetStatusRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a control set in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentControlSetStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAssessmentControlSetStatusRequest#builder()}
     * </p>
     *
     * @param updateAssessmentControlSetStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentControlSetStatusRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAssessmentControlSetStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentControlSetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentControlSetStatusResponse updateAssessmentControlSetStatus(
            Consumer<UpdateAssessmentControlSetStatusRequest.Builder> updateAssessmentControlSetStatusRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return updateAssessmentControlSetStatus(UpdateAssessmentControlSetStatusRequest.builder()
                .applyMutation(updateAssessmentControlSetStatusRequest).build());
    }

    /**
     * <p>
     * Updates a custom framework in Audit Manager.
     * </p>
     *
     * @param updateAssessmentFrameworkRequest
     * @return Result of the UpdateAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentFrameworkResponse updateAssessmentFramework(
            UpdateAssessmentFrameworkRequest updateAssessmentFrameworkRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentFrameworkRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param updateAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentFrameworkRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAssessmentFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentFrameworkResponse updateAssessmentFramework(
            Consumer<UpdateAssessmentFrameworkRequest.Builder> updateAssessmentFrameworkRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return updateAssessmentFramework(UpdateAssessmentFrameworkRequest.builder()
                .applyMutation(updateAssessmentFrameworkRequest).build());
    }

    /**
     * <p>
     * Updates a share request for a custom framework in Audit Manager.
     * </p>
     *
     * @param updateAssessmentFrameworkShareRequest
     * @return Result of the UpdateAssessmentFrameworkShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentFrameworkShareResponse updateAssessmentFrameworkShare(
            UpdateAssessmentFrameworkShareRequest updateAssessmentFrameworkShareRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a share request for a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentFrameworkShareRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAssessmentFrameworkShareRequest#builder()}
     * </p>
     *
     * @param updateAssessmentFrameworkShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentFrameworkShareRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAssessmentFrameworkShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentFrameworkShareResponse updateAssessmentFrameworkShare(
            Consumer<UpdateAssessmentFrameworkShareRequest.Builder> updateAssessmentFrameworkShareRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return updateAssessmentFrameworkShare(UpdateAssessmentFrameworkShareRequest.builder()
                .applyMutation(updateAssessmentFrameworkShareRequest).build());
    }

    /**
     * <p>
     * Updates the status of an assessment in Audit Manager.
     * </p>
     *
     * @param updateAssessmentStatusRequest
     * @return Result of the UpdateAssessmentStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentStatusResponse updateAssessmentStatus(UpdateAssessmentStatusRequest updateAssessmentStatusRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssessmentStatusRequest#builder()}
     * </p>
     *
     * @param updateAssessmentStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAssessmentStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached your account quota for this resource type. To perform the requested action, delete some
     *         existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateAssessmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentStatusResponse updateAssessmentStatus(
            Consumer<UpdateAssessmentStatusRequest.Builder> updateAssessmentStatusRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return updateAssessmentStatus(UpdateAssessmentStatusRequest.builder().applyMutation(updateAssessmentStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates a custom control in Audit Manager.
     * </p>
     *
     * @param updateControlRequest
     * @return Result of the UpdateControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateControlResponse updateControl(UpdateControlRequest updateControlRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a custom control in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateControlRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateControlRequest#builder()}
     * </p>
     *
     * @param updateControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateControlRequest.Builder} to create a request.
     * @return Result of the UpdateControl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateControlResponse updateControl(Consumer<UpdateControlRequest.Builder> updateControlRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return updateControl(UpdateControlRequest.builder().applyMutation(updateControlRequest).build());
    }

    /**
     * <p>
     * Updates Audit Manager settings for the current user account.
     * </p>
     *
     * @param updateSettingsRequest
     * @return Result of the UpdateSettings operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSettingsResponse updateSettings(UpdateSettingsRequest updateSettingsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates Audit Manager settings for the current user account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSettingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSettingsRequest#builder()}
     * </p>
     *
     * @param updateSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSettingsRequest.Builder} to create a request.
     * @return Result of the UpdateSettings operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSettingsResponse updateSettings(Consumer<UpdateSettingsRequest.Builder> updateSettingsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            AuditManagerException {
        return updateSettings(UpdateSettingsRequest.builder().applyMutation(updateSettingsRequest).build());
    }

    /**
     * <p>
     * Validates the integrity of an assessment report in Audit Manager.
     * </p>
     *
     * @param validateAssessmentReportIntegrityRequest
     * @return Result of the ValidateAssessmentReportIntegrity operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ValidateAssessmentReportIntegrity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateAssessmentReportIntegrityResponse validateAssessmentReportIntegrity(
            ValidateAssessmentReportIntegrityRequest validateAssessmentReportIntegrityRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AuditManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the integrity of an assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateAssessmentReportIntegrityRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateAssessmentReportIntegrityRequest#builder()}
     * </p>
     *
     * @param validateAssessmentReportIntegrityRequest
     *        A {@link Consumer} that will call methods on {@link ValidateAssessmentReportIntegrityRequest.Builder} to
     *        create a request.
     * @return Result of the ValidateAssessmentReportIntegrity operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         Your account isn't registered with Audit Manager. Check the delegated administrator setup on the Audit
     *         Manager settings page, and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource that's specified in the request can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AuditManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AuditManagerClient.ValidateAssessmentReportIntegrity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateAssessmentReportIntegrityResponse validateAssessmentReportIntegrity(
            Consumer<ValidateAssessmentReportIntegrityRequest.Builder> validateAssessmentReportIntegrityRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AuditManagerException {
        return validateAssessmentReportIntegrity(ValidateAssessmentReportIntegrityRequest.builder()
                .applyMutation(validateAssessmentReportIntegrityRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
