/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location where Audit Manager saves assessment reports for the given assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentReportsDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentReportsDestination.Builder, AssessmentReportsDestination> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationType").getter(getter(AssessmentReportsDestination::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(AssessmentReportsDestination::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD,
            DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationType;

    private final String destination;

    private AssessmentReportsDestination(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The destination type, such as Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link AssessmentReportDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The destination type, such as Amazon S3.
     * @see AssessmentReportDestinationType
     */
    public final AssessmentReportDestinationType destinationType() {
        return AssessmentReportDestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * The destination type, such as Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link AssessmentReportDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The destination type, such as Amazon S3.
     * @see AssessmentReportDestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * The destination of the assessment report.
     * </p>
     * 
     * @return The destination of the assessment report.
     */
    public final String destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentReportsDestination)) {
            return false;
        }
        AssessmentReportsDestination other = (AssessmentReportsDestination) obj;
        return Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentReportsDestination").add("DestinationType", destinationTypeAsString())
                .add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentReportsDestination, T> g) {
        return obj -> g.apply((AssessmentReportsDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentReportsDestination> {
        /**
         * <p>
         * The destination type, such as Amazon S3.
         * </p>
         * 
         * @param destinationType
         *        The destination type, such as Amazon S3.
         * @see AssessmentReportDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentReportDestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The destination type, such as Amazon S3.
         * </p>
         * 
         * @param destinationType
         *        The destination type, such as Amazon S3.
         * @see AssessmentReportDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentReportDestinationType
         */
        Builder destinationType(AssessmentReportDestinationType destinationType);

        /**
         * <p>
         * The destination of the assessment report.
         * </p>
         * 
         * @param destination
         *        The destination of the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);
    }

    static final class BuilderImpl implements Builder {
        private String destinationType;

        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentReportsDestination model) {
            destinationType(model.destinationType);
            destination(model.destination);
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(AssessmentReportDestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public AssessmentReportsDestination build() {
            return new AssessmentReportsDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
