/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlType {
    STANDARD("Standard"),
    CUSTOM("Custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlType> VALUE_MAP;
    private final String value;

    private ControlType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlType> knownValues() {
        EnumSet<ControlType> knownValues = EnumSet.allOf(ControlType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlType.class, ControlType::toString);
    }
}

