/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings object that specifies whether evidence finder is enabled. This object also describes the related event
 * data store, and the backfill status for populating the event data store with evidence data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvidenceFinderEnablement implements SdkPojo, Serializable,
        ToCopyableBuilder<EvidenceFinderEnablement.Builder, EvidenceFinderEnablement> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventDataStoreArn").getter(getter(EvidenceFinderEnablement::eventDataStoreArn))
            .setter(setter(Builder::eventDataStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDataStoreArn").build()).build();

    private static final SdkField<String> ENABLEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enablementStatus").getter(getter(EvidenceFinderEnablement::enablementStatusAsString))
            .setter(setter(Builder::enablementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablementStatus").build()).build();

    private static final SdkField<String> BACKFILL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backfillStatus").getter(getter(EvidenceFinderEnablement::backfillStatusAsString))
            .setter(setter(Builder::backfillStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backfillStatus").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(EvidenceFinderEnablement::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD,
            ENABLEMENT_STATUS_FIELD, BACKFILL_STATUS_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventDataStoreArn;

    private final String enablementStatus;

    private final String backfillStatus;

    private final String error;

    private EvidenceFinderEnablement(BuilderImpl builder) {
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.enablementStatus = builder.enablementStatus;
        this.backfillStatus = builder.backfillStatus;
        this.error = builder.error;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s used by evidence finder. The event
     * data store is the lake of evidence data that evidence finder runs queries against.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s used by evidence finder.
     *         The event data store is the lake of evidence data that evidence finder runs queries against.
     */
    public final String eventDataStoreArn() {
        return eventDataStoreArn;
    }

    /**
     * <p>
     * The current status of the evidence finder feature and the related event data store.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data store is
     * currently being created to support evidence finder queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> means that an event data store was successfully created and evidence finder is enabled. We
     * recommend that you wait 7 days until the event data store is backfilled with your past two years’ worth of
     * evidence data. You can use evidence finder in the meantime, but not all data might be available until the
     * backfill is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request is pending
     * the deletion of the event data store.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data store has been
     * deleted. You can't re-enable evidence finder after this point.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enablementStatus}
     * will return {@link EvidenceFinderEnablementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #enablementStatusAsString}.
     * </p>
     * 
     * @return The current status of the evidence finder feature and the related event data store. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data store
     *         is currently being created to support evidence finder queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> means that an event data store was successfully created and evidence finder is
     *         enabled. We recommend that you wait 7 days until the event data store is backfilled with your past two
     *         years’ worth of evidence data. You can use evidence finder in the meantime, but not all data might be
     *         available until the backfill is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request is
     *         pending the deletion of the event data store.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data store
     *         has been deleted. You can't re-enable evidence finder after this point.
     *         </p>
     *         </li>
     * @see EvidenceFinderEnablementStatus
     */
    public final EvidenceFinderEnablementStatus enablementStatus() {
        return EvidenceFinderEnablementStatus.fromValue(enablementStatus);
    }

    /**
     * <p>
     * The current status of the evidence finder feature and the related event data store.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data store is
     * currently being created to support evidence finder queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> means that an event data store was successfully created and evidence finder is enabled. We
     * recommend that you wait 7 days until the event data store is backfilled with your past two years’ worth of
     * evidence data. You can use evidence finder in the meantime, but not all data might be available until the
     * backfill is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request is pending
     * the deletion of the event data store.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data store has been
     * deleted. You can't re-enable evidence finder after this point.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enablementStatus}
     * will return {@link EvidenceFinderEnablementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #enablementStatusAsString}.
     * </p>
     * 
     * @return The current status of the evidence finder feature and the related event data store. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data store
     *         is currently being created to support evidence finder queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> means that an event data store was successfully created and evidence finder is
     *         enabled. We recommend that you wait 7 days until the event data store is backfilled with your past two
     *         years’ worth of evidence data. You can use evidence finder in the meantime, but not all data might be
     *         available until the backfill is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request is
     *         pending the deletion of the event data store.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data store
     *         has been deleted. You can't re-enable evidence finder after this point.
     *         </p>
     *         </li>
     * @see EvidenceFinderEnablementStatus
     */
    public final String enablementStatusAsString() {
        return enablementStatus;
    }

    /**
     * <p>
     * The current status of the evidence data backfill process.
     * </p>
     * <p>
     * The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event data
     * store with your past two years’ worth of evidence data so that your evidence can be queried.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to complete,
     * depending on the amount of evidence data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now queryable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backfillStatus}
     * will return {@link EvidenceFinderBackfillStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #backfillStatusAsString}.
     * </p>
     * 
     * @return The current status of the evidence data backfill process. </p>
     *         <p>
     *         The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event
     *         data store with your past two years’ worth of evidence data so that your evidence can be queried.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to complete,
     *         depending on the amount of evidence data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now queryable.
     *         </p>
     *         </li>
     * @see EvidenceFinderBackfillStatus
     */
    public final EvidenceFinderBackfillStatus backfillStatus() {
        return EvidenceFinderBackfillStatus.fromValue(backfillStatus);
    }

    /**
     * <p>
     * The current status of the evidence data backfill process.
     * </p>
     * <p>
     * The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event data
     * store with your past two years’ worth of evidence data so that your evidence can be queried.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to complete,
     * depending on the amount of evidence data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now queryable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backfillStatus}
     * will return {@link EvidenceFinderBackfillStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #backfillStatusAsString}.
     * </p>
     * 
     * @return The current status of the evidence data backfill process. </p>
     *         <p>
     *         The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event
     *         data store with your past two years’ worth of evidence data so that your evidence can be queried.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to complete,
     *         depending on the amount of evidence data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now queryable.
     *         </p>
     *         </li>
     * @see EvidenceFinderBackfillStatus
     */
    public final String backfillStatusAsString() {
        return backfillStatus;
    }

    /**
     * <p>
     * Represents any errors that occurred when enabling or disabling evidence finder.
     * </p>
     * 
     * @return Represents any errors that occurred when enabling or disabling evidence finder.
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(enablementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backfillStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvidenceFinderEnablement)) {
            return false;
        }
        EvidenceFinderEnablement other = (EvidenceFinderEnablement) obj;
        return Objects.equals(eventDataStoreArn(), other.eventDataStoreArn())
                && Objects.equals(enablementStatusAsString(), other.enablementStatusAsString())
                && Objects.equals(backfillStatusAsString(), other.backfillStatusAsString())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvidenceFinderEnablement").add("EventDataStoreArn", eventDataStoreArn())
                .add("EnablementStatus", enablementStatusAsString()).add("BackfillStatus", backfillStatusAsString())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventDataStoreArn":
            return Optional.ofNullable(clazz.cast(eventDataStoreArn()));
        case "enablementStatus":
            return Optional.ofNullable(clazz.cast(enablementStatusAsString()));
        case "backfillStatus":
            return Optional.ofNullable(clazz.cast(backfillStatusAsString()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvidenceFinderEnablement, T> g) {
        return obj -> g.apply((EvidenceFinderEnablement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvidenceFinderEnablement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s used by evidence finder. The
         * event data store is the lake of evidence data that evidence finder runs queries against.
         * </p>
         * 
         * @param eventDataStoreArn
         *        The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s used by evidence finder.
         *        The event data store is the lake of evidence data that evidence finder runs queries against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreArn(String eventDataStoreArn);

        /**
         * <p>
         * The current status of the evidence finder feature and the related event data store.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data store is
         * currently being created to support evidence finder queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> means that an event data store was successfully created and evidence finder is enabled.
         * We recommend that you wait 7 days until the event data store is backfilled with your past two years’ worth of
         * evidence data. You can use evidence finder in the meantime, but not all data might be available until the
         * backfill is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request is
         * pending the deletion of the event data store.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data store has
         * been deleted. You can't re-enable evidence finder after this point.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enablementStatus
         *        The current status of the evidence finder feature and the related event data store. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data
         *        store is currently being created to support evidence finder queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> means that an event data store was successfully created and evidence finder is
         *        enabled. We recommend that you wait 7 days until the event data store is backfilled with your past two
         *        years’ worth of evidence data. You can use evidence finder in the meantime, but not all data might be
         *        available until the backfill is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request
         *        is pending the deletion of the event data store.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data
         *        store has been deleted. You can't re-enable evidence finder after this point.
         *        </p>
         *        </li>
         * @see EvidenceFinderEnablementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvidenceFinderEnablementStatus
         */
        Builder enablementStatus(String enablementStatus);

        /**
         * <p>
         * The current status of the evidence finder feature and the related event data store.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data store is
         * currently being created to support evidence finder queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> means that an event data store was successfully created and evidence finder is enabled.
         * We recommend that you wait 7 days until the event data store is backfilled with your past two years’ worth of
         * evidence data. You can use evidence finder in the meantime, but not all data might be available until the
         * backfill is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request is
         * pending the deletion of the event data store.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data store has
         * been deleted. You can't re-enable evidence finder after this point.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enablementStatus
         *        The current status of the evidence finder feature and the related event data store. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLE_IN_PROGRESS</code> means that you requested to enable evidence finder. An event data
         *        store is currently being created to support evidence finder queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> means that an event data store was successfully created and evidence finder is
         *        enabled. We recommend that you wait 7 days until the event data store is backfilled with your past two
         *        years’ worth of evidence data. You can use evidence finder in the meantime, but not all data might be
         *        available until the backfill is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE_IN_PROGRESS</code> means that you requested to disable evidence finder, and your request
         *        is pending the deletion of the event data store.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> means that you have permanently disabled evidence finder and the event data
         *        store has been deleted. You can't re-enable evidence finder after this point.
         *        </p>
         *        </li>
         * @see EvidenceFinderEnablementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvidenceFinderEnablementStatus
         */
        Builder enablementStatus(EvidenceFinderEnablementStatus enablementStatus);

        /**
         * <p>
         * The current status of the evidence data backfill process.
         * </p>
         * <p>
         * The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event data
         * store with your past two years’ worth of evidence data so that your evidence can be queried.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to complete,
         * depending on the amount of evidence data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now queryable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backfillStatus
         *        The current status of the evidence data backfill process. </p>
         *        <p>
         *        The backfill starts after you enable evidence finder. During this task, Audit Manager populates an
         *        event data store with your past two years’ worth of evidence data so that your evidence can be
         *        queried.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to
         *        complete, depending on the amount of evidence data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now
         *        queryable.
         *        </p>
         *        </li>
         * @see EvidenceFinderBackfillStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvidenceFinderBackfillStatus
         */
        Builder backfillStatus(String backfillStatus);

        /**
         * <p>
         * The current status of the evidence data backfill process.
         * </p>
         * <p>
         * The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event data
         * store with your past two years’ worth of evidence data so that your evidence can be queried.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to complete,
         * depending on the amount of evidence data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now queryable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backfillStatus
         *        The current status of the evidence data backfill process. </p>
         *        <p>
         *        The backfill starts after you enable evidence finder. During this task, Audit Manager populates an
         *        event data store with your past two years’ worth of evidence data so that your evidence can be
         *        queried.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> means that the backfill hasn’t started yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> means that the backfill is in progress. This can take up to 7 days to
         *        complete, depending on the amount of evidence data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> means that the backfill is complete. All of your past evidence is now
         *        queryable.
         *        </p>
         *        </li>
         * @see EvidenceFinderBackfillStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvidenceFinderBackfillStatus
         */
        Builder backfillStatus(EvidenceFinderBackfillStatus backfillStatus);

        /**
         * <p>
         * Represents any errors that occurred when enabling or disabling evidence finder.
         * </p>
         * 
         * @param error
         *        Represents any errors that occurred when enabling or disabling evidence finder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl implements Builder {
        private String eventDataStoreArn;

        private String enablementStatus;

        private String backfillStatus;

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(EvidenceFinderEnablement model) {
            eventDataStoreArn(model.eventDataStoreArn);
            enablementStatus(model.enablementStatus);
            backfillStatus(model.backfillStatus);
            error(model.error);
        }

        public final String getEventDataStoreArn() {
            return eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getEnablementStatus() {
            return enablementStatus;
        }

        public final void setEnablementStatus(String enablementStatus) {
            this.enablementStatus = enablementStatus;
        }

        @Override
        public final Builder enablementStatus(String enablementStatus) {
            this.enablementStatus = enablementStatus;
            return this;
        }

        @Override
        public final Builder enablementStatus(EvidenceFinderEnablementStatus enablementStatus) {
            this.enablementStatus(enablementStatus == null ? null : enablementStatus.toString());
            return this;
        }

        public final String getBackfillStatus() {
            return backfillStatus;
        }

        public final void setBackfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
        }

        @Override
        public final Builder backfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
            return this;
        }

        @Override
        public final Builder backfillStatus(EvidenceFinderBackfillStatus backfillStatus) {
            this.backfillStatus(backfillStatus == null ? null : backfillStatus.toString());
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public EvidenceFinderEnablement build() {
            return new EvidenceFinderEnablement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
