/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.RoleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDelegationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateDelegationRequest> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(CreateDelegationRequest.getter(CreateDelegationRequest::comment)).setter(CreateDelegationRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(CreateDelegationRequest.getter(CreateDelegationRequest::controlSetId)).setter(CreateDelegationRequest.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateDelegationRequest.getter(CreateDelegationRequest::roleArn)).setter(CreateDelegationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ROLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleType").getter(CreateDelegationRequest.getter(CreateDelegationRequest::roleTypeAsString)).setter(CreateDelegationRequest.setter(Builder::roleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CONTROL_SET_ID_FIELD, ROLE_ARN_FIELD, ROLE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final String controlSetId;
    private final String roleArn;
    private final String roleType;

    private CreateDelegationRequest(BuilderImpl builder) {
        this.comment = builder.comment;
        this.controlSetId = builder.controlSetId;
        this.roleArn = builder.roleArn;
        this.roleType = builder.roleType;
    }

    public final String comment() {
        return this.comment;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final RoleType roleType() {
        return RoleType.fromValue(this.roleType);
    }

    public final String roleTypeAsString() {
        return this.roleType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDelegationRequest)) {
            return false;
        }
        CreateDelegationRequest other = (CreateDelegationRequest)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.roleTypeAsString(), other.roleTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDelegationRequest").add("Comment", (Object)this.comment()).add("ControlSetId", (Object)this.controlSetId()).add("RoleArn", (Object)this.roleArn()).add("RoleType", (Object)this.roleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "roleType": {
                return Optional.ofNullable(clazz.cast(this.roleTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDelegationRequest, T> g) {
        return obj -> g.apply((CreateDelegationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String controlSetId;
        private String roleArn;
        private String roleType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDelegationRequest model) {
            this.comment(model.comment);
            this.controlSetId(model.controlSetId);
            this.roleArn(model.roleArn);
            this.roleType(model.roleType);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRoleType() {
            return this.roleType;
        }

        public final void setRoleType(String roleType) {
            this.roleType = roleType;
        }

        @Override
        public final Builder roleType(String roleType) {
            this.roleType = roleType;
            return this;
        }

        @Override
        public final Builder roleType(RoleType roleType) {
            this.roleType(roleType == null ? null : roleType.toString());
            return this;
        }

        public CreateDelegationRequest build() {
            return new CreateDelegationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateDelegationRequest> {
        public Builder comment(String var1);

        public Builder controlSetId(String var1);

        public Builder roleArn(String var1);

        public Builder roleType(String var1);

        public Builder roleType(RoleType var1);
    }
}

