/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The record of a change within Audit Manager. For example, this could be the status change of an assessment or the
 * delegation of a control set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeLog implements SdkPojo, Serializable, ToCopyableBuilder<ChangeLog.Builder, ChangeLog> {
    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectType").getter(getter(ChangeLog::objectTypeAsString)).setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectType").build()).build();

    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectName").getter(getter(ChangeLog::objectName)).setter(setter(Builder::objectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectName").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ChangeLog::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ChangeLog::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(ChangeLog::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_FIELD,
            OBJECT_NAME_FIELD, ACTION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String objectType;

    private final String objectName;

    private final String action;

    private final Instant createdAt;

    private final String createdBy;

    private ChangeLog(BuilderImpl builder) {
        this.objectType = builder.objectType;
        this.objectName = builder.objectName;
        this.action = builder.action;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The object that was changed, such as an assessment, control, or control set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return The object that was changed, such as an assessment, control, or control set.
     * @see ObjectTypeEnum
     */
    public final ObjectTypeEnum objectType() {
        return ObjectTypeEnum.fromValue(objectType);
    }

    /**
     * <p>
     * The object that was changed, such as an assessment, control, or control set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return The object that was changed, such as an assessment, control, or control set.
     * @see ObjectTypeEnum
     */
    public final String objectTypeAsString() {
        return objectType;
    }

    /**
     * <p>
     * The name of the object that changed. This could be the name of an assessment, control, or control set.
     * </p>
     * 
     * @return The name of the object that changed. This could be the name of an assessment, control, or control set.
     */
    public final String objectName() {
        return objectName;
    }

    /**
     * <p>
     * The action that was performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ActionEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that was performed.
     * @see ActionEnum
     */
    public final ActionEnum action() {
        return ActionEnum.fromValue(action);
    }

    /**
     * <p>
     * The action that was performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ActionEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that was performed.
     * @see ActionEnum
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The time when the action was performed and the changelog record was created.
     * </p>
     * 
     * @return The time when the action was performed and the changelog record was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or role that performed the action.
     * </p>
     * 
     * @return The user or role that performed the action.
     */
    public final String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(objectName());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeLog)) {
            return false;
        }
        ChangeLog other = (ChangeLog) obj;
        return Objects.equals(objectTypeAsString(), other.objectTypeAsString())
                && Objects.equals(objectName(), other.objectName()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeLog").add("ObjectType", objectTypeAsString()).add("ObjectName", objectName())
                .add("Action", actionAsString()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "objectType":
            return Optional.ofNullable(clazz.cast(objectTypeAsString()));
        case "objectName":
            return Optional.ofNullable(clazz.cast(objectName()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeLog, T> g) {
        return obj -> g.apply((ChangeLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeLog> {
        /**
         * <p>
         * The object that was changed, such as an assessment, control, or control set.
         * </p>
         * 
         * @param objectType
         *        The object that was changed, such as an assessment, control, or control set.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder objectType(String objectType);

        /**
         * <p>
         * The object that was changed, such as an assessment, control, or control set.
         * </p>
         * 
         * @param objectType
         *        The object that was changed, such as an assessment, control, or control set.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder objectType(ObjectTypeEnum objectType);

        /**
         * <p>
         * The name of the object that changed. This could be the name of an assessment, control, or control set.
         * </p>
         * 
         * @param objectName
         *        The name of the object that changed. This could be the name of an assessment, control, or control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectName(String objectName);

        /**
         * <p>
         * The action that was performed.
         * </p>
         * 
         * @param action
         *        The action that was performed.
         * @see ActionEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionEnum
         */
        Builder action(String action);

        /**
         * <p>
         * The action that was performed.
         * </p>
         * 
         * @param action
         *        The action that was performed.
         * @see ActionEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionEnum
         */
        Builder action(ActionEnum action);

        /**
         * <p>
         * The time when the action was performed and the changelog record was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the action was performed and the changelog record was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or role that performed the action.
         * </p>
         * 
         * @param createdBy
         *        The user or role that performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl implements Builder {
        private String objectType;

        private String objectName;

        private String action;

        private Instant createdAt;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeLog model) {
            objectType(model.objectType);
            objectName(model.objectName);
            action(model.action);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
        }

        public final String getObjectType() {
            return objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectTypeEnum objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final String getObjectName() {
            return objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionEnum action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public ChangeLog build() {
            return new ChangeLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
