/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateAssessmentRequest.Builder, UpdateAssessmentRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(UpdateAssessmentRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(UpdateAssessmentRequest::assessmentName))
            .setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> ASSESSMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentDescription").getter(getter(UpdateAssessmentRequest::assessmentDescription))
            .setter(setter(Builder::assessmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentDescription").build())
            .build();

    private static final SdkField<Scope> SCOPE_FIELD = SdkField.<Scope> builder(MarshallingType.SDK_POJO).memberName("scope")
            .getter(getter(UpdateAssessmentRequest::scope)).setter(setter(Builder::scope)).constructor(Scope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<AssessmentReportsDestination> ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField
            .<AssessmentReportsDestination> builder(MarshallingType.SDK_POJO)
            .memberName("assessmentReportsDestination")
            .getter(getter(UpdateAssessmentRequest::assessmentReportsDestination))
            .setter(setter(Builder::assessmentReportsDestination))
            .constructor(AssessmentReportsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportsDestination")
                    .build()).build();

    private static final SdkField<List<Role>> ROLES_FIELD = SdkField
            .<List<Role>> builder(MarshallingType.LIST)
            .memberName("roles")
            .getter(getter(UpdateAssessmentRequest::roles))
            .setter(setter(Builder::roles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Role> builder(MarshallingType.SDK_POJO)
                                            .constructor(Role::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD,
            ASSESSMENT_NAME_FIELD, ASSESSMENT_DESCRIPTION_FIELD, SCOPE_FIELD, ASSESSMENT_REPORTS_DESTINATION_FIELD, ROLES_FIELD));

    private final String assessmentId;

    private final String assessmentName;

    private final String assessmentDescription;

    private final Scope scope;

    private final AssessmentReportsDestination assessmentReportsDestination;

    private final List<Role> roles;

    private UpdateAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.assessmentName = builder.assessmentName;
        this.assessmentDescription = builder.assessmentDescription;
        this.scope = builder.scope;
        this.assessmentReportsDestination = builder.assessmentReportsDestination;
        this.roles = builder.roles;
    }

    /**
     * <p>
     * The unique identifier for the assessment.
     * </p>
     * 
     * @return The unique identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The name of the assessment to be updated.
     * </p>
     * 
     * @return The name of the assessment to be updated.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The description of the assessment.
     * </p>
     * 
     * @return The description of the assessment.
     */
    public final String assessmentDescription() {
        return assessmentDescription;
    }

    /**
     * <p>
     * The scope of the assessment.
     * </p>
     * 
     * @return The scope of the assessment.
     */
    public final Scope scope() {
        return scope;
    }

    /**
     * <p>
     * The assessment report storage destination for the assessment that's being updated.
     * </p>
     * 
     * @return The assessment report storage destination for the assessment that's being updated.
     */
    public final AssessmentReportsDestination assessmentReportsDestination() {
        return assessmentReportsDestination;
    }

    /**
     * For responses, this returns true if the service returned a value for the Roles property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoles() {
        return roles != null && !(roles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of roles for the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return The list of roles for the assessment.
     */
    public final List<Role> roles() {
        return roles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoles() ? roles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentRequest)) {
            return false;
        }
        UpdateAssessmentRequest other = (UpdateAssessmentRequest) obj;
        return Objects.equals(assessmentId(), other.assessmentId()) && Objects.equals(assessmentName(), other.assessmentName())
                && Objects.equals(assessmentDescription(), other.assessmentDescription())
                && Objects.equals(scope(), other.scope())
                && Objects.equals(assessmentReportsDestination(), other.assessmentReportsDestination())
                && hasRoles() == other.hasRoles() && Objects.equals(roles(), other.roles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentRequest").add("AssessmentId", assessmentId())
                .add("AssessmentName", assessmentName()).add("AssessmentDescription", assessmentDescription())
                .add("Scope", scope()).add("AssessmentReportsDestination", assessmentReportsDestination())
                .add("Roles", hasRoles() ? roles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "assessmentDescription":
            return Optional.ofNullable(clazz.cast(assessmentDescription()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "assessmentReportsDestination":
            return Optional.ofNullable(clazz.cast(assessmentReportsDestination()));
        case "roles":
            return Optional.ofNullable(clazz.cast(roles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssessmentRequest> {
        /**
         * <p>
         * The unique identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The unique identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The name of the assessment to be updated.
         * </p>
         * 
         * @param assessmentName
         *        The name of the assessment to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The description of the assessment.
         * </p>
         * 
         * @param assessmentDescription
         *        The description of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentDescription(String assessmentDescription);

        /**
         * <p>
         * The scope of the assessment.
         * </p>
         * 
         * @param scope
         *        The scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The scope of the assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Scope.Builder} avoiding the need to
         * create one manually via {@link Scope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The assessment report storage destination for the assessment that's being updated.
         * </p>
         * 
         * @param assessmentReportsDestination
         *        The assessment report storage destination for the assessment that's being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination);

        /**
         * <p>
         * The assessment report storage destination for the assessment that's being updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssessmentReportsDestination.Builder}
         * avoiding the need to create one manually via {@link AssessmentReportsDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssessmentReportsDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentReportsDestination(AssessmentReportsDestination)}.
         * 
         * @param assessmentReportsDestination
         *        a consumer that will call methods on {@link AssessmentReportsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentReportsDestination(AssessmentReportsDestination)
         */
        default Builder assessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> assessmentReportsDestination) {
            return assessmentReportsDestination(AssessmentReportsDestination.builder()
                    .applyMutation(assessmentReportsDestination).build());
        }

        /**
         * <p>
         * The list of roles for the assessment.
         * </p>
         * 
         * @param roles
         *        The list of roles for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Collection<Role> roles);

        /**
         * <p>
         * The list of roles for the assessment.
         * </p>
         * 
         * @param roles
         *        The list of roles for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Role... roles);

        /**
         * <p>
         * The list of roles for the assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.Role.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.auditmanager.model.Role#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.Role.Builder#build()} is called immediately and its
         * result is passed to {@link #roles(List<Role>)}.
         * 
         * @param roles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.Role.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roles(java.util.Collection<Role>)
         */
        Builder roles(Consumer<Role.Builder>... roles);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String assessmentId;

        private String assessmentName;

        private String assessmentDescription;

        private Scope scope;

        private AssessmentReportsDestination assessmentReportsDestination;

        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentRequest model) {
            super(model);
            assessmentId(model.assessmentId);
            assessmentName(model.assessmentName);
            assessmentDescription(model.assessmentDescription);
            scope(model.scope);
            assessmentReportsDestination(model.assessmentReportsDestination);
            roles(model.roles);
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentDescription() {
            return assessmentDescription;
        }

        public final void setAssessmentDescription(String assessmentDescription) {
            this.assessmentDescription = assessmentDescription;
        }

        @Override
        public final Builder assessmentDescription(String assessmentDescription) {
            this.assessmentDescription = assessmentDescription;
            return this;
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final AssessmentReportsDestination.Builder getAssessmentReportsDestination() {
            return assessmentReportsDestination != null ? assessmentReportsDestination.toBuilder() : null;
        }

        public final void setAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination != null ? assessmentReportsDestination.build()
                    : null;
        }

        @Override
        public final Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        public final List<Role.Builder> getRoles() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = RolesCopier.copyFromBuilder(roles);
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role... roles) {
            roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder>... roles) {
            roles(Stream.of(roles).map(c -> Role.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentRequest build() {
            return new UpdateAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
