/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClientBuilder;
import software.amazon.awssdk.services.auditmanager.AuditManagerServiceClientConfiguration;
import software.amazon.awssdk.services.auditmanager.DefaultAuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.DefaultAuditManagerBaseClientBuilder;
import software.amazon.awssdk.services.auditmanager.endpoints.AuditManagerEndpointProvider;

@SdkInternalApi
final class DefaultAuditManagerAsyncClientBuilder
extends DefaultAuditManagerBaseClientBuilder<AuditManagerAsyncClientBuilder, AuditManagerAsyncClient>
implements AuditManagerAsyncClientBuilder {
    DefaultAuditManagerAsyncClientBuilder() {
    }

    @Override
    public DefaultAuditManagerAsyncClientBuilder endpointProvider(AuditManagerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AuditManagerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAuditManagerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AuditManagerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAuditManagerAsyncClient client = new DefaultAuditManagerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AuditManagerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AuditManagerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

