/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AWSAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AWSAccount> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AWSAccount.getter(AWSAccount::id)).setter(AWSAccount.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailAddress").getter(AWSAccount.getter(AWSAccount::emailAddress)).setter(AWSAccount.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AWSAccount.getter(AWSAccount::name)).setter(AWSAccount.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EMAIL_ADDRESS_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String emailAddress;
    private final String name;

    private AWSAccount(BuilderImpl builder) {
        this.id = builder.id;
        this.emailAddress = builder.emailAddress;
        this.name = builder.name;
    }

    public final String id() {
        return this.id;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSAccount)) {
            return false;
        }
        AWSAccount other = (AWSAccount)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"AWSAccount").add("Id", (Object)this.id()).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSAccount, T> g) {
        return obj -> g.apply((AWSAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String emailAddress;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSAccount model) {
            this.id(model.id);
            this.emailAddress(model.emailAddress);
            this.name(model.name);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public AWSAccount build() {
            return new AWSAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AWSAccount> {
        public Builder id(String var1);

        public Builder emailAddress(String var1);

        public Builder name(String var1);
    }
}

