/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse;

public class GetEvidenceByEvidenceFolderPublisher
implements SdkPublisher<GetEvidenceByEvidenceFolderResponse> {
    private final AuditManagerAsyncClient client;
    private final GetEvidenceByEvidenceFolderRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEvidenceByEvidenceFolderPublisher(AuditManagerAsyncClient client, GetEvidenceByEvidenceFolderRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEvidenceByEvidenceFolderPublisher(AuditManagerAsyncClient client, GetEvidenceByEvidenceFolderRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEvidenceByEvidenceFolderResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEvidenceByEvidenceFolderResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEvidenceByEvidenceFolderResponseFetcher
    implements AsyncPageFetcher<GetEvidenceByEvidenceFolderResponse> {
        private GetEvidenceByEvidenceFolderResponseFetcher() {
        }

        public boolean hasNextPage(GetEvidenceByEvidenceFolderResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEvidenceByEvidenceFolderResponse> nextPage(GetEvidenceByEvidenceFolderResponse previousPage) {
            if (previousPage == null) {
                return GetEvidenceByEvidenceFolderPublisher.this.client.getEvidenceByEvidenceFolder(GetEvidenceByEvidenceFolderPublisher.this.firstRequest);
            }
            return GetEvidenceByEvidenceFolderPublisher.this.client.getEvidenceByEvidenceFolder((GetEvidenceByEvidenceFolderRequest)((Object)GetEvidenceByEvidenceFolderPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

