/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the latest analytics data for a specific control domain.
 * </p>
 * <p>
 * Control domain insights are grouped by control domain, and ranked by the highest total count of non-compliant
 * evidence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlDomainInsights implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlDomainInsights.Builder, ControlDomainInsights> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ControlDomainInsights::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ControlDomainInsights::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> CONTROLS_COUNT_BY_NONCOMPLIANT_EVIDENCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("controlsCountByNoncompliantEvidence")
            .getter(getter(ControlDomainInsights::controlsCountByNoncompliantEvidence))
            .setter(setter(Builder::controlsCountByNoncompliantEvidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("controlsCountByNoncompliantEvidence").build()).build();

    private static final SdkField<Integer> TOTAL_CONTROLS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalControlsCount").getter(getter(ControlDomainInsights::totalControlsCount))
            .setter(setter(Builder::totalControlsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalControlsCount").build())
            .build();

    private static final SdkField<EvidenceInsights> EVIDENCE_INSIGHTS_FIELD = SdkField
            .<EvidenceInsights> builder(MarshallingType.SDK_POJO).memberName("evidenceInsights")
            .getter(getter(ControlDomainInsights::evidenceInsights)).setter(setter(Builder::evidenceInsights))
            .constructor(EvidenceInsights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceInsights").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(ControlDomainInsights::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            CONTROLS_COUNT_BY_NONCOMPLIANT_EVIDENCE_FIELD, TOTAL_CONTROLS_COUNT_FIELD, EVIDENCE_INSIGHTS_FIELD,
            LAST_UPDATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final Integer controlsCountByNoncompliantEvidence;

    private final Integer totalControlsCount;

    private final EvidenceInsights evidenceInsights;

    private final Instant lastUpdated;

    private ControlDomainInsights(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.controlsCountByNoncompliantEvidence = builder.controlsCountByNoncompliantEvidence;
        this.totalControlsCount = builder.totalControlsCount;
        this.evidenceInsights = builder.evidenceInsights;
        this.lastUpdated = builder.lastUpdated;
    }

    /**
     * <p>
     * The name of the control domain.
     * </p>
     * 
     * @return The name of the control domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier for the control domain.
     * </p>
     * 
     * @return The unique identifier for the control domain.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The number of controls in the control domain that collected non-compliant evidence on the
     * <code>lastUpdated</code> date.
     * </p>
     * 
     * @return The number of controls in the control domain that collected non-compliant evidence on the
     *         <code>lastUpdated</code> date.
     */
    public final Integer controlsCountByNoncompliantEvidence() {
        return controlsCountByNoncompliantEvidence;
    }

    /**
     * <p>
     * The total number of controls in the control domain.
     * </p>
     * 
     * @return The total number of controls in the control domain.
     */
    public final Integer totalControlsCount() {
        return totalControlsCount;
    }

    /**
     * <p>
     * A breakdown of the compliance check status for the evidence that’s associated with the control domain.
     * </p>
     * 
     * @return A breakdown of the compliance check status for the evidence that’s associated with the control domain.
     */
    public final EvidenceInsights evidenceInsights() {
        return evidenceInsights;
    }

    /**
     * <p>
     * The time when the control domain insights were last updated.
     * </p>
     * 
     * @return The time when the control domain insights were last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(controlsCountByNoncompliantEvidence());
        hashCode = 31 * hashCode + Objects.hashCode(totalControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlDomainInsights)) {
            return false;
        }
        ControlDomainInsights other = (ControlDomainInsights) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(controlsCountByNoncompliantEvidence(), other.controlsCountByNoncompliantEvidence())
                && Objects.equals(totalControlsCount(), other.totalControlsCount())
                && Objects.equals(evidenceInsights(), other.evidenceInsights())
                && Objects.equals(lastUpdated(), other.lastUpdated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlDomainInsights").add("Name", name()).add("Id", id())
                .add("ControlsCountByNoncompliantEvidence", controlsCountByNoncompliantEvidence())
                .add("TotalControlsCount", totalControlsCount()).add("EvidenceInsights", evidenceInsights())
                .add("LastUpdated", lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "controlsCountByNoncompliantEvidence":
            return Optional.ofNullable(clazz.cast(controlsCountByNoncompliantEvidence()));
        case "totalControlsCount":
            return Optional.ofNullable(clazz.cast(totalControlsCount()));
        case "evidenceInsights":
            return Optional.ofNullable(clazz.cast(evidenceInsights()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlDomainInsights, T> g) {
        return obj -> g.apply((ControlDomainInsights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlDomainInsights> {
        /**
         * <p>
         * The name of the control domain.
         * </p>
         * 
         * @param name
         *        The name of the control domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier for the control domain.
         * </p>
         * 
         * @param id
         *        The unique identifier for the control domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The number of controls in the control domain that collected non-compliant evidence on the
         * <code>lastUpdated</code> date.
         * </p>
         * 
         * @param controlsCountByNoncompliantEvidence
         *        The number of controls in the control domain that collected non-compliant evidence on the
         *        <code>lastUpdated</code> date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlsCountByNoncompliantEvidence(Integer controlsCountByNoncompliantEvidence);

        /**
         * <p>
         * The total number of controls in the control domain.
         * </p>
         * 
         * @param totalControlsCount
         *        The total number of controls in the control domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalControlsCount(Integer totalControlsCount);

        /**
         * <p>
         * A breakdown of the compliance check status for the evidence that’s associated with the control domain.
         * </p>
         * 
         * @param evidenceInsights
         *        A breakdown of the compliance check status for the evidence that’s associated with the control domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceInsights(EvidenceInsights evidenceInsights);

        /**
         * <p>
         * A breakdown of the compliance check status for the evidence that’s associated with the control domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvidenceInsights.Builder} avoiding the
         * need to create one manually via {@link EvidenceInsights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvidenceInsights.Builder#build()} is called immediately and its
         * result is passed to {@link #evidenceInsights(EvidenceInsights)}.
         * 
         * @param evidenceInsights
         *        a consumer that will call methods on {@link EvidenceInsights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evidenceInsights(EvidenceInsights)
         */
        default Builder evidenceInsights(Consumer<EvidenceInsights.Builder> evidenceInsights) {
            return evidenceInsights(EvidenceInsights.builder().applyMutation(evidenceInsights).build());
        }

        /**
         * <p>
         * The time when the control domain insights were last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time when the control domain insights were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private Integer controlsCountByNoncompliantEvidence;

        private Integer totalControlsCount;

        private EvidenceInsights evidenceInsights;

        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlDomainInsights model) {
            name(model.name);
            id(model.id);
            controlsCountByNoncompliantEvidence(model.controlsCountByNoncompliantEvidence);
            totalControlsCount(model.totalControlsCount);
            evidenceInsights(model.evidenceInsights);
            lastUpdated(model.lastUpdated);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getControlsCountByNoncompliantEvidence() {
            return controlsCountByNoncompliantEvidence;
        }

        public final void setControlsCountByNoncompliantEvidence(Integer controlsCountByNoncompliantEvidence) {
            this.controlsCountByNoncompliantEvidence = controlsCountByNoncompliantEvidence;
        }

        @Override
        public final Builder controlsCountByNoncompliantEvidence(Integer controlsCountByNoncompliantEvidence) {
            this.controlsCountByNoncompliantEvidence = controlsCountByNoncompliantEvidence;
            return this;
        }

        public final Integer getTotalControlsCount() {
            return totalControlsCount;
        }

        public final void setTotalControlsCount(Integer totalControlsCount) {
            this.totalControlsCount = totalControlsCount;
        }

        @Override
        public final Builder totalControlsCount(Integer totalControlsCount) {
            this.totalControlsCount = totalControlsCount;
            return this;
        }

        public final EvidenceInsights.Builder getEvidenceInsights() {
            return evidenceInsights != null ? evidenceInsights.toBuilder() : null;
        }

        public final void setEvidenceInsights(EvidenceInsights.BuilderImpl evidenceInsights) {
            this.evidenceInsights = evidenceInsights != null ? evidenceInsights.build() : null;
        }

        @Override
        public final Builder evidenceInsights(EvidenceInsights evidenceInsights) {
            this.evidenceInsights = evidenceInsights;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Override
        public ControlDomainInsights build() {
            return new ControlDomainInsights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
