/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.AuditManagerClientBuilder;
import software.amazon.awssdk.services.auditmanager.AuditManagerServiceClientConfiguration;
import software.amazon.awssdk.services.auditmanager.DefaultAuditManagerBaseClientBuilder;
import software.amazon.awssdk.services.auditmanager.DefaultAuditManagerClient;
import software.amazon.awssdk.services.auditmanager.endpoints.AuditManagerEndpointProvider;

@SdkInternalApi
final class DefaultAuditManagerClientBuilder
extends DefaultAuditManagerBaseClientBuilder<AuditManagerClientBuilder, AuditManagerClient>
implements AuditManagerClientBuilder {
    DefaultAuditManagerClientBuilder() {
    }

    @Override
    public DefaultAuditManagerClientBuilder endpointProvider(AuditManagerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AuditManagerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAuditManagerClientBuilder.validateClientOptions(clientConfiguration);
        AuditManagerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAuditManagerClient client = new DefaultAuditManagerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AuditManagerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AuditManagerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

