/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateControlRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateControlResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteControlResponse;
import software.amazon.awssdk.services.auditmanager.model.DeregisterAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAccountStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetControlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetControlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeRequest;
import software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse;
import software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse;
import software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest;
import software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse;
import software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListControlsPublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourcePublisher;
import software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsPublisher;

/**
 * Service client for accessing AWS Audit Manager asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Welcome to the Audit Manager API reference. This guide is for developers who need detailed information about the
 * Audit Manager API operations, data types, and errors.
 * </p>
 * <p>
 * Audit Manager is a service that provides automated evidence collection so that you can continually audit your Amazon
 * Web Services usage. You can use it to assess the effectiveness of your controls, manage risk, and simplify
 * compliance.
 * </p>
 * <p>
 * Audit Manager provides prebuilt frameworks that structure and automate assessments for a given compliance standard.
 * Frameworks include a prebuilt collection of controls with descriptions and testing procedures. These controls are
 * grouped according to the requirements of the specified compliance standard or regulation. You can also customize
 * frameworks and controls to support internal audits with specific requirements.
 * </p>
 * <p>
 * Use the following links to get started with the Audit Manager API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Operations.html">Actions</a>: An
 * alphabetical list of all Audit Manager API operations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Types.html">Data types</a>: An
 * alphabetical list of all Audit Manager data types.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonParameters.html">Common parameters</a>:
 * Parameters that all operations can use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonErrors.html">Common errors</a>: Client
 * and server errors that all operations can return.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If you're new to Audit Manager, we recommend that you review the <a
 * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/what-is.html"> Audit Manager User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AuditManagerAsyncClient extends AwsClient {
    String SERVICE_NAME = "auditmanager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "auditmanager";

    /**
     * <p>
     * Associates an evidence folder to an assessment report in an Audit Manager assessment.
     * </p>
     *
     * @param associateAssessmentReportEvidenceFolderRequest
     * @return A Java Future containing the result of the AssociateAssessmentReportEvidenceFolder operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.AssociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAssessmentReportEvidenceFolderResponse> associateAssessmentReportEvidenceFolder(
            AssociateAssessmentReportEvidenceFolderRequest associateAssessmentReportEvidenceFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an evidence folder to an assessment report in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateAssessmentReportEvidenceFolderRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateAssessmentReportEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param associateAssessmentReportEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateAssessmentReportEvidenceFolder operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.AssociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAssessmentReportEvidenceFolderResponse> associateAssessmentReportEvidenceFolder(
            Consumer<AssociateAssessmentReportEvidenceFolderRequest.Builder> associateAssessmentReportEvidenceFolderRequest) {
        return associateAssessmentReportEvidenceFolder(AssociateAssessmentReportEvidenceFolderRequest.builder()
                .applyMutation(associateAssessmentReportEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     * </p>
     *
     * @param batchAssociateAssessmentReportEvidenceRequest
     * @return A Java Future containing the result of the BatchAssociateAssessmentReportEvidence operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchAssociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateAssessmentReportEvidenceResponse> batchAssociateAssessmentReportEvidence(
            BatchAssociateAssessmentReportEvidenceRequest batchAssociateAssessmentReportEvidenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateAssessmentReportEvidenceRequest.Builder} avoiding the need to create one manually via
     * {@link BatchAssociateAssessmentReportEvidenceRequest#builder()}
     * </p>
     *
     * @param batchAssociateAssessmentReportEvidenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchAssociateAssessmentReportEvidence operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchAssociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateAssessmentReportEvidenceResponse> batchAssociateAssessmentReportEvidence(
            Consumer<BatchAssociateAssessmentReportEvidenceRequest.Builder> batchAssociateAssessmentReportEvidenceRequest) {
        return batchAssociateAssessmentReportEvidence(BatchAssociateAssessmentReportEvidenceRequest.builder()
                .applyMutation(batchAssociateAssessmentReportEvidenceRequest).build());
    }

    /**
     * <p>
     * Creates a batch of delegations for an assessment in Audit Manager.
     * </p>
     *
     * @param batchCreateDelegationByAssessmentRequest
     * @return A Java Future containing the result of the BatchCreateDelegationByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchCreateDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateDelegationByAssessmentResponse> batchCreateDelegationByAssessment(
            BatchCreateDelegationByAssessmentRequest batchCreateDelegationByAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch of delegations for an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateDelegationByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCreateDelegationByAssessmentRequest#builder()}
     * </p>
     *
     * @param batchCreateDelegationByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchCreateDelegationByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchCreateDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateDelegationByAssessmentResponse> batchCreateDelegationByAssessment(
            Consumer<BatchCreateDelegationByAssessmentRequest.Builder> batchCreateDelegationByAssessmentRequest) {
        return batchCreateDelegationByAssessment(BatchCreateDelegationByAssessmentRequest.builder()
                .applyMutation(batchCreateDelegationByAssessmentRequest).build());
    }

    /**
     * <p>
     * Deletes a batch of delegations for an assessment in Audit Manager.
     * </p>
     *
     * @param batchDeleteDelegationByAssessmentRequest
     * @return A Java Future containing the result of the BatchDeleteDelegationByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchDeleteDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDelegationByAssessmentResponse> batchDeleteDelegationByAssessment(
            BatchDeleteDelegationByAssessmentRequest batchDeleteDelegationByAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch of delegations for an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDelegationByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteDelegationByAssessmentRequest#builder()}
     * </p>
     *
     * @param batchDeleteDelegationByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDeleteDelegationByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchDeleteDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDelegationByAssessmentResponse> batchDeleteDelegationByAssessment(
            Consumer<BatchDeleteDelegationByAssessmentRequest.Builder> batchDeleteDelegationByAssessmentRequest) {
        return batchDeleteDelegationByAssessment(BatchDeleteDelegationByAssessmentRequest.builder()
                .applyMutation(batchDeleteDelegationByAssessmentRequest).build());
    }

    /**
     * <p>
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     * </p>
     *
     * @param batchDisassociateAssessmentReportEvidenceRequest
     * @return A Java Future containing the result of the BatchDisassociateAssessmentReportEvidence operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchDisassociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateAssessmentReportEvidenceResponse> batchDisassociateAssessmentReportEvidence(
            BatchDisassociateAssessmentReportEvidenceRequest batchDisassociateAssessmentReportEvidenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateAssessmentReportEvidenceRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDisassociateAssessmentReportEvidenceRequest#builder()}
     * </p>
     *
     * @param batchDisassociateAssessmentReportEvidenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDisassociateAssessmentReportEvidence operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchDisassociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateAssessmentReportEvidenceResponse> batchDisassociateAssessmentReportEvidence(
            Consumer<BatchDisassociateAssessmentReportEvidenceRequest.Builder> batchDisassociateAssessmentReportEvidenceRequest) {
        return batchDisassociateAssessmentReportEvidence(BatchDisassociateAssessmentReportEvidenceRequest.builder()
                .applyMutation(batchDisassociateAssessmentReportEvidenceRequest).build());
    }

    /**
     * <p>
     * Adds one or more pieces of evidence to a control in an Audit Manager assessment.
     * </p>
     * <p>
     * You can import manual evidence from any S3 bucket by specifying the S3 URI of the object. You can also upload a
     * file from your browser, or enter plain text in response to a risk assessment question.
     * </p>
     * <p>
     * The following restrictions apply to this action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>manualEvidence</code> can be only one of the following: <code>evidenceFileName</code>,
     * <code>s3ResourcePath</code>, or <code>textResponse</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     *
     * @param batchImportEvidenceToAssessmentControlRequest
     * @return A Java Future containing the result of the BatchImportEvidenceToAssessmentControl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchImportEvidenceToAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchImportEvidenceToAssessmentControlResponse> batchImportEvidenceToAssessmentControl(
            BatchImportEvidenceToAssessmentControlRequest batchImportEvidenceToAssessmentControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more pieces of evidence to a control in an Audit Manager assessment.
     * </p>
     * <p>
     * You can import manual evidence from any S3 bucket by specifying the S3 URI of the object. You can also upload a
     * file from your browser, or enter plain text in response to a risk assessment question.
     * </p>
     * <p>
     * The following restrictions apply to this action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>manualEvidence</code> can be only one of the following: <code>evidenceFileName</code>,
     * <code>s3ResourcePath</code>, or <code>textResponse</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchImportEvidenceToAssessmentControlRequest.Builder} avoiding the need to create one manually via
     * {@link BatchImportEvidenceToAssessmentControlRequest#builder()}
     * </p>
     *
     * @param batchImportEvidenceToAssessmentControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchImportEvidenceToAssessmentControl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchImportEvidenceToAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchImportEvidenceToAssessmentControlResponse> batchImportEvidenceToAssessmentControl(
            Consumer<BatchImportEvidenceToAssessmentControlRequest.Builder> batchImportEvidenceToAssessmentControlRequest) {
        return batchImportEvidenceToAssessmentControl(BatchImportEvidenceToAssessmentControlRequest.builder()
                .applyMutation(batchImportEvidenceToAssessmentControlRequest).build());
    }

    /**
     * <p>
     * Creates an assessment in Audit Manager.
     * </p>
     *
     * @param createAssessmentRequest
     * @return A Java Future containing the result of the CreateAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentResponse> createAssessment(CreateAssessmentRequest createAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssessmentRequest#builder()}
     * </p>
     *
     * @param createAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentResponse> createAssessment(
            Consumer<CreateAssessmentRequest.Builder> createAssessmentRequest) {
        return createAssessment(CreateAssessmentRequest.builder().applyMutation(createAssessmentRequest).build());
    }

    /**
     * <p>
     * Creates a custom framework in Audit Manager.
     * </p>
     *
     * @param createAssessmentFrameworkRequest
     * @return A Java Future containing the result of the CreateAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentFrameworkResponse> createAssessmentFramework(
            CreateAssessmentFrameworkRequest createAssessmentFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentFrameworkRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param createAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentFrameworkResponse> createAssessmentFramework(
            Consumer<CreateAssessmentFrameworkRequest.Builder> createAssessmentFrameworkRequest) {
        return createAssessmentFramework(CreateAssessmentFrameworkRequest.builder()
                .applyMutation(createAssessmentFrameworkRequest).build());
    }

    /**
     * <p>
     * Creates an assessment report for the specified assessment.
     * </p>
     *
     * @param createAssessmentReportRequest
     * @return A Java Future containing the result of the CreateAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentReportResponse> createAssessmentReport(
            CreateAssessmentReportRequest createAssessmentReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assessment report for the specified assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentReportRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssessmentReportRequest#builder()}
     * </p>
     *
     * @param createAssessmentReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentReportResponse> createAssessmentReport(
            Consumer<CreateAssessmentReportRequest.Builder> createAssessmentReportRequest) {
        return createAssessmentReport(CreateAssessmentReportRequest.builder().applyMutation(createAssessmentReportRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom control in Audit Manager.
     * </p>
     *
     * @param createControlRequest
     * @return A Java Future containing the result of the CreateControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateControlResponse> createControl(CreateControlRequest createControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom control in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateControlRequest.Builder} avoiding the need to
     * create one manually via {@link CreateControlRequest#builder()}
     * </p>
     *
     * @param createControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.CreateControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateControlResponse> createControl(Consumer<CreateControlRequest.Builder> createControlRequest) {
        return createControl(CreateControlRequest.builder().applyMutation(createControlRequest).build());
    }

    /**
     * <p>
     * Deletes an assessment in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentRequest
     * @return A Java Future containing the result of the DeleteAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentResponse> deleteAssessment(DeleteAssessmentRequest deleteAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssessmentRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentResponse> deleteAssessment(
            Consumer<DeleteAssessmentRequest.Builder> deleteAssessmentRequest) {
        return deleteAssessment(DeleteAssessmentRequest.builder().applyMutation(deleteAssessmentRequest).build());
    }

    /**
     * <p>
     * Deletes a custom framework in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentFrameworkRequest
     * @return A Java Future containing the result of the DeleteAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentFrameworkResponse> deleteAssessmentFramework(
            DeleteAssessmentFrameworkRequest deleteAssessmentFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentFrameworkRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentFrameworkResponse> deleteAssessmentFramework(
            Consumer<DeleteAssessmentFrameworkRequest.Builder> deleteAssessmentFrameworkRequest) {
        return deleteAssessmentFramework(DeleteAssessmentFrameworkRequest.builder()
                .applyMutation(deleteAssessmentFrameworkRequest).build());
    }

    /**
     * <p>
     * Deletes a share request for a custom framework in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentFrameworkShareRequest
     * @return A Java Future containing the result of the DeleteAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentFrameworkShareResponse> deleteAssessmentFrameworkShare(
            DeleteAssessmentFrameworkShareRequest deleteAssessmentFrameworkShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a share request for a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentFrameworkShareRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAssessmentFrameworkShareRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentFrameworkShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentFrameworkShareResponse> deleteAssessmentFrameworkShare(
            Consumer<DeleteAssessmentFrameworkShareRequest.Builder> deleteAssessmentFrameworkShareRequest) {
        return deleteAssessmentFrameworkShare(DeleteAssessmentFrameworkShareRequest.builder()
                .applyMutation(deleteAssessmentFrameworkShareRequest).build());
    }

    /**
     * <p>
     * Deletes an assessment report in Audit Manager.
     * </p>
     * <p>
     * When you run the <code>DeleteAssessmentReport</code> operation, Audit Manager attempts to delete the following
     * data:
     * </p>
     * <ol>
     * <li>
     * <p>
     * The specified assessment report that’s stored in your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * The associated metadata that’s stored in Audit Manager
     * </p>
     * </li>
     * </ol>
     * <p>
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event,
     * the <code>DeleteAssessmentReport</code> operation doesn’t fail. Instead, it proceeds to delete the associated
     * metadata only. You must then delete the assessment report from the S3 bucket yourself.
     * </p>
     * <p>
     * This scenario happens when Audit Manager receives a <code>403 (Forbidden)</code> or <code>404 (Not Found)</code>
     * error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the
     * correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy
     * that you can use, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination"
     * >Assessment report destination permissions</a> in the <i>Audit Manager User Guide</i>. For information about the
     * issues that could cause a <code>403 (Forbidden)</code> or <code>404 (Not Found</code>) error from Amazon S3, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error
     * Codes</a> in the <i>Amazon Simple Storage Service API Reference</i>.
     * </p>
     *
     * @param deleteAssessmentReportRequest
     * @return A Java Future containing the result of the DeleteAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentReportResponse> deleteAssessmentReport(
            DeleteAssessmentReportRequest deleteAssessmentReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assessment report in Audit Manager.
     * </p>
     * <p>
     * When you run the <code>DeleteAssessmentReport</code> operation, Audit Manager attempts to delete the following
     * data:
     * </p>
     * <ol>
     * <li>
     * <p>
     * The specified assessment report that’s stored in your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * The associated metadata that’s stored in Audit Manager
     * </p>
     * </li>
     * </ol>
     * <p>
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event,
     * the <code>DeleteAssessmentReport</code> operation doesn’t fail. Instead, it proceeds to delete the associated
     * metadata only. You must then delete the assessment report from the S3 bucket yourself.
     * </p>
     * <p>
     * This scenario happens when Audit Manager receives a <code>403 (Forbidden)</code> or <code>404 (Not Found)</code>
     * error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the
     * correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy
     * that you can use, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination"
     * >Assessment report destination permissions</a> in the <i>Audit Manager User Guide</i>. For information about the
     * issues that could cause a <code>403 (Forbidden)</code> or <code>404 (Not Found</code>) error from Amazon S3, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error
     * Codes</a> in the <i>Amazon Simple Storage Service API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentReportRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAssessmentReportRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentReportResponse> deleteAssessmentReport(
            Consumer<DeleteAssessmentReportRequest.Builder> deleteAssessmentReportRequest) {
        return deleteAssessmentReport(DeleteAssessmentReportRequest.builder().applyMutation(deleteAssessmentReportRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom control in Audit Manager.
     * </p>
     * <important>
     * <p>
     * When you invoke this operation, the custom control is deleted from any frameworks or assessments that it’s
     * currently part of. As a result, Audit Manager will stop collecting evidence for that custom control in all of
     * your assessments. This includes assessments that you previously created before you deleted the custom control.
     * </p>
     * </important>
     *
     * @param deleteControlRequest
     * @return A Java Future containing the result of the DeleteControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteControlResponse> deleteControl(DeleteControlRequest deleteControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom control in Audit Manager.
     * </p>
     * <important>
     * <p>
     * When you invoke this operation, the custom control is deleted from any frameworks or assessments that it’s
     * currently part of. As a result, Audit Manager will stop collecting evidence for that custom control in all of
     * your assessments. This includes assessments that you previously created before you deleted the custom control.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteControlRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteControlRequest#builder()}
     * </p>
     *
     * @param deleteControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteControlResponse> deleteControl(Consumer<DeleteControlRequest.Builder> deleteControlRequest) {
        return deleteControl(DeleteControlRequest.builder().applyMutation(deleteControlRequest).build());
    }

    /**
     * <p>
     * Deregisters an account in Audit Manager.
     * </p>
     * <note>
     * <p>
     * Before you deregister, you can use the <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html">UpdateSettings</a>
     * API operation to set your preferred data retention policy. By default, Audit Manager retains your data. If you
     * want to delete your data, you can use the <code>DeregistrationPolicy</code> attribute to request the deletion of
     * your data.
     * </p>
     * <p>
     * For more information about data retention, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/data-protection.html">Data Protection</a> in the
     * <i>Audit Manager User Guide</i>.
     * </p>
     * </note>
     *
     * @param deregisterAccountRequest
     * @return A Java Future containing the result of the DeregisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeregisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterAccountResponse> deregisterAccount(DeregisterAccountRequest deregisterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an account in Audit Manager.
     * </p>
     * <note>
     * <p>
     * Before you deregister, you can use the <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html">UpdateSettings</a>
     * API operation to set your preferred data retention policy. By default, Audit Manager retains your data. If you
     * want to delete your data, you can use the <code>DeregistrationPolicy</code> attribute to request the deletion of
     * your data.
     * </p>
     * <p>
     * For more information about data retention, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/data-protection.html">Data Protection</a> in the
     * <i>Audit Manager User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterAccountRequest#builder()}
     * </p>
     *
     * @param deregisterAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeregisterAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeregisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterAccountResponse> deregisterAccount(
            Consumer<DeregisterAccountRequest.Builder> deregisterAccountRequest) {
        return deregisterAccount(DeregisterAccountRequest.builder().applyMutation(deregisterAccountRequest).build());
    }

    /**
     * <p>
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     * </p>
     * <p>
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the
     * evidence that you previously collected under that account. This is also the case when you deregister a delegated
     * administrator from Organizations. However, Audit Manager stops collecting and attaching evidence to that
     * delegated administrator account moving forward.
     * </p>
     * <important>
     * <p>
     * Keep in mind the following cleanup task if you use evidence finder:
     * </p>
     * <p>
     * Before you use your management account to remove a delegated administrator, make sure that the current delegated
     * administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder
     * automatically deletes the event data store that was created in their account when they enabled evidence finder.
     * If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the
     * original delegated administrator goes to CloudTrail Lake and manually <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-eds-disable-termination.html">deletes the
     * event data store</a>.
     * </p>
     * <p>
     * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager
     * ignores an unused event data store after you remove or change a delegated administrator account. However, the
     * unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
     * </p>
     * </important>
     * <p>
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted.
     * If you want to delete resource data for a delegated administrator account, you must perform that task separately
     * before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of
     * the delete API operations that are provided by Audit Manager.
     * </p>
     * <p>
     * To delete your Audit Manager resource data, see the following instructions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html">DeleteAssessment
     * </a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html">Deleting an
     * assessment</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html">
     * DeleteAssessmentFramework</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html">Deleting a custom
     * framework</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html">
     * DeleteAssessmentFrameworkShare</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html"
     * >Deleting a share request</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html">
     * DeleteAssessmentReport</a> (see also: <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps"
     * >Deleting an assessment report</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html">DeleteControl</a>
     * (see also: <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html">Deleting a
     * custom control</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * At this time, Audit Manager doesn't provide an option to delete evidence for a specific delegated administrator.
     * Instead, when your management account deregisters Audit Manager, we perform a cleanup for the current delegated
     * administrator account at the time of deregistration.
     * </p>
     *
     * @param deregisterOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DeregisterOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeregisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOrganizationAdminAccountResponse> deregisterOrganizationAdminAccount(
            DeregisterOrganizationAdminAccountRequest deregisterOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     * </p>
     * <p>
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the
     * evidence that you previously collected under that account. This is also the case when you deregister a delegated
     * administrator from Organizations. However, Audit Manager stops collecting and attaching evidence to that
     * delegated administrator account moving forward.
     * </p>
     * <important>
     * <p>
     * Keep in mind the following cleanup task if you use evidence finder:
     * </p>
     * <p>
     * Before you use your management account to remove a delegated administrator, make sure that the current delegated
     * administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder
     * automatically deletes the event data store that was created in their account when they enabled evidence finder.
     * If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the
     * original delegated administrator goes to CloudTrail Lake and manually <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-eds-disable-termination.html">deletes the
     * event data store</a>.
     * </p>
     * <p>
     * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager
     * ignores an unused event data store after you remove or change a delegated administrator account. However, the
     * unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
     * </p>
     * </important>
     * <p>
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted.
     * If you want to delete resource data for a delegated administrator account, you must perform that task separately
     * before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of
     * the delete API operations that are provided by Audit Manager.
     * </p>
     * <p>
     * To delete your Audit Manager resource data, see the following instructions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html">DeleteAssessment
     * </a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html">Deleting an
     * assessment</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html">
     * DeleteAssessmentFramework</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html">Deleting a custom
     * framework</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html">
     * DeleteAssessmentFrameworkShare</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html"
     * >Deleting a share request</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html">
     * DeleteAssessmentReport</a> (see also: <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps"
     * >Deleting an assessment report</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html">DeleteControl</a>
     * (see also: <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html">Deleting a
     * custom control</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * At this time, Audit Manager doesn't provide an option to delete evidence for a specific delegated administrator.
     * Instead, when your management account deregisters Audit Manager, we perform a cleanup for the current delegated
     * administrator account at the time of deregistration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param deregisterOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeregisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOrganizationAdminAccountResponse> deregisterOrganizationAdminAccount(
            Consumer<DeregisterOrganizationAdminAccountRequest.Builder> deregisterOrganizationAdminAccountRequest) {
        return deregisterOrganizationAdminAccount(DeregisterOrganizationAdminAccountRequest.builder()
                .applyMutation(deregisterOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     * </p>
     *
     * @param disassociateAssessmentReportEvidenceFolderRequest
     * @return A Java Future containing the result of the DisassociateAssessmentReportEvidenceFolder operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DisassociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAssessmentReportEvidenceFolderResponse> disassociateAssessmentReportEvidenceFolder(
            DisassociateAssessmentReportEvidenceFolderRequest disassociateAssessmentReportEvidenceFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateAssessmentReportEvidenceFolderRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateAssessmentReportEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param disassociateAssessmentReportEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateAssessmentReportEvidenceFolder operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DisassociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAssessmentReportEvidenceFolderResponse> disassociateAssessmentReportEvidenceFolder(
            Consumer<DisassociateAssessmentReportEvidenceFolderRequest.Builder> disassociateAssessmentReportEvidenceFolderRequest) {
        return disassociateAssessmentReportEvidenceFolder(DisassociateAssessmentReportEvidenceFolderRequest.builder()
                .applyMutation(disassociateAssessmentReportEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Gets the registration status of an account in Audit Manager.
     * </p>
     *
     * @param getAccountStatusRequest
     * @return A Java Future containing the result of the GetAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountStatusResponse> getAccountStatus(GetAccountStatusRequest getAccountStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the registration status of an account in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountStatusRequest#builder()}
     * </p>
     *
     * @param getAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetAccountStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountStatusResponse> getAccountStatus(
            Consumer<GetAccountStatusRequest.Builder> getAccountStatusRequest) {
        return getAccountStatus(GetAccountStatusRequest.builder().applyMutation(getAccountStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified assessment.
     * </p>
     *
     * @param getAssessmentRequest
     * @return A Java Future containing the result of the GetAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssessmentResponse> getAssessment(GetAssessmentRequest getAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssessmentRequest#builder()}
     * </p>
     *
     * @param getAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssessmentResponse> getAssessment(Consumer<GetAssessmentRequest.Builder> getAssessmentRequest) {
        return getAssessment(GetAssessmentRequest.builder().applyMutation(getAssessmentRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified framework.
     * </p>
     *
     * @param getAssessmentFrameworkRequest
     * @return A Java Future containing the result of the GetAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssessmentFrameworkResponse> getAssessmentFramework(
            GetAssessmentFrameworkRequest getAssessmentFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified framework.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentFrameworkRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param getAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssessmentFrameworkResponse> getAssessmentFramework(
            Consumer<GetAssessmentFrameworkRequest.Builder> getAssessmentFrameworkRequest) {
        return getAssessmentFramework(GetAssessmentFrameworkRequest.builder().applyMutation(getAssessmentFrameworkRequest)
                .build());
    }

    /**
     * <p>
     * Gets the URL of an assessment report in Audit Manager.
     * </p>
     *
     * @param getAssessmentReportUrlRequest
     * @return A Java Future containing the result of the GetAssessmentReportUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessmentReportUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssessmentReportUrlResponse> getAssessmentReportUrl(
            GetAssessmentReportUrlRequest getAssessmentReportUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the URL of an assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentReportUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssessmentReportUrlRequest#builder()}
     * </p>
     *
     * @param getAssessmentReportUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAssessmentReportUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessmentReportUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssessmentReportUrlResponse> getAssessmentReportUrl(
            Consumer<GetAssessmentReportUrlRequest.Builder> getAssessmentReportUrlRequest) {
        return getAssessmentReportUrl(GetAssessmentReportUrlRequest.builder().applyMutation(getAssessmentReportUrlRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of changelogs from Audit Manager.
     * </p>
     *
     * @param getChangeLogsRequest
     * @return A Java Future containing the result of the GetChangeLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetChangeLogsResponse> getChangeLogs(GetChangeLogsRequest getChangeLogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of changelogs from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChangeLogsRequest.Builder} avoiding the need to
     * create one manually via {@link GetChangeLogsRequest#builder()}
     * </p>
     *
     * @param getChangeLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetChangeLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetChangeLogsResponse> getChangeLogs(Consumer<GetChangeLogsRequest.Builder> getChangeLogsRequest) {
        return getChangeLogs(GetChangeLogsRequest.builder().applyMutation(getChangeLogsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsPublisher publisher = client.getChangeLogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsPublisher publisher = client.getChangeLogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation.</b>
     * </p>
     *
     * @param getChangeLogsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChangeLogsPublisher getChangeLogsPaginator(GetChangeLogsRequest getChangeLogsRequest) {
        return new GetChangeLogsPublisher(this, getChangeLogsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsPublisher publisher = client.getChangeLogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetChangeLogsPublisher publisher = client.getChangeLogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChangeLogs(software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChangeLogsRequest.Builder} avoiding the need to
     * create one manually via {@link GetChangeLogsRequest#builder()}
     * </p>
     *
     * @param getChangeLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChangeLogsPublisher getChangeLogsPaginator(Consumer<GetChangeLogsRequest.Builder> getChangeLogsRequest) {
        return getChangeLogsPaginator(GetChangeLogsRequest.builder().applyMutation(getChangeLogsRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified control.
     * </p>
     *
     * @param getControlRequest
     * @return A Java Future containing the result of the GetControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetControlResponse> getControl(GetControlRequest getControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetControlRequest.Builder} avoiding the need to
     * create one manually via {@link GetControlRequest#builder()}
     * </p>
     *
     * @param getControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetControlRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetControlResponse> getControl(Consumer<GetControlRequest.Builder> getControlRequest) {
        return getControl(GetControlRequest.builder().applyMutation(getControlRequest).build());
    }

    /**
     * <p>
     * Gets a list of delegations from an audit owner to a delegate.
     * </p>
     *
     * @param getDelegationsRequest
     * @return A Java Future containing the result of the GetDelegations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDelegationsResponse> getDelegations(GetDelegationsRequest getDelegationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of delegations from an audit owner to a delegate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegationsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDelegationsRequest#builder()}
     * </p>
     *
     * @param getDelegationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDelegations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDelegationsResponse> getDelegations(Consumer<GetDelegationsRequest.Builder> getDelegationsRequest) {
        return getDelegations(GetDelegationsRequest.builder().applyMutation(getDelegationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsPublisher publisher = client.getDelegationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsPublisher publisher = client.getDelegationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation.</b>
     * </p>
     *
     * @param getDelegationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDelegationsPublisher getDelegationsPaginator(GetDelegationsRequest getDelegationsRequest) {
        return new GetDelegationsPublisher(this, getDelegationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsPublisher publisher = client.getDelegationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetDelegationsPublisher publisher = client.getDelegationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDelegations(software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegationsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDelegationsRequest#builder()}
     * </p>
     *
     * @param getDelegationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDelegationsPublisher getDelegationsPaginator(Consumer<GetDelegationsRequest.Builder> getDelegationsRequest) {
        return getDelegationsPaginator(GetDelegationsRequest.builder().applyMutation(getDelegationsRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified evidence item.
     * </p>
     *
     * @param getEvidenceRequest
     * @return A Java Future containing the result of the GetEvidence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEvidenceResponse> getEvidence(GetEvidenceRequest getEvidenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified evidence item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetEvidenceRequest#builder()}
     * </p>
     *
     * @param getEvidenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEvidence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEvidenceResponse> getEvidence(Consumer<GetEvidenceRequest.Builder> getEvidenceRequest) {
        return getEvidence(GetEvidenceRequest.builder().applyMutation(getEvidenceRequest).build());
    }

    /**
     * <p>
     * Gets all evidence from a specified evidence folder in Audit Manager.
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     * @return A Java Future containing the result of the GetEvidenceByEvidenceFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceByEvidenceFolderResponse> getEvidenceByEvidenceFolder(
            GetEvidenceByEvidenceFolderRequest getEvidenceByEvidenceFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all evidence from a specified evidence folder in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceByEvidenceFolderRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceByEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEvidenceByEvidenceFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceByEvidenceFolderResponse> getEvidenceByEvidenceFolder(
            Consumer<GetEvidenceByEvidenceFolderRequest.Builder> getEvidenceByEvidenceFolderRequest) {
        return getEvidenceByEvidenceFolder(GetEvidenceByEvidenceFolderRequest.builder()
                .applyMutation(getEvidenceByEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderPublisher publisher = client.getEvidenceByEvidenceFolderPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderPublisher publisher = client.getEvidenceByEvidenceFolderPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceByEvidenceFolderPublisher getEvidenceByEvidenceFolderPaginator(
            GetEvidenceByEvidenceFolderRequest getEvidenceByEvidenceFolderRequest) {
        return new GetEvidenceByEvidenceFolderPublisher(this, getEvidenceByEvidenceFolderRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderPublisher publisher = client.getEvidenceByEvidenceFolderPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceByEvidenceFolderPublisher publisher = client.getEvidenceByEvidenceFolderPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceByEvidenceFolder(software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceByEvidenceFolderRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceByEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceByEvidenceFolderPublisher getEvidenceByEvidenceFolderPaginator(
            Consumer<GetEvidenceByEvidenceFolderRequest.Builder> getEvidenceByEvidenceFolderRequest) {
        return getEvidenceByEvidenceFolderPaginator(GetEvidenceByEvidenceFolderRequest.builder()
                .applyMutation(getEvidenceByEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Creates a presigned Amazon S3 URL that can be used to upload a file as manual evidence. For instructions on how
     * to use this operation, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#how-to-upload-manual-evidence-files"
     * >Upload a file from your browser </a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * <p>
     * The following restrictions apply to this operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     *
     * @param getEvidenceFileUploadUrlRequest
     * @return A Java Future containing the result of the GetEvidenceFileUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFileUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFileUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFileUploadUrlResponse> getEvidenceFileUploadUrl(
            GetEvidenceFileUploadUrlRequest getEvidenceFileUploadUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a presigned Amazon S3 URL that can be used to upload a file as manual evidence. For instructions on how
     * to use this operation, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#how-to-upload-manual-evidence-files"
     * >Upload a file from your browser </a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * <p>
     * The following restrictions apply to this operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFileUploadUrlRequest.Builder} avoiding
     * the need to create one manually via {@link GetEvidenceFileUploadUrlRequest#builder()}
     * </p>
     *
     * @param getEvidenceFileUploadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEvidenceFileUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFileUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFileUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFileUploadUrlResponse> getEvidenceFileUploadUrl(
            Consumer<GetEvidenceFileUploadUrlRequest.Builder> getEvidenceFileUploadUrlRequest) {
        return getEvidenceFileUploadUrl(GetEvidenceFileUploadUrlRequest.builder().applyMutation(getEvidenceFileUploadUrlRequest)
                .build());
    }

    /**
     * <p>
     * Gets an evidence folder from a specified assessment in Audit Manager.
     * </p>
     *
     * @param getEvidenceFolderRequest
     * @return A Java Future containing the result of the GetEvidenceFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFolderResponse> getEvidenceFolder(GetEvidenceFolderRequest getEvidenceFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an evidence folder from a specified assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFolderRequest.Builder} avoiding the need
     * to create one manually via {@link GetEvidenceFolderRequest#builder()}
     * </p>
     *
     * @param getEvidenceFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEvidenceFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFolderResponse> getEvidenceFolder(
            Consumer<GetEvidenceFolderRequest.Builder> getEvidenceFolderRequest) {
        return getEvidenceFolder(GetEvidenceFolderRequest.builder().applyMutation(getEvidenceFolderRequest).build());
    }

    /**
     * <p>
     * Gets the evidence folders from a specified assessment in Audit Manager.
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     * @return A Java Future containing the result of the GetEvidenceFoldersByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFoldersByAssessmentResponse> getEvidenceFoldersByAssessment(
            GetEvidenceFoldersByAssessmentRequest getEvidenceFoldersByAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the evidence folders from a specified assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFoldersByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceFoldersByAssessmentRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEvidenceFoldersByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFoldersByAssessmentResponse> getEvidenceFoldersByAssessment(
            Consumer<GetEvidenceFoldersByAssessmentRequest.Builder> getEvidenceFoldersByAssessmentRequest) {
        return getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentRequest).build());
    }

    /**
     * <p>
     * Gets a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     * @return A Java Future containing the result of the GetEvidenceFoldersByAssessmentControl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFoldersByAssessmentControlResponse> getEvidenceFoldersByAssessmentControl(
            GetEvidenceFoldersByAssessmentControlRequest getEvidenceFoldersByAssessmentControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEvidenceFoldersByAssessmentControlRequest.Builder} avoiding the need to create one manually via
     * {@link GetEvidenceFoldersByAssessmentControlRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEvidenceFoldersByAssessmentControl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEvidenceFoldersByAssessmentControlResponse> getEvidenceFoldersByAssessmentControl(
            Consumer<GetEvidenceFoldersByAssessmentControlRequest.Builder> getEvidenceFoldersByAssessmentControlRequest) {
        return getEvidenceFoldersByAssessmentControl(GetEvidenceFoldersByAssessmentControlRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentControlRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlPublisher publisher = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlPublisher publisher = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentControlPublisher getEvidenceFoldersByAssessmentControlPaginator(
            GetEvidenceFoldersByAssessmentControlRequest getEvidenceFoldersByAssessmentControlRequest) {
        return new GetEvidenceFoldersByAssessmentControlPublisher(this, getEvidenceFoldersByAssessmentControlRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlPublisher publisher = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentControlPublisher publisher = client.getEvidenceFoldersByAssessmentControlPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessmentControl(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEvidenceFoldersByAssessmentControlRequest.Builder} avoiding the need to create one manually via
     * {@link GetEvidenceFoldersByAssessmentControlRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentControlPublisher getEvidenceFoldersByAssessmentControlPaginator(
            Consumer<GetEvidenceFoldersByAssessmentControlRequest.Builder> getEvidenceFoldersByAssessmentControlRequest) {
        return getEvidenceFoldersByAssessmentControlPaginator(GetEvidenceFoldersByAssessmentControlRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentControlRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentPublisher publisher = client.getEvidenceFoldersByAssessmentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentPublisher publisher = client.getEvidenceFoldersByAssessmentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentPublisher getEvidenceFoldersByAssessmentPaginator(
            GetEvidenceFoldersByAssessmentRequest getEvidenceFoldersByAssessmentRequest) {
        return new GetEvidenceFoldersByAssessmentPublisher(this, getEvidenceFoldersByAssessmentRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentPublisher publisher = client.getEvidenceFoldersByAssessmentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.GetEvidenceFoldersByAssessmentPublisher publisher = client.getEvidenceFoldersByAssessmentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEvidenceFoldersByAssessment(software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvidenceFoldersByAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link GetEvidenceFoldersByAssessmentRequest#builder()}
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEvidenceFoldersByAssessmentPublisher getEvidenceFoldersByAssessmentPaginator(
            Consumer<GetEvidenceFoldersByAssessmentRequest.Builder> getEvidenceFoldersByAssessmentRequest) {
        return getEvidenceFoldersByAssessmentPaginator(GetEvidenceFoldersByAssessmentRequest.builder()
                .applyMutation(getEvidenceFoldersByAssessmentRequest).build());
    }

    /**
     * <p>
     * Gets the latest analytics data for all your current active assessments.
     * </p>
     *
     * @param getInsightsRequest
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInsightsResponse> getInsights(GetInsightsRequest getInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest analytics data for all your current active assessments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetInsightsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInsightsResponse> getInsights(Consumer<GetInsightsRequest.Builder> getInsightsRequest) {
        return getInsights(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Gets the latest analytics data for a specific active assessment.
     * </p>
     *
     * @param getInsightsByAssessmentRequest
     * @return A Java Future containing the result of the GetInsightsByAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetInsightsByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInsightsByAssessmentResponse> getInsightsByAssessment(
            GetInsightsByAssessmentRequest getInsightsByAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest analytics data for a specific active assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsByAssessmentRequest.Builder} avoiding
     * the need to create one manually via {@link GetInsightsByAssessmentRequest#builder()}
     * </p>
     *
     * @param getInsightsByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetInsightsByAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetInsightsByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInsightsByAssessmentResponse> getInsightsByAssessment(
            Consumer<GetInsightsByAssessmentRequest.Builder> getInsightsByAssessmentRequest) {
        return getInsightsByAssessment(GetInsightsByAssessmentRequest.builder().applyMutation(getInsightsByAssessmentRequest)
                .build());
    }

    /**
     * <p>
     * Gets the name of the delegated Amazon Web Services administrator account for a specified organization.
     * </p>
     *
     * @param getOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the GetOrganizationAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationAdminAccountResponse> getOrganizationAdminAccount(
            GetOrganizationAdminAccountRequest getOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the name of the delegated Amazon Web Services administrator account for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param getOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetOrganizationAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationAdminAccountResponse> getOrganizationAdminAccount(
            Consumer<GetOrganizationAdminAccountRequest.Builder> getOrganizationAdminAccountRequest) {
        return getOrganizationAdminAccount(GetOrganizationAdminAccountRequest.builder()
                .applyMutation(getOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Gets a list of all of the Amazon Web Services that you can choose to include in your assessment. When you <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html">create an
     * assessment</a>, specify which of these services you want to include to narrow the assessment's <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html">scope</a>.
     * </p>
     *
     * @param getServicesInScopeRequest
     * @return A Java Future containing the result of the GetServicesInScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetServicesInScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServicesInScopeResponse> getServicesInScope(GetServicesInScopeRequest getServicesInScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all of the Amazon Web Services that you can choose to include in your assessment. When you <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html">create an
     * assessment</a>, specify which of these services you want to include to narrow the assessment's <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html">scope</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServicesInScopeRequest.Builder} avoiding the
     * need to create one manually via {@link GetServicesInScopeRequest#builder()}
     * </p>
     *
     * @param getServicesInScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServicesInScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetServicesInScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServicesInScopeResponse> getServicesInScope(
            Consumer<GetServicesInScopeRequest.Builder> getServicesInScopeRequest) {
        return getServicesInScope(GetServicesInScopeRequest.builder().applyMutation(getServicesInScopeRequest).build());
    }

    /**
     * <p>
     * Gets the settings for a specified Amazon Web Services account.
     * </p>
     *
     * @param getSettingsRequest
     * @return A Java Future containing the result of the GetSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSettingsResponse> getSettings(GetSettingsRequest getSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the settings for a specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSettingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSettingsRequest#builder()}
     * </p>
     *
     * @param getSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSettingsResponse> getSettings(Consumer<GetSettingsRequest.Builder> getSettingsRequest) {
        return getSettings(GetSettingsRequest.builder().applyMutation(getSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     * @return A Java Future containing the result of the ListAssessmentControlInsightsByControlDomain operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentControlInsightsByControlDomainResponse> listAssessmentControlInsightsByControlDomain(
            ListAssessmentControlInsightsByControlDomainRequest listAssessmentControlInsightsByControlDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentControlInsightsByControlDomainRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAssessmentControlInsightsByControlDomain operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentControlInsightsByControlDomainResponse> listAssessmentControlInsightsByControlDomain(
            Consumer<ListAssessmentControlInsightsByControlDomainRequest.Builder> listAssessmentControlInsightsByControlDomainRequest) {
        return listAssessmentControlInsightsByControlDomain(ListAssessmentControlInsightsByControlDomainRequest.builder()
                .applyMutation(listAssessmentControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainPublisher publisher = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainPublisher publisher = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentControlInsightsByControlDomainPublisher listAssessmentControlInsightsByControlDomainPaginator(
            ListAssessmentControlInsightsByControlDomainRequest listAssessmentControlInsightsByControlDomainRequest) {
        return new ListAssessmentControlInsightsByControlDomainPublisher(this,
                listAssessmentControlInsightsByControlDomainRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainPublisher publisher = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentControlInsightsByControlDomainPublisher publisher = client.listAssessmentControlInsightsByControlDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentControlInsightsByControlDomainRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentControlInsightsByControlDomainPublisher listAssessmentControlInsightsByControlDomainPaginator(
            Consumer<ListAssessmentControlInsightsByControlDomainRequest.Builder> listAssessmentControlInsightsByControlDomainRequest) {
        return listAssessmentControlInsightsByControlDomainPaginator(ListAssessmentControlInsightsByControlDomainRequest
                .builder().applyMutation(listAssessmentControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     * @return A Java Future containing the result of the ListAssessmentFrameworkShareRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentFrameworkShareRequestsResponse> listAssessmentFrameworkShareRequests(
            ListAssessmentFrameworkShareRequestsRequest listAssessmentFrameworkShareRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentFrameworkShareRequestsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentFrameworkShareRequestsRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAssessmentFrameworkShareRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentFrameworkShareRequestsResponse> listAssessmentFrameworkShareRequests(
            Consumer<ListAssessmentFrameworkShareRequestsRequest.Builder> listAssessmentFrameworkShareRequestsRequest) {
        return listAssessmentFrameworkShareRequests(ListAssessmentFrameworkShareRequestsRequest.builder()
                .applyMutation(listAssessmentFrameworkShareRequestsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsPublisher publisher = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsPublisher publisher = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworkShareRequestsPublisher listAssessmentFrameworkShareRequestsPaginator(
            ListAssessmentFrameworkShareRequestsRequest listAssessmentFrameworkShareRequestsRequest) {
        return new ListAssessmentFrameworkShareRequestsPublisher(this, listAssessmentFrameworkShareRequestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsPublisher publisher = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworkShareRequestsPublisher publisher = client.listAssessmentFrameworkShareRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworkShareRequests(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssessmentFrameworkShareRequestsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssessmentFrameworkShareRequestsRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworkShareRequestsPublisher listAssessmentFrameworkShareRequestsPaginator(
            Consumer<ListAssessmentFrameworkShareRequestsRequest.Builder> listAssessmentFrameworkShareRequestsRequest) {
        return listAssessmentFrameworkShareRequestsPaginator(ListAssessmentFrameworkShareRequestsRequest.builder()
                .applyMutation(listAssessmentFrameworkShareRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     * @return A Java Future containing the result of the ListAssessmentFrameworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentFrameworksResponse> listAssessmentFrameworks(
            ListAssessmentFrameworksRequest listAssessmentFrameworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentFrameworksRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentFrameworksRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAssessmentFrameworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentFrameworksResponse> listAssessmentFrameworks(
            Consumer<ListAssessmentFrameworksRequest.Builder> listAssessmentFrameworksRequest) {
        return listAssessmentFrameworks(ListAssessmentFrameworksRequest.builder().applyMutation(listAssessmentFrameworksRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksPublisher publisher = client.listAssessmentFrameworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksPublisher publisher = client.listAssessmentFrameworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworksPublisher listAssessmentFrameworksPaginator(
            ListAssessmentFrameworksRequest listAssessmentFrameworksRequest) {
        return new ListAssessmentFrameworksPublisher(this, listAssessmentFrameworksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksPublisher publisher = client.listAssessmentFrameworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentFrameworksPublisher publisher = client.listAssessmentFrameworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentFrameworks(software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentFrameworksRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentFrameworksRequest#builder()}
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentFrameworksPublisher listAssessmentFrameworksPaginator(
            Consumer<ListAssessmentFrameworksRequest.Builder> listAssessmentFrameworksRequest) {
        return listAssessmentFrameworksPaginator(ListAssessmentFrameworksRequest.builder()
                .applyMutation(listAssessmentFrameworksRequest).build());
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     *
     * @param listAssessmentReportsRequest
     * @return A Java Future containing the result of the ListAssessmentReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentReportsResponse> listAssessmentReports(
            ListAssessmentReportsRequest listAssessmentReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentReportsRequest#builder()}
     * </p>
     *
     * @param listAssessmentReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAssessmentReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentReportsResponse> listAssessmentReports(
            Consumer<ListAssessmentReportsRequest.Builder> listAssessmentReportsRequest) {
        return listAssessmentReports(ListAssessmentReportsRequest.builder().applyMutation(listAssessmentReportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsPublisher publisher = client.listAssessmentReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsPublisher publisher = client.listAssessmentReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentReportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentReportsPublisher listAssessmentReportsPaginator(
            ListAssessmentReportsRequest listAssessmentReportsRequest) {
        return new ListAssessmentReportsPublisher(this, listAssessmentReportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsPublisher publisher = client.listAssessmentReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentReportsPublisher publisher = client.listAssessmentReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentReports(software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentReportsRequest#builder()}
     * </p>
     *
     * @param listAssessmentReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentReportsPublisher listAssessmentReportsPaginator(
            Consumer<ListAssessmentReportsRequest.Builder> listAssessmentReportsRequest) {
        return listAssessmentReportsPaginator(ListAssessmentReportsRequest.builder().applyMutation(listAssessmentReportsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     *
     * @param listAssessmentsRequest
     * @return A Java Future containing the result of the ListAssessments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssessmentsResponse> listAssessments(ListAssessmentsRequest listAssessmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssessmentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssessments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssessmentsResponse> listAssessments(
            Consumer<ListAssessmentsRequest.Builder> listAssessmentsRequest) {
        return listAssessments(ListAssessmentsRequest.builder().applyMutation(listAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsPublisher publisher = client.listAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsPublisher publisher = client.listAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentsPublisher listAssessmentsPaginator(ListAssessmentsRequest listAssessmentsRequest) {
        return new ListAssessmentsPublisher(this, listAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsPublisher publisher = client.listAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListAssessmentsPublisher publisher = client.listAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessments(software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssessmentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentsPublisher listAssessmentsPaginator(Consumer<ListAssessmentsRequest.Builder> listAssessmentsRequest) {
        return listAssessmentsPaginator(ListAssessmentsRequest.builder().applyMutation(listAssessmentsRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note>
     *
     * @param listControlDomainInsightsRequest
     * @return A Java Future containing the result of the ListControlDomainInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListControlDomainInsightsResponse> listControlDomainInsights(
            ListControlDomainInsightsRequest listControlDomainInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlDomainInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListControlDomainInsightsRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListControlDomainInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListControlDomainInsightsResponse> listControlDomainInsights(
            Consumer<ListControlDomainInsightsRequest.Builder> listControlDomainInsightsRequest) {
        return listControlDomainInsights(ListControlDomainInsightsRequest.builder()
                .applyMutation(listControlDomainInsightsRequest).build());
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     * @return A Java Future containing the result of the ListControlDomainInsightsByAssessment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListControlDomainInsightsByAssessmentResponse> listControlDomainInsightsByAssessment(
            ListControlDomainInsightsByAssessmentRequest listControlDomainInsightsByAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListControlDomainInsightsByAssessmentRequest.Builder} avoiding the need to create one manually via
     * {@link ListControlDomainInsightsByAssessmentRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListControlDomainInsightsByAssessment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListControlDomainInsightsByAssessmentResponse> listControlDomainInsightsByAssessment(
            Consumer<ListControlDomainInsightsByAssessmentRequest.Builder> listControlDomainInsightsByAssessmentRequest) {
        return listControlDomainInsightsByAssessment(ListControlDomainInsightsByAssessmentRequest.builder()
                .applyMutation(listControlDomainInsightsByAssessmentRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentPublisher publisher = client.listControlDomainInsightsByAssessmentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentPublisher publisher = client.listControlDomainInsightsByAssessmentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsByAssessmentPublisher listControlDomainInsightsByAssessmentPaginator(
            ListControlDomainInsightsByAssessmentRequest listControlDomainInsightsByAssessmentRequest) {
        return new ListControlDomainInsightsByAssessmentPublisher(this, listControlDomainInsightsByAssessmentRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentPublisher publisher = client.listControlDomainInsightsByAssessmentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsByAssessmentPublisher publisher = client.listControlDomainInsightsByAssessmentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsightsByAssessment(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListControlDomainInsightsByAssessmentRequest.Builder} avoiding the need to create one manually via
     * {@link ListControlDomainInsightsByAssessmentRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsByAssessmentPublisher listControlDomainInsightsByAssessmentPaginator(
            Consumer<ListControlDomainInsightsByAssessmentRequest.Builder> listControlDomainInsightsByAssessmentRequest) {
        return listControlDomainInsightsByAssessmentPaginator(ListControlDomainInsightsByAssessmentRequest.builder()
                .applyMutation(listControlDomainInsightsByAssessmentRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsPublisher publisher = client.listControlDomainInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsPublisher publisher = client.listControlDomainInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlDomainInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsPublisher listControlDomainInsightsPaginator(
            ListControlDomainInsightsRequest listControlDomainInsightsRequest) {
        return new ListControlDomainInsightsPublisher(this, listControlDomainInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsPublisher publisher = client.listControlDomainInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlDomainInsightsPublisher publisher = client.listControlDomainInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlDomainInsights(software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlDomainInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListControlDomainInsightsRequest#builder()}
     * </p>
     *
     * @param listControlDomainInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlDomainInsightsPublisher listControlDomainInsightsPaginator(
            Consumer<ListControlDomainInsightsRequest.Builder> listControlDomainInsightsRequest) {
        return listControlDomainInsightsPaginator(ListControlDomainInsightsRequest.builder()
                .applyMutation(listControlDomainInsightsRequest).build());
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note>
     *
     * @param listControlInsightsByControlDomainRequest
     * @return A Java Future containing the result of the ListControlInsightsByControlDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListControlInsightsByControlDomainResponse> listControlInsightsByControlDomain(
            ListControlInsightsByControlDomainRequest listControlInsightsByControlDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlInsightsByControlDomainRequest.Builder}
     * avoiding the need to create one manually via {@link ListControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListControlInsightsByControlDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListControlInsightsByControlDomainResponse> listControlInsightsByControlDomain(
            Consumer<ListControlInsightsByControlDomainRequest.Builder> listControlInsightsByControlDomainRequest) {
        return listControlInsightsByControlDomain(ListControlInsightsByControlDomainRequest.builder()
                .applyMutation(listControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainPublisher publisher = client.listControlInsightsByControlDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainPublisher publisher = client.listControlInsightsByControlDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlInsightsByControlDomainRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlInsightsByControlDomainPublisher listControlInsightsByControlDomainPaginator(
            ListControlInsightsByControlDomainRequest listControlInsightsByControlDomainRequest) {
        return new ListControlInsightsByControlDomainPublisher(this, listControlInsightsByControlDomainRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainPublisher publisher = client.listControlInsightsByControlDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlInsightsByControlDomainPublisher publisher = client.listControlInsightsByControlDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlInsightsByControlDomain(software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlInsightsByControlDomainRequest.Builder}
     * avoiding the need to create one manually via {@link ListControlInsightsByControlDomainRequest#builder()}
     * </p>
     *
     * @param listControlInsightsByControlDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlInsightsByControlDomainPublisher listControlInsightsByControlDomainPaginator(
            Consumer<ListControlInsightsByControlDomainRequest.Builder> listControlInsightsByControlDomainRequest) {
        return listControlInsightsByControlDomainPaginator(ListControlInsightsByControlDomainRequest.builder()
                .applyMutation(listControlInsightsByControlDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     *
     * @param listControlsRequest
     * @return A Java Future containing the result of the ListControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListControlsResponse> listControls(ListControlsRequest listControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlsRequest.Builder} avoiding the need to
     * create one manually via {@link ListControlsRequest#builder()}
     * </p>
     *
     * @param listControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListControlsResponse> listControls(Consumer<ListControlsRequest.Builder> listControlsRequest) {
        return listControls(ListControlsRequest.builder().applyMutation(listControlsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsPublisher publisher = client.listControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsPublisher publisher = client.listControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation.</b>
     * </p>
     *
     * @param listControlsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListControlsPublisher listControlsPaginator(ListControlsRequest listControlsRequest) {
        return new ListControlsPublisher(this, listControlsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsPublisher publisher = client.listControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListControlsPublisher publisher = client.listControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControls(software.amazon.awssdk.services.auditmanager.model.ListControlsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlsRequest.Builder} avoiding the need to
     * create one manually via {@link ListControlsRequest#builder()}
     * </p>
     *
     * @param listControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListControlsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListControlsPublisher listControlsPaginator(Consumer<ListControlsRequest.Builder> listControlsRequest) {
        return listControlsPaginator(ListControlsRequest.builder().applyMutation(listControlsRequest).build());
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     * @return A Java Future containing the result of the ListKeywordsForDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeywordsForDataSourceResponse> listKeywordsForDataSource(
            ListKeywordsForDataSourceRequest listKeywordsForDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeywordsForDataSourceRequest.Builder} avoiding
     * the need to create one manually via {@link ListKeywordsForDataSourceRequest#builder()}
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListKeywordsForDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeywordsForDataSourceResponse> listKeywordsForDataSource(
            Consumer<ListKeywordsForDataSourceRequest.Builder> listKeywordsForDataSourceRequest) {
        return listKeywordsForDataSource(ListKeywordsForDataSourceRequest.builder()
                .applyMutation(listKeywordsForDataSourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourcePublisher publisher = client.listKeywordsForDataSourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourcePublisher publisher = client.listKeywordsForDataSourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeywordsForDataSourcePublisher listKeywordsForDataSourcePaginator(
            ListKeywordsForDataSourceRequest listKeywordsForDataSourceRequest) {
        return new ListKeywordsForDataSourcePublisher(this, listKeywordsForDataSourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourcePublisher publisher = client.listKeywordsForDataSourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListKeywordsForDataSourcePublisher publisher = client.listKeywordsForDataSourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeywordsForDataSource(software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeywordsForDataSourceRequest.Builder} avoiding
     * the need to create one manually via {@link ListKeywordsForDataSourceRequest#builder()}
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeywordsForDataSourcePublisher listKeywordsForDataSourcePaginator(
            Consumer<ListKeywordsForDataSourceRequest.Builder> listKeywordsForDataSourceRequest) {
        return listKeywordsForDataSourcePaginator(ListKeywordsForDataSourceRequest.builder()
                .applyMutation(listKeywordsForDataSourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(ListNotificationsRequest listNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest) {
        return new ListNotificationsPublisher(this, listNotificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.auditmanager.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource in Audit Manager.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Enables Audit Manager for the specified Amazon Web Services account.
     * </p>
     *
     * @param registerAccountRequest
     * @return A Java Future containing the result of the RegisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterAccountResponse> registerAccount(RegisterAccountRequest registerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Audit Manager for the specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterAccountRequest#builder()}
     * </p>
     *
     * @param registerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterAccountResponse> registerAccount(
            Consumer<RegisterAccountRequest.Builder> registerAccountRequest) {
        return registerAccount(RegisterAccountRequest.builder().applyMutation(registerAccountRequest).build());
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     * </p>
     *
     * @param registerOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the RegisterOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.RegisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOrganizationAdminAccountResponse> registerOrganizationAdminAccount(
            RegisterOrganizationAdminAccountRequest registerOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param registerOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RegisterOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.RegisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOrganizationAdminAccountResponse> registerOrganizationAdminAccount(
            Consumer<RegisterOrganizationAdminAccountRequest.Builder> registerOrganizationAdminAccountRequest) {
        return registerOrganizationAdminAccount(RegisterOrganizationAdminAccountRequest.builder()
                .applyMutation(registerOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Creates a share request for a custom framework in Audit Manager.
     * </p>
     * <p>
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have
     * 120 days to accept or decline the request. If no action is taken, the share request expires.
     * </p>
     * <p>
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N.
     * Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West
     * (Oregon) Amazon Web Services Region.
     * </p>
     * <p>
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sender revokes the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient declines the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient encounters an error and doesn't successfully accept the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The share request expires before the recipient responds to the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a sender <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend"
     * >resends a share request</a>, the snapshot is replaced with an updated version that corresponds with the latest
     * version of the custom framework.
     * </p>
     * <p>
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under
     * the Amazon Web Services Region that was specified in the share request.
     * </p>
     * <important>
     * <p>
     * When you invoke the <code>StartAssessmentFrameworkShare</code> API, you are about to share a custom framework
     * with another Amazon Web Services account. You may not share a custom framework that is derived from a standard
     * framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you
     * have obtained permission to do so from the owner of the standard framework. To learn more about which standard
     * frameworks are eligible for sharing, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility"
     * >Framework sharing eligibility</a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * </important>
     *
     * @param startAssessmentFrameworkShareRequest
     * @return A Java Future containing the result of the StartAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.StartAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/StartAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAssessmentFrameworkShareResponse> startAssessmentFrameworkShare(
            StartAssessmentFrameworkShareRequest startAssessmentFrameworkShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a share request for a custom framework in Audit Manager.
     * </p>
     * <p>
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have
     * 120 days to accept or decline the request. If no action is taken, the share request expires.
     * </p>
     * <p>
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N.
     * Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West
     * (Oregon) Amazon Web Services Region.
     * </p>
     * <p>
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sender revokes the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient declines the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient encounters an error and doesn't successfully accept the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The share request expires before the recipient responds to the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a sender <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend"
     * >resends a share request</a>, the snapshot is replaced with an updated version that corresponds with the latest
     * version of the custom framework.
     * </p>
     * <p>
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under
     * the Amazon Web Services Region that was specified in the share request.
     * </p>
     * <important>
     * <p>
     * When you invoke the <code>StartAssessmentFrameworkShare</code> API, you are about to share a custom framework
     * with another Amazon Web Services account. You may not share a custom framework that is derived from a standard
     * framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you
     * have obtained permission to do so from the owner of the standard framework. To learn more about which standard
     * frameworks are eligible for sharing, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility"
     * >Framework sharing eligibility</a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAssessmentFrameworkShareRequest.Builder}
     * avoiding the need to create one manually via {@link StartAssessmentFrameworkShareRequest#builder()}
     * </p>
     *
     * @param startAssessmentFrameworkShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.StartAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/StartAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAssessmentFrameworkShareResponse> startAssessmentFrameworkShare(
            Consumer<StartAssessmentFrameworkShareRequest.Builder> startAssessmentFrameworkShareRequest) {
        return startAssessmentFrameworkShare(StartAssessmentFrameworkShareRequest.builder()
                .applyMutation(startAssessmentFrameworkShareRequest).build());
    }

    /**
     * <p>
     * Tags the specified resource in Audit Manager.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags the specified resource in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource in Audit Manager.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Edits an Audit Manager assessment.
     * </p>
     *
     * @param updateAssessmentRequest
     * @return A Java Future containing the result of the UpdateAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentResponse> updateAssessment(UpdateAssessmentRequest updateAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Edits an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAssessmentRequest#builder()}
     * </p>
     *
     * @param updateAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentResponse> updateAssessment(
            Consumer<UpdateAssessmentRequest.Builder> updateAssessmentRequest) {
        return updateAssessment(UpdateAssessmentRequest.builder().applyMutation(updateAssessmentRequest).build());
    }

    /**
     * <p>
     * Updates a control within an assessment in Audit Manager.
     * </p>
     *
     * @param updateAssessmentControlRequest
     * @return A Java Future containing the result of the UpdateAssessmentControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentControlResponse> updateAssessmentControl(
            UpdateAssessmentControlRequest updateAssessmentControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a control within an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentControlRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAssessmentControlRequest#builder()}
     * </p>
     *
     * @param updateAssessmentControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAssessmentControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentControlResponse> updateAssessmentControl(
            Consumer<UpdateAssessmentControlRequest.Builder> updateAssessmentControlRequest) {
        return updateAssessmentControl(UpdateAssessmentControlRequest.builder().applyMutation(updateAssessmentControlRequest)
                .build());
    }

    /**
     * <p>
     * Updates the status of a control set in an Audit Manager assessment.
     * </p>
     *
     * @param updateAssessmentControlSetStatusRequest
     * @return A Java Future containing the result of the UpdateAssessmentControlSetStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentControlSetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentControlSetStatusResponse> updateAssessmentControlSetStatus(
            UpdateAssessmentControlSetStatusRequest updateAssessmentControlSetStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a control set in an Audit Manager assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentControlSetStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAssessmentControlSetStatusRequest#builder()}
     * </p>
     *
     * @param updateAssessmentControlSetStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAssessmentControlSetStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentControlSetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentControlSetStatusResponse> updateAssessmentControlSetStatus(
            Consumer<UpdateAssessmentControlSetStatusRequest.Builder> updateAssessmentControlSetStatusRequest) {
        return updateAssessmentControlSetStatus(UpdateAssessmentControlSetStatusRequest.builder()
                .applyMutation(updateAssessmentControlSetStatusRequest).build());
    }

    /**
     * <p>
     * Updates a custom framework in Audit Manager.
     * </p>
     *
     * @param updateAssessmentFrameworkRequest
     * @return A Java Future containing the result of the UpdateAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentFrameworkResponse> updateAssessmentFramework(
            UpdateAssessmentFrameworkRequest updateAssessmentFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentFrameworkRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAssessmentFrameworkRequest#builder()}
     * </p>
     *
     * @param updateAssessmentFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentFrameworkResponse> updateAssessmentFramework(
            Consumer<UpdateAssessmentFrameworkRequest.Builder> updateAssessmentFrameworkRequest) {
        return updateAssessmentFramework(UpdateAssessmentFrameworkRequest.builder()
                .applyMutation(updateAssessmentFrameworkRequest).build());
    }

    /**
     * <p>
     * Updates a share request for a custom framework in Audit Manager.
     * </p>
     *
     * @param updateAssessmentFrameworkShareRequest
     * @return A Java Future containing the result of the UpdateAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentFrameworkShareResponse> updateAssessmentFrameworkShare(
            UpdateAssessmentFrameworkShareRequest updateAssessmentFrameworkShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a share request for a custom framework in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentFrameworkShareRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAssessmentFrameworkShareRequest#builder()}
     * </p>
     *
     * @param updateAssessmentFrameworkShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentFrameworkShareResponse> updateAssessmentFrameworkShare(
            Consumer<UpdateAssessmentFrameworkShareRequest.Builder> updateAssessmentFrameworkShareRequest) {
        return updateAssessmentFrameworkShare(UpdateAssessmentFrameworkShareRequest.builder()
                .applyMutation(updateAssessmentFrameworkShareRequest).build());
    }

    /**
     * <p>
     * Updates the status of an assessment in Audit Manager.
     * </p>
     *
     * @param updateAssessmentStatusRequest
     * @return A Java Future containing the result of the UpdateAssessmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentStatusResponse> updateAssessmentStatus(
            UpdateAssessmentStatusRequest updateAssessmentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of an assessment in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssessmentStatusRequest#builder()}
     * </p>
     *
     * @param updateAssessmentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateAssessmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentStatusResponse> updateAssessmentStatus(
            Consumer<UpdateAssessmentStatusRequest.Builder> updateAssessmentStatusRequest) {
        return updateAssessmentStatus(UpdateAssessmentStatusRequest.builder().applyMutation(updateAssessmentStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates a custom control in Audit Manager.
     * </p>
     *
     * @param updateControlRequest
     * @return A Java Future containing the result of the UpdateControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateControlResponse> updateControl(UpdateControlRequest updateControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a custom control in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateControlRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateControlRequest#builder()}
     * </p>
     *
     * @param updateControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateControlResponse> updateControl(Consumer<UpdateControlRequest.Builder> updateControlRequest) {
        return updateControl(UpdateControlRequest.builder().applyMutation(updateControlRequest).build());
    }

    /**
     * <p>
     * Updates Audit Manager settings for the current account.
     * </p>
     *
     * @param updateSettingsRequest
     * @return A Java Future containing the result of the UpdateSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSettingsResponse> updateSettings(UpdateSettingsRequest updateSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates Audit Manager settings for the current account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSettingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSettingsRequest#builder()}
     * </p>
     *
     * @param updateSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSettingsResponse> updateSettings(Consumer<UpdateSettingsRequest.Builder> updateSettingsRequest) {
        return updateSettings(UpdateSettingsRequest.builder().applyMutation(updateSettingsRequest).build());
    }

    /**
     * <p>
     * Validates the integrity of an assessment report in Audit Manager.
     * </p>
     *
     * @param validateAssessmentReportIntegrityRequest
     * @return A Java Future containing the result of the ValidateAssessmentReportIntegrity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ValidateAssessmentReportIntegrity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateAssessmentReportIntegrityResponse> validateAssessmentReportIntegrity(
            ValidateAssessmentReportIntegrityRequest validateAssessmentReportIntegrityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the integrity of an assessment report in Audit Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateAssessmentReportIntegrityRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateAssessmentReportIntegrityRequest#builder()}
     * </p>
     *
     * @param validateAssessmentReportIntegrityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ValidateAssessmentReportIntegrity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ValidateAssessmentReportIntegrity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateAssessmentReportIntegrityResponse> validateAssessmentReportIntegrity(
            Consumer<ValidateAssessmentReportIntegrityRequest.Builder> validateAssessmentReportIntegrityRequest) {
        return validateAssessmentReportIntegrity(ValidateAssessmentReportIntegrityRequest.builder()
                .applyMutation(validateAssessmentReportIntegrityRequest).build());
    }

    @Override
    default AuditManagerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AuditManagerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AuditManagerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AuditManagerAsyncClient}.
     */
    static AuditManagerAsyncClientBuilder builder() {
        return new DefaultAuditManagerAsyncClientBuilder();
    }
}
