/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentControlRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateAssessmentControlRequest.Builder, UpdateAssessmentControlRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(UpdateAssessmentControlRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(UpdateAssessmentControlRequest::controlSetId))
            .setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()).build();

    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlId").getter(getter(UpdateAssessmentControlRequest::controlId)).setter(setter(Builder::controlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlId").build()).build();

    private static final SdkField<String> CONTROL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlStatus").getter(getter(UpdateAssessmentControlRequest::controlStatusAsString))
            .setter(setter(Builder::controlStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlStatus").build()).build();

    private static final SdkField<String> COMMENT_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commentBody").getter(getter(UpdateAssessmentControlRequest::commentBody))
            .setter(setter(Builder::commentBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD,
            CONTROL_SET_ID_FIELD, CONTROL_ID_FIELD, CONTROL_STATUS_FIELD, COMMENT_BODY_FIELD));

    private final String assessmentId;

    private final String controlSetId;

    private final String controlId;

    private final String controlStatus;

    private final String commentBody;

    private UpdateAssessmentControlRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.controlId = builder.controlId;
        this.controlStatus = builder.controlStatus;
        this.commentBody = builder.commentBody;
    }

    /**
     * <p>
     * The unique identifier for the assessment.
     * </p>
     * 
     * @return The unique identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The unique identifier for the control set.
     * </p>
     * 
     * @return The unique identifier for the control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The unique identifier for the control.
     * </p>
     * 
     * @return The unique identifier for the control.
     */
    public final String controlId() {
        return controlId;
    }

    /**
     * <p>
     * The status of the control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #controlStatus}
     * will return {@link ControlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #controlStatusAsString}.
     * </p>
     * 
     * @return The status of the control.
     * @see ControlStatus
     */
    public final ControlStatus controlStatus() {
        return ControlStatus.fromValue(controlStatus);
    }

    /**
     * <p>
     * The status of the control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #controlStatus}
     * will return {@link ControlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #controlStatusAsString}.
     * </p>
     * 
     * @return The status of the control.
     * @see ControlStatus
     */
    public final String controlStatusAsString() {
        return controlStatus;
    }

    /**
     * <p>
     * The comment body text for the control.
     * </p>
     * 
     * @return The comment body text for the control.
     */
    public final String commentBody() {
        return commentBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(controlId());
        hashCode = 31 * hashCode + Objects.hashCode(controlStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commentBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentControlRequest)) {
            return false;
        }
        UpdateAssessmentControlRequest other = (UpdateAssessmentControlRequest) obj;
        return Objects.equals(assessmentId(), other.assessmentId()) && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(controlId(), other.controlId())
                && Objects.equals(controlStatusAsString(), other.controlStatusAsString())
                && Objects.equals(commentBody(), other.commentBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentControlRequest").add("AssessmentId", assessmentId())
                .add("ControlSetId", controlSetId()).add("ControlId", controlId()).add("ControlStatus", controlStatusAsString())
                .add("CommentBody", commentBody() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "controlId":
            return Optional.ofNullable(clazz.cast(controlId()));
        case "controlStatus":
            return Optional.ofNullable(clazz.cast(controlStatusAsString()));
        case "commentBody":
            return Optional.ofNullable(clazz.cast(commentBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentControlRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssessmentControlRequest> {
        /**
         * <p>
         * The unique identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The unique identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The unique identifier for the control set.
         * </p>
         * 
         * @param controlSetId
         *        The unique identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The unique identifier for the control.
         * </p>
         * 
         * @param controlId
         *        The unique identifier for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlId(String controlId);

        /**
         * <p>
         * The status of the control.
         * </p>
         * 
         * @param controlStatus
         *        The status of the control.
         * @see ControlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlStatus
         */
        Builder controlStatus(String controlStatus);

        /**
         * <p>
         * The status of the control.
         * </p>
         * 
         * @param controlStatus
         *        The status of the control.
         * @see ControlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlStatus
         */
        Builder controlStatus(ControlStatus controlStatus);

        /**
         * <p>
         * The comment body text for the control.
         * </p>
         * 
         * @param commentBody
         *        The comment body text for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentBody(String commentBody);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String assessmentId;

        private String controlSetId;

        private String controlId;

        private String controlStatus;

        private String commentBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentControlRequest model) {
            super(model);
            assessmentId(model.assessmentId);
            controlSetId(model.controlSetId);
            controlId(model.controlId);
            controlStatus(model.controlStatus);
            commentBody(model.commentBody);
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getControlId() {
            return controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getControlStatus() {
            return controlStatus;
        }

        public final void setControlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
        }

        @Override
        public final Builder controlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
            return this;
        }

        @Override
        public final Builder controlStatus(ControlStatus controlStatus) {
            this.controlStatus(controlStatus == null ? null : controlStatus.toString());
            return this;
        }

        public final String getCommentBody() {
            return commentBody;
        }

        public final void setCommentBody(String commentBody) {
            this.commentBody = commentBody;
        }

        @Override
        public final Builder commentBody(String commentBody) {
            this.commentBody = commentBody;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentControlRequest build() {
            return new UpdateAssessmentControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
