/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.ControlComment;
import software.amazon.awssdk.services.auditmanager.model.ControlCommentsCopier;
import software.amazon.awssdk.services.auditmanager.model.ControlResponse;
import software.amazon.awssdk.services.auditmanager.model.ControlStatus;
import software.amazon.awssdk.services.auditmanager.model.EvidenceSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentControl> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssessmentControl.getter(AssessmentControl::id)).setter(AssessmentControl.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssessmentControl.getter(AssessmentControl::name)).setter(AssessmentControl.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssessmentControl.getter(AssessmentControl::description)).setter(AssessmentControl.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AssessmentControl.getter(AssessmentControl::statusAsString)).setter(AssessmentControl.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("response").getter(AssessmentControl.getter(AssessmentControl::responseAsString)).setter(AssessmentControl.setter(Builder::response)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()}).build();
    private static final SdkField<List<ControlComment>> COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("comments").getter(AssessmentControl.getter(AssessmentControl::comments)).setter(AssessmentControl.setter(Builder::comments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlComment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVIDENCE_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evidenceSources").getter(AssessmentControl.getter(AssessmentControl::evidenceSources)).setter(AssessmentControl.setter(Builder::evidenceSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("evidenceCount").getter(AssessmentControl.getter(AssessmentControl::evidenceCount)).setter(AssessmentControl.setter(Builder::evidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceCount").build()}).build();
    private static final SdkField<Integer> ASSESSMENT_REPORT_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("assessmentReportEvidenceCount").getter(AssessmentControl.getter(AssessmentControl::assessmentReportEvidenceCount)).setter(AssessmentControl.setter(Builder::assessmentReportEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportEvidenceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, RESPONSE_FIELD, COMMENTS_FIELD, EVIDENCE_SOURCES_FIELD, EVIDENCE_COUNT_FIELD, ASSESSMENT_REPORT_EVIDENCE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String status;
    private final String response;
    private final List<ControlComment> comments;
    private final List<String> evidenceSources;
    private final Integer evidenceCount;
    private final Integer assessmentReportEvidenceCount;

    private AssessmentControl(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.response = builder.response;
        this.comments = builder.comments;
        this.evidenceSources = builder.evidenceSources;
        this.evidenceCount = builder.evidenceCount;
        this.assessmentReportEvidenceCount = builder.assessmentReportEvidenceCount;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ControlStatus status() {
        return ControlStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ControlResponse response() {
        return ControlResponse.fromValue(this.response);
    }

    public final String responseAsString() {
        return this.response;
    }

    public final boolean hasComments() {
        return this.comments != null && !(this.comments instanceof SdkAutoConstructList);
    }

    public final List<ControlComment> comments() {
        return this.comments;
    }

    public final boolean hasEvidenceSources() {
        return this.evidenceSources != null && !(this.evidenceSources instanceof SdkAutoConstructList);
    }

    public final List<String> evidenceSources() {
        return this.evidenceSources;
    }

    public final Integer evidenceCount() {
        return this.evidenceCount;
    }

    public final Integer assessmentReportEvidenceCount() {
        return this.assessmentReportEvidenceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComments() ? this.comments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvidenceSources() ? this.evidenceSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentReportEvidenceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentControl)) {
            return false;
        }
        AssessmentControl other = (AssessmentControl)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.responseAsString(), other.responseAsString()) && this.hasComments() == other.hasComments() && Objects.equals(this.comments(), other.comments()) && this.hasEvidenceSources() == other.hasEvidenceSources() && Objects.equals(this.evidenceSources(), other.evidenceSources()) && Objects.equals(this.evidenceCount(), other.evidenceCount()) && Objects.equals(this.assessmentReportEvidenceCount(), other.assessmentReportEvidenceCount());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentControl").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("Response", (Object)this.responseAsString()).add("Comments", this.hasComments() ? this.comments() : null).add("EvidenceSources", this.hasEvidenceSources() ? this.evidenceSources() : null).add("EvidenceCount", (Object)this.evidenceCount()).add("AssessmentReportEvidenceCount", (Object)this.assessmentReportEvidenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "response": {
                return Optional.ofNullable(clazz.cast(this.responseAsString()));
            }
            case "comments": {
                return Optional.ofNullable(clazz.cast(this.comments()));
            }
            case "evidenceSources": {
                return Optional.ofNullable(clazz.cast(this.evidenceSources()));
            }
            case "evidenceCount": {
                return Optional.ofNullable(clazz.cast(this.evidenceCount()));
            }
            case "assessmentReportEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.assessmentReportEvidenceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentControl, T> g) {
        return obj -> g.apply((AssessmentControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String status;
        private String response;
        private List<ControlComment> comments = DefaultSdkAutoConstructList.getInstance();
        private List<String> evidenceSources = DefaultSdkAutoConstructList.getInstance();
        private Integer evidenceCount;
        private Integer assessmentReportEvidenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentControl model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.response(model.response);
            this.comments(model.comments);
            this.evidenceSources(model.evidenceSources);
            this.evidenceCount(model.evidenceCount);
            this.assessmentReportEvidenceCount(model.assessmentReportEvidenceCount);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResponse() {
            return this.response;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        @Override
        public final Builder response(ControlResponse response) {
            this.response(response == null ? null : response.toString());
            return this;
        }

        public final List<ControlComment.Builder> getComments() {
            List<ControlComment.Builder> result = ControlCommentsCopier.copyToBuilder(this.comments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComments(Collection<ControlComment.BuilderImpl> comments) {
            this.comments = ControlCommentsCopier.copyFromBuilder(comments);
        }

        @Override
        public final Builder comments(Collection<ControlComment> comments) {
            this.comments = ControlCommentsCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(ControlComment ... comments) {
            this.comments(Arrays.asList(comments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Consumer<ControlComment.Builder> ... comments) {
            this.comments(Stream.of(comments).map(c -> (ControlComment)((ControlComment.Builder)ControlComment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEvidenceSources() {
            if (this.evidenceSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.evidenceSources;
        }

        public final void setEvidenceSources(Collection<String> evidenceSources) {
            this.evidenceSources = EvidenceSourcesCopier.copy(evidenceSources);
        }

        @Override
        public final Builder evidenceSources(Collection<String> evidenceSources) {
            this.evidenceSources = EvidenceSourcesCopier.copy(evidenceSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceSources(String ... evidenceSources) {
            this.evidenceSources(Arrays.asList(evidenceSources));
            return this;
        }

        public final Integer getEvidenceCount() {
            return this.evidenceCount;
        }

        public final void setEvidenceCount(Integer evidenceCount) {
            this.evidenceCount = evidenceCount;
        }

        @Override
        public final Builder evidenceCount(Integer evidenceCount) {
            this.evidenceCount = evidenceCount;
            return this;
        }

        public final Integer getAssessmentReportEvidenceCount() {
            return this.assessmentReportEvidenceCount;
        }

        public final void setAssessmentReportEvidenceCount(Integer assessmentReportEvidenceCount) {
            this.assessmentReportEvidenceCount = assessmentReportEvidenceCount;
        }

        @Override
        public final Builder assessmentReportEvidenceCount(Integer assessmentReportEvidenceCount) {
            this.assessmentReportEvidenceCount = assessmentReportEvidenceCount;
            return this;
        }

        public AssessmentControl build() {
            return new AssessmentControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentControl> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ControlStatus var1);

        public Builder response(String var1);

        public Builder response(ControlResponse var1);

        public Builder comments(Collection<ControlComment> var1);

        public Builder comments(ControlComment ... var1);

        public Builder comments(Consumer<ControlComment.Builder> ... var1);

        public Builder evidenceSources(Collection<String> var1);

        public Builder evidenceSources(String ... var1);

        public Builder evidenceCount(Integer var1);

        public Builder assessmentReportEvidenceCount(Integer var1);
    }
}

