/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSource;
import software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSourcesCopier;
import software.amazon.awssdk.services.auditmanager.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateControlRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, CreateControlRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateControlRequest.getter(CreateControlRequest::name)).setter(CreateControlRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateControlRequest.getter(CreateControlRequest::description)).setter(CreateControlRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TESTING_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testingInformation").getter(CreateControlRequest.getter(CreateControlRequest::testingInformation)).setter(CreateControlRequest.setter(Builder::testingInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testingInformation").build()}).build();
    private static final SdkField<String> ACTION_PLAN_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionPlanTitle").getter(CreateControlRequest.getter(CreateControlRequest::actionPlanTitle)).setter(CreateControlRequest.setter(Builder::actionPlanTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanTitle").build()}).build();
    private static final SdkField<String> ACTION_PLAN_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionPlanInstructions").getter(CreateControlRequest.getter(CreateControlRequest::actionPlanInstructions)).setter(CreateControlRequest.setter(Builder::actionPlanInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanInstructions").build()}).build();
    private static final SdkField<List<CreateControlMappingSource>> CONTROL_MAPPING_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlMappingSources").getter(CreateControlRequest.getter(CreateControlRequest::controlMappingSources)).setter(CreateControlRequest.setter(Builder::controlMappingSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMappingSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateControlMappingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateControlRequest.getter(CreateControlRequest::tags)).setter(CreateControlRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TESTING_INFORMATION_FIELD, ACTION_PLAN_TITLE_FIELD, ACTION_PLAN_INSTRUCTIONS_FIELD, CONTROL_MAPPING_SOURCES_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final String testingInformation;
    private final String actionPlanTitle;
    private final String actionPlanInstructions;
    private final List<CreateControlMappingSource> controlMappingSources;
    private final Map<String, String> tags;

    private CreateControlRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.testingInformation = builder.testingInformation;
        this.actionPlanTitle = builder.actionPlanTitle;
        this.actionPlanInstructions = builder.actionPlanInstructions;
        this.controlMappingSources = builder.controlMappingSources;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String testingInformation() {
        return this.testingInformation;
    }

    public final String actionPlanTitle() {
        return this.actionPlanTitle;
    }

    public final String actionPlanInstructions() {
        return this.actionPlanInstructions;
    }

    public final boolean hasControlMappingSources() {
        return this.controlMappingSources != null && !(this.controlMappingSources instanceof SdkAutoConstructList);
    }

    public final List<CreateControlMappingSource> controlMappingSources() {
        return this.controlMappingSources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.testingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPlanTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPlanInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlMappingSources() ? this.controlMappingSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlRequest)) {
            return false;
        }
        CreateControlRequest other = (CreateControlRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.testingInformation(), other.testingInformation()) && Objects.equals(this.actionPlanTitle(), other.actionPlanTitle()) && Objects.equals(this.actionPlanInstructions(), other.actionPlanInstructions()) && this.hasControlMappingSources() == other.hasControlMappingSources() && Objects.equals(this.controlMappingSources(), other.controlMappingSources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateControlRequest").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("TestingInformation", (Object)(this.testingInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("ActionPlanTitle", (Object)(this.actionPlanTitle() == null ? null : "*** Sensitive Data Redacted ***")).add("ActionPlanInstructions", (Object)(this.actionPlanInstructions() == null ? null : "*** Sensitive Data Redacted ***")).add("ControlMappingSources", this.hasControlMappingSources() ? this.controlMappingSources() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "testingInformation": {
                return Optional.ofNullable(clazz.cast(this.testingInformation()));
            }
            case "actionPlanTitle": {
                return Optional.ofNullable(clazz.cast(this.actionPlanTitle()));
            }
            case "actionPlanInstructions": {
                return Optional.ofNullable(clazz.cast(this.actionPlanInstructions()));
            }
            case "controlMappingSources": {
                return Optional.ofNullable(clazz.cast(this.controlMappingSources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateControlRequest, T> g) {
        return obj -> g.apply((CreateControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String testingInformation;
        private String actionPlanTitle;
        private String actionPlanInstructions;
        private List<CreateControlMappingSource> controlMappingSources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateControlRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.testingInformation(model.testingInformation);
            this.actionPlanTitle(model.actionPlanTitle);
            this.actionPlanInstructions(model.actionPlanInstructions);
            this.controlMappingSources(model.controlMappingSources);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTestingInformation() {
            return this.testingInformation;
        }

        public final void setTestingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
        }

        @Override
        public final Builder testingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
            return this;
        }

        public final String getActionPlanTitle() {
            return this.actionPlanTitle;
        }

        public final void setActionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
        }

        @Override
        public final Builder actionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
            return this;
        }

        public final String getActionPlanInstructions() {
            return this.actionPlanInstructions;
        }

        public final void setActionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
        }

        @Override
        public final Builder actionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
            return this;
        }

        public final List<CreateControlMappingSource.Builder> getControlMappingSources() {
            List<CreateControlMappingSource.Builder> result = CreateControlMappingSourcesCopier.copyToBuilder(this.controlMappingSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlMappingSources(Collection<CreateControlMappingSource.BuilderImpl> controlMappingSources) {
            this.controlMappingSources = CreateControlMappingSourcesCopier.copyFromBuilder(controlMappingSources);
        }

        @Override
        public final Builder controlMappingSources(Collection<CreateControlMappingSource> controlMappingSources) {
            this.controlMappingSources = CreateControlMappingSourcesCopier.copy(controlMappingSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(CreateControlMappingSource ... controlMappingSources) {
            this.controlMappingSources(Arrays.asList(controlMappingSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(Consumer<CreateControlMappingSource.Builder> ... controlMappingSources) {
            this.controlMappingSources(Stream.of(controlMappingSources).map(c -> (CreateControlMappingSource)((CreateControlMappingSource.Builder)CreateControlMappingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateControlRequest build() {
            return new CreateControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateControlRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder testingInformation(String var1);

        public Builder actionPlanTitle(String var1);

        public Builder actionPlanInstructions(String var1);

        public Builder controlMappingSources(Collection<CreateControlMappingSource> var1);

        public Builder controlMappingSources(CreateControlMappingSource ... var1);

        public Builder controlMappingSources(Consumer<CreateControlMappingSource.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

