/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.ChangeLog;
import software.amazon.awssdk.services.auditmanager.model.ChangeLogsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChangeLogsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, GetChangeLogsResponse> {
    private static final SdkField<List<ChangeLog>> CHANGE_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("changeLogs").getter(GetChangeLogsResponse.getter(GetChangeLogsResponse::changeLogs)).setter(GetChangeLogsResponse.setter(Builder::changeLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeLogs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetChangeLogsResponse.getter(GetChangeLogsResponse::nextToken)).setter(GetChangeLogsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_LOGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("changeLogs", CHANGE_LOGS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ChangeLog> changeLogs;
    private final String nextToken;

    private GetChangeLogsResponse(BuilderImpl builder) {
        super(builder);
        this.changeLogs = builder.changeLogs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChangeLogs() {
        return this.changeLogs != null && !(this.changeLogs instanceof SdkAutoConstructList);
    }

    public final List<ChangeLog> changeLogs() {
        return this.changeLogs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeLogs() ? this.changeLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChangeLogsResponse)) {
            return false;
        }
        GetChangeLogsResponse other = (GetChangeLogsResponse)((Object)obj);
        return this.hasChangeLogs() == other.hasChangeLogs() && Objects.equals(this.changeLogs(), other.changeLogs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetChangeLogsResponse").add("ChangeLogs", this.hasChangeLogs() ? this.changeLogs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changeLogs": {
                return Optional.ofNullable(clazz.cast(this.changeLogs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetChangeLogsResponse, T> g) {
        return obj -> g.apply((GetChangeLogsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<ChangeLog> changeLogs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChangeLogsResponse model) {
            super(model);
            this.changeLogs(model.changeLogs);
            this.nextToken(model.nextToken);
        }

        public final List<ChangeLog.Builder> getChangeLogs() {
            List<ChangeLog.Builder> result = ChangeLogsCopier.copyToBuilder(this.changeLogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeLogs(Collection<ChangeLog.BuilderImpl> changeLogs) {
            this.changeLogs = ChangeLogsCopier.copyFromBuilder(changeLogs);
        }

        @Override
        public final Builder changeLogs(Collection<ChangeLog> changeLogs) {
            this.changeLogs = ChangeLogsCopier.copy(changeLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeLogs(ChangeLog ... changeLogs) {
            this.changeLogs(Arrays.asList(changeLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeLogs(Consumer<ChangeLog.Builder> ... changeLogs) {
            this.changeLogs(Stream.of(changeLogs).map(c -> (ChangeLog)((ChangeLog.Builder)ChangeLog.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetChangeLogsResponse build() {
            return new GetChangeLogsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChangeLogsResponse> {
        public Builder changeLogs(Collection<ChangeLog> var1);

        public Builder changeLogs(ChangeLog ... var1);

        public Builder changeLogs(Consumer<ChangeLog.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

