/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentFrameworkShareRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentFrameworkShareRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::id)).setter(AssessmentFrameworkShareRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameworkId").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::frameworkId)).setter(AssessmentFrameworkShareRequest.setter(Builder::frameworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkId").build()}).build();
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameworkName").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::frameworkName)).setter(AssessmentFrameworkShareRequest.setter(Builder::frameworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkName").build()}).build();
    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameworkDescription").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::frameworkDescription)).setter(AssessmentFrameworkShareRequest.setter(Builder::frameworkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::statusAsString)).setter(AssessmentFrameworkShareRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccount").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::sourceAccount)).setter(AssessmentFrameworkShareRequest.setter(Builder::sourceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccount").build()}).build();
    private static final SdkField<String> DESTINATION_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationAccount").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::destinationAccount)).setter(AssessmentFrameworkShareRequest.setter(Builder::destinationAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccount").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationRegion").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::destinationRegion)).setter(AssessmentFrameworkShareRequest.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationTime").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::expirationTime)).setter(AssessmentFrameworkShareRequest.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::creationTime)).setter(AssessmentFrameworkShareRequest.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::lastUpdated)).setter(AssessmentFrameworkShareRequest.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::comment)).setter(AssessmentFrameworkShareRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<Integer> STANDARD_CONTROLS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("standardControlsCount").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::standardControlsCount)).setter(AssessmentFrameworkShareRequest.setter(Builder::standardControlsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardControlsCount").build()}).build();
    private static final SdkField<Integer> CUSTOM_CONTROLS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("customControlsCount").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::customControlsCount)).setter(AssessmentFrameworkShareRequest.setter(Builder::customControlsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customControlsCount").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(AssessmentFrameworkShareRequest.getter(AssessmentFrameworkShareRequest::complianceType)).setter(AssessmentFrameworkShareRequest.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FRAMEWORK_ID_FIELD, FRAMEWORK_NAME_FIELD, FRAMEWORK_DESCRIPTION_FIELD, STATUS_FIELD, SOURCE_ACCOUNT_FIELD, DESTINATION_ACCOUNT_FIELD, DESTINATION_REGION_FIELD, EXPIRATION_TIME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, COMMENT_FIELD, STANDARD_CONTROLS_COUNT_FIELD, CUSTOM_CONTROLS_COUNT_FIELD, COMPLIANCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("frameworkId", FRAMEWORK_ID_FIELD);
            this.put("frameworkName", FRAMEWORK_NAME_FIELD);
            this.put("frameworkDescription", FRAMEWORK_DESCRIPTION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("sourceAccount", SOURCE_ACCOUNT_FIELD);
            this.put("destinationAccount", DESTINATION_ACCOUNT_FIELD);
            this.put("destinationRegion", DESTINATION_REGION_FIELD);
            this.put("expirationTime", EXPIRATION_TIME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("lastUpdated", LAST_UPDATED_FIELD);
            this.put("comment", COMMENT_FIELD);
            this.put("standardControlsCount", STANDARD_CONTROLS_COUNT_FIELD);
            this.put("customControlsCount", CUSTOM_CONTROLS_COUNT_FIELD);
            this.put("complianceType", COMPLIANCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String frameworkId;
    private final String frameworkName;
    private final String frameworkDescription;
    private final String status;
    private final String sourceAccount;
    private final String destinationAccount;
    private final String destinationRegion;
    private final Instant expirationTime;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final String comment;
    private final Integer standardControlsCount;
    private final Integer customControlsCount;
    private final String complianceType;

    private AssessmentFrameworkShareRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.frameworkId = builder.frameworkId;
        this.frameworkName = builder.frameworkName;
        this.frameworkDescription = builder.frameworkDescription;
        this.status = builder.status;
        this.sourceAccount = builder.sourceAccount;
        this.destinationAccount = builder.destinationAccount;
        this.destinationRegion = builder.destinationRegion;
        this.expirationTime = builder.expirationTime;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.comment = builder.comment;
        this.standardControlsCount = builder.standardControlsCount;
        this.customControlsCount = builder.customControlsCount;
        this.complianceType = builder.complianceType;
    }

    public final String id() {
        return this.id;
    }

    public final String frameworkId() {
        return this.frameworkId;
    }

    public final String frameworkName() {
        return this.frameworkName;
    }

    public final String frameworkDescription() {
        return this.frameworkDescription;
    }

    public final ShareRequestStatus status() {
        return ShareRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String sourceAccount() {
        return this.sourceAccount;
    }

    public final String destinationAccount() {
        return this.destinationAccount;
    }

    public final String destinationRegion() {
        return this.destinationRegion;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String comment() {
        return this.comment;
    }

    public final Integer standardControlsCount() {
        return this.standardControlsCount;
    }

    public final Integer customControlsCount() {
        return this.customControlsCount;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.customControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFrameworkShareRequest)) {
            return false;
        }
        AssessmentFrameworkShareRequest other = (AssessmentFrameworkShareRequest)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.frameworkId(), other.frameworkId()) && Objects.equals(this.frameworkName(), other.frameworkName()) && Objects.equals(this.frameworkDescription(), other.frameworkDescription()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceAccount(), other.sourceAccount()) && Objects.equals(this.destinationAccount(), other.destinationAccount()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.standardControlsCount(), other.standardControlsCount()) && Objects.equals(this.customControlsCount(), other.customControlsCount()) && Objects.equals(this.complianceType(), other.complianceType());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentFrameworkShareRequest").add("Id", (Object)this.id()).add("FrameworkId", (Object)this.frameworkId()).add("FrameworkName", (Object)this.frameworkName()).add("FrameworkDescription", (Object)this.frameworkDescription()).add("Status", (Object)this.statusAsString()).add("SourceAccount", (Object)this.sourceAccount()).add("DestinationAccount", (Object)this.destinationAccount()).add("DestinationRegion", (Object)this.destinationRegion()).add("ExpirationTime", (Object)this.expirationTime()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("Comment", (Object)this.comment()).add("StandardControlsCount", (Object)this.standardControlsCount()).add("CustomControlsCount", (Object)this.customControlsCount()).add("ComplianceType", (Object)(this.complianceType() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "frameworkId": {
                return Optional.ofNullable(clazz.cast(this.frameworkId()));
            }
            case "frameworkName": {
                return Optional.ofNullable(clazz.cast(this.frameworkName()));
            }
            case "frameworkDescription": {
                return Optional.ofNullable(clazz.cast(this.frameworkDescription()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sourceAccount": {
                return Optional.ofNullable(clazz.cast(this.sourceAccount()));
            }
            case "destinationAccount": {
                return Optional.ofNullable(clazz.cast(this.destinationAccount()));
            }
            case "destinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "expirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "standardControlsCount": {
                return Optional.ofNullable(clazz.cast(this.standardControlsCount()));
            }
            case "customControlsCount": {
                return Optional.ofNullable(clazz.cast(this.customControlsCount()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFrameworkShareRequest, T> g) {
        return obj -> g.apply((AssessmentFrameworkShareRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String frameworkId;
        private String frameworkName;
        private String frameworkDescription;
        private String status;
        private String sourceAccount;
        private String destinationAccount;
        private String destinationRegion;
        private Instant expirationTime;
        private Instant creationTime;
        private Instant lastUpdated;
        private String comment;
        private Integer standardControlsCount;
        private Integer customControlsCount;
        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFrameworkShareRequest model) {
            this.id(model.id);
            this.frameworkId(model.frameworkId);
            this.frameworkName(model.frameworkName);
            this.frameworkDescription(model.frameworkDescription);
            this.status(model.status);
            this.sourceAccount(model.sourceAccount);
            this.destinationAccount(model.destinationAccount);
            this.destinationRegion(model.destinationRegion);
            this.expirationTime(model.expirationTime);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.comment(model.comment);
            this.standardControlsCount(model.standardControlsCount);
            this.customControlsCount(model.customControlsCount);
            this.complianceType(model.complianceType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFrameworkId() {
            return this.frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final String getFrameworkName() {
            return this.frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkDescription() {
            return this.frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceAccount() {
            return this.sourceAccount;
        }

        public final void setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Override
        public final Builder sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public final String getDestinationAccount() {
            return this.destinationAccount;
        }

        public final void setDestinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @Override
        public final Builder destinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
            return this;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Integer getStandardControlsCount() {
            return this.standardControlsCount;
        }

        public final void setStandardControlsCount(Integer standardControlsCount) {
            this.standardControlsCount = standardControlsCount;
        }

        @Override
        public final Builder standardControlsCount(Integer standardControlsCount) {
            this.standardControlsCount = standardControlsCount;
            return this;
        }

        public final Integer getCustomControlsCount() {
            return this.customControlsCount;
        }

        public final void setCustomControlsCount(Integer customControlsCount) {
            this.customControlsCount = customControlsCount;
        }

        @Override
        public final Builder customControlsCount(Integer customControlsCount) {
            this.customControlsCount = customControlsCount;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public AssessmentFrameworkShareRequest build() {
            return new AssessmentFrameworkShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentFrameworkShareRequest> {
        public Builder id(String var1);

        public Builder frameworkId(String var1);

        public Builder frameworkName(String var1);

        public Builder frameworkDescription(String var1);

        public Builder status(String var1);

        public Builder status(ShareRequestStatus var1);

        public Builder sourceAccount(String var1);

        public Builder destinationAccount(String var1);

        public Builder destinationRegion(String var1);

        public Builder expirationTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder comment(String var1);

        public Builder standardControlsCount(Integer var1);

        public Builder customControlsCount(Integer var1);

        public Builder complianceType(String var1);
    }
}

