/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateDelegationByAssessmentRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, BatchCreateDelegationByAssessmentRequest> {
    private static final SdkField<List<CreateDelegationRequest>> CREATE_DELEGATION_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("createDelegationRequests").getter(BatchCreateDelegationByAssessmentRequest.getter(BatchCreateDelegationByAssessmentRequest::createDelegationRequests)).setter(BatchCreateDelegationByAssessmentRequest.setter(Builder::createDelegationRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDelegationRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateDelegationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(BatchCreateDelegationByAssessmentRequest.getter(BatchCreateDelegationByAssessmentRequest::assessmentId)).setter(BatchCreateDelegationByAssessmentRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DELEGATION_REQUESTS_FIELD, ASSESSMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateDelegationByAssessmentRequest.memberNameToFieldInitializer();
    private final List<CreateDelegationRequest> createDelegationRequests;
    private final String assessmentId;

    private BatchCreateDelegationByAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.createDelegationRequests = builder.createDelegationRequests;
        this.assessmentId = builder.assessmentId;
    }

    public final boolean hasCreateDelegationRequests() {
        return this.createDelegationRequests != null && !(this.createDelegationRequests instanceof SdkAutoConstructList);
    }

    public final List<CreateDelegationRequest> createDelegationRequests() {
        return this.createDelegationRequests;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateDelegationRequests() ? this.createDelegationRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDelegationByAssessmentRequest)) {
            return false;
        }
        BatchCreateDelegationByAssessmentRequest other = (BatchCreateDelegationByAssessmentRequest)((Object)obj);
        return this.hasCreateDelegationRequests() == other.hasCreateDelegationRequests() && Objects.equals(this.createDelegationRequests(), other.createDelegationRequests()) && Objects.equals(this.assessmentId(), other.assessmentId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateDelegationByAssessmentRequest").add("CreateDelegationRequests", (Object)(this.createDelegationRequests() == null ? null : "*** Sensitive Data Redacted ***")).add("AssessmentId", (Object)this.assessmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createDelegationRequests": {
                return Optional.ofNullable(clazz.cast(this.createDelegationRequests()));
            }
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createDelegationRequests", CREATE_DELEGATION_REQUESTS_FIELD);
        map.put("assessmentId", ASSESSMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDelegationByAssessmentRequest, T> g) {
        return obj -> g.apply((BatchCreateDelegationByAssessmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private List<CreateDelegationRequest> createDelegationRequests = DefaultSdkAutoConstructList.getInstance();
        private String assessmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDelegationByAssessmentRequest model) {
            super(model);
            this.createDelegationRequests(model.createDelegationRequests);
            this.assessmentId(model.assessmentId);
        }

        public final List<CreateDelegationRequest.Builder> getCreateDelegationRequests() {
            List<CreateDelegationRequest.Builder> result = CreateDelegationRequestsCopier.copyToBuilder(this.createDelegationRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDelegationRequests(Collection<CreateDelegationRequest.BuilderImpl> createDelegationRequests) {
            this.createDelegationRequests = CreateDelegationRequestsCopier.copyFromBuilder(createDelegationRequests);
        }

        @Override
        public final Builder createDelegationRequests(Collection<CreateDelegationRequest> createDelegationRequests) {
            this.createDelegationRequests = CreateDelegationRequestsCopier.copy(createDelegationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDelegationRequests(CreateDelegationRequest ... createDelegationRequests) {
            this.createDelegationRequests(Arrays.asList(createDelegationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDelegationRequests(Consumer<CreateDelegationRequest.Builder> ... createDelegationRequests) {
            this.createDelegationRequests(Stream.of(createDelegationRequests).map(c -> (CreateDelegationRequest)((CreateDelegationRequest.Builder)CreateDelegationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateDelegationByAssessmentRequest build() {
            return new BatchCreateDelegationByAssessmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateDelegationByAssessmentRequest> {
        public Builder createDelegationRequests(Collection<CreateDelegationRequest> var1);

        public Builder createDelegationRequests(CreateDelegationRequest ... var1);

        public Builder createDelegationRequests(Consumer<CreateDelegationRequest.Builder> ... var1);

        public Builder assessmentId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

