/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.ServiceMetadata;
import software.amazon.awssdk.services.auditmanager.model.ServiceMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServicesInScopeResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, GetServicesInScopeResponse> {
    private static final SdkField<List<ServiceMetadata>> SERVICE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceMetadata").getter(GetServicesInScopeResponse.getter(GetServicesInScopeResponse::serviceMetadata)).setter(GetServicesInScopeResponse.setter(Builder::serviceMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetServicesInScopeResponse.memberNameToFieldInitializer();
    private final List<ServiceMetadata> serviceMetadata;

    private GetServicesInScopeResponse(BuilderImpl builder) {
        super(builder);
        this.serviceMetadata = builder.serviceMetadata;
    }

    public final boolean hasServiceMetadata() {
        return this.serviceMetadata != null && !(this.serviceMetadata instanceof SdkAutoConstructList);
    }

    public final List<ServiceMetadata> serviceMetadata() {
        return this.serviceMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceMetadata() ? this.serviceMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServicesInScopeResponse)) {
            return false;
        }
        GetServicesInScopeResponse other = (GetServicesInScopeResponse)((Object)obj);
        return this.hasServiceMetadata() == other.hasServiceMetadata() && Objects.equals(this.serviceMetadata(), other.serviceMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetServicesInScopeResponse").add("ServiceMetadata", this.hasServiceMetadata() ? this.serviceMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceMetadata": {
                return Optional.ofNullable(clazz.cast(this.serviceMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ServiceMetadata>>> map = new HashMap<String, SdkField<List<ServiceMetadata>>>();
        map.put("serviceMetadata", SERVICE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServicesInScopeResponse, T> g) {
        return obj -> g.apply((GetServicesInScopeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<ServiceMetadata> serviceMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServicesInScopeResponse model) {
            super(model);
            this.serviceMetadata(model.serviceMetadata);
        }

        public final List<ServiceMetadata.Builder> getServiceMetadata() {
            List<ServiceMetadata.Builder> result = ServiceMetadataListCopier.copyToBuilder(this.serviceMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceMetadata(Collection<ServiceMetadata.BuilderImpl> serviceMetadata) {
            this.serviceMetadata = ServiceMetadataListCopier.copyFromBuilder(serviceMetadata);
        }

        @Override
        public final Builder serviceMetadata(Collection<ServiceMetadata> serviceMetadata) {
            this.serviceMetadata = ServiceMetadataListCopier.copy(serviceMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceMetadata(ServiceMetadata ... serviceMetadata) {
            this.serviceMetadata(Arrays.asList(serviceMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceMetadata(Consumer<ServiceMetadata.Builder> ... serviceMetadata) {
            this.serviceMetadata(Stream.of(serviceMetadata).map(c -> (ServiceMetadata)((ServiceMetadata.Builder)ServiceMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetServicesInScopeResponse build() {
            return new GetServicesInScopeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServicesInScopeResponse> {
        public Builder serviceMetadata(Collection<ServiceMetadata> var1);

        public Builder serviceMetadata(ServiceMetadata ... var1);

        public Builder serviceMetadata(Consumer<ServiceMetadata.Builder> ... var1);
    }
}

